/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.common.ssl;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SslConfigurationKeys {
    public static final String PROTOCOLS = "supported_protocols";
    public static final String CIPHERS = "cipher_suites";
    public static final String VERIFICATION_MODE = "verification_mode";
    public static final String CLIENT_AUTH = "client_authentication";
    public static final String CERTIFICATE_AUTHORITIES = "certificate_authorities";
    public static final String TRUSTSTORE_PATH = "truststore.path";
    public static final String TRUSTSTORE_SECURE_PASSWORD = "truststore.secure_password";
    public static final String TRUSTSTORE_LEGACY_PASSWORD = "truststore.password";
    public static final String TRUSTSTORE_TYPE = "truststore.type";
    public static final String TRUSTSTORE_ALGORITHM = "truststore.algorithm";
    public static final String KEYSTORE_PATH = "keystore.path";
    public static final String KEYSTORE_SECURE_PASSWORD = "keystore.secure_password";
    public static final String KEYSTORE_LEGACY_PASSWORD = "keystore.password";
    public static final String KEYSTORE_SECURE_KEY_PASSWORD = "keystore.secure_key_password";
    public static final String KEYSTORE_LEGACY_KEY_PASSWORD = "keystore.key_password";
    public static final String KEYSTORE_TYPE = "keystore.type";
    public static final String KEYSTORE_ALGORITHM = "keystore.algorithm";
    public static final String CERTIFICATE = "certificate";
    public static final String KEY = "key";
    public static final String KEY_SECURE_PASSPHRASE = "secure_key_passphrase";
    public static final String KEY_LEGACY_PASSPHRASE = "key_passphrase";
    private static final Set<String> DEPRECATED_KEYS = new HashSet<String>(Arrays.asList("truststore.password", "keystore.password", "keystore.key_password", "key_passphrase"));

    private SslConfigurationKeys() {
        throw new IllegalStateException("Utility class should not be instantiated");
    }

    public static List<String> getStringKeys() {
        return Arrays.asList(VERIFICATION_MODE, CLIENT_AUTH, TRUSTSTORE_PATH, TRUSTSTORE_LEGACY_PASSWORD, TRUSTSTORE_TYPE, TRUSTSTORE_TYPE, KEYSTORE_PATH, KEYSTORE_LEGACY_PASSWORD, KEYSTORE_LEGACY_KEY_PASSWORD, KEYSTORE_TYPE, KEYSTORE_ALGORITHM, CERTIFICATE, KEY, KEY_LEGACY_PASSPHRASE);
    }

    public static List<String> getListKeys() {
        return Arrays.asList(PROTOCOLS, CIPHERS, CERTIFICATE_AUTHORITIES);
    }

    public static List<String> getSecureStringKeys() {
        return Arrays.asList(TRUSTSTORE_SECURE_PASSWORD, KEYSTORE_SECURE_PASSWORD, KEYSTORE_SECURE_KEY_PASSWORD, KEY_SECURE_PASSPHRASE);
    }

    public static boolean isDeprecated(String key) {
        return DEPRECATED_KEYS.contains(key);
    }
}

