/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.common.xcontent.cbor;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.StreamReadConstraints;
import com.fasterxml.jackson.core.StreamReadFeature;
import com.fasterxml.jackson.dataformat.cbor.CBORFactory;
import io.skylite.common.xcontent.XContentType;
import io.skylite.common.xcontent.cbor.CborXContentGenerator;
import io.skylite.common.xcontent.cbor.CborXContentParser;
import io.skylite.core.xcontent.DeprecationHandler;
import io.skylite.core.xcontent.MediaType;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.XContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentGenerator;
import io.skylite.core.xcontent.XContentParseException;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Set;

public class CborXContent
implements XContent {
    public static final int DEFAULT_MAX_STRING_LEN = Integer.parseInt(System.getProperty("lucenia.xcontent.string.length.max", "50000000"));
    static final CBORFactory cborFactory = new CBORFactory();
    public static final CborXContent cborXContent;

    public static XContentBuilder contentBuilder() throws IOException {
        return XContentBuilder.builder((XContent)cborXContent);
    }

    private CborXContent() {
    }

    public MediaType mediaType() {
        return XContentType.CBOR;
    }

    public byte streamSeparator() {
        throw new XContentParseException("cbor does not support stream parsing...");
    }

    public XContentGenerator createGenerator(OutputStream os, Set<String> includes, Set<String> excludes) throws IOException {
        return new CborXContentGenerator((JsonGenerator)cborFactory.createGenerator(os, JsonEncoding.UTF8), os, includes, excludes);
    }

    public XContentParser createParser(NamedXContentRegistry xContentRegistry, DeprecationHandler deprecationHandler, String content) throws IOException {
        return new CborXContentParser(xContentRegistry, deprecationHandler, cborFactory.createParser(content));
    }

    public XContentParser createParser(NamedXContentRegistry xContentRegistry, DeprecationHandler deprecationHandler, InputStream is) throws IOException {
        return new CborXContentParser(xContentRegistry, deprecationHandler, (JsonParser)cborFactory.createParser(is));
    }

    public XContentParser createParser(NamedXContentRegistry xContentRegistry, DeprecationHandler deprecationHandler, byte[] data) throws IOException {
        return new CborXContentParser(xContentRegistry, deprecationHandler, (JsonParser)cborFactory.createParser(data));
    }

    public XContentParser createParser(NamedXContentRegistry xContentRegistry, DeprecationHandler deprecationHandler, byte[] data, int offset, int length) throws IOException {
        return new CborXContentParser(xContentRegistry, deprecationHandler, (JsonParser)cborFactory.createParser(data, offset, length));
    }

    public XContentParser createParser(NamedXContentRegistry xContentRegistry, DeprecationHandler deprecationHandler, Reader reader) throws IOException {
        return new CborXContentParser(xContentRegistry, deprecationHandler, cborFactory.createParser(reader));
    }

    static {
        cborFactory.configure(JsonFactory.Feature.FAIL_ON_SYMBOL_HASH_OVERFLOW, false);
        cborFactory.configure(JsonGenerator.Feature.AUTO_CLOSE_JSON_CONTENT, false);
        cborFactory.configure(JsonParser.Feature.STRICT_DUPLICATE_DETECTION, true);
        cborFactory.setStreamReadConstraints(StreamReadConstraints.builder().maxStringLength(DEFAULT_MAX_STRING_LEN).build());
        cborFactory.configure(StreamReadFeature.USE_FAST_DOUBLE_PARSER.mappedFeature(), true);
        cborXContent = new CborXContent();
    }
}

