/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.common.xcontent.json;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.StreamReadConstraints;
import com.fasterxml.jackson.core.StreamReadFeature;
import io.skylite.common.xcontent.XContentType;
import io.skylite.common.xcontent.json.JsonXContentGenerator;
import io.skylite.common.xcontent.json.JsonXContentParser;
import io.skylite.core.xcontent.DeprecationHandler;
import io.skylite.core.xcontent.MediaType;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.XContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentGenerator;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Set;

public class JsonXContent
implements XContent {
    public static final int DEFAULT_MAX_STRING_LEN = Integer.parseInt(System.getProperty("lucenia.xcontent.string.length.max", "50000000"));
    private static final JsonFactory jsonFactory = new JsonFactory();
    public static final JsonXContent jsonXContent;

    public static XContentBuilder contentBuilder() throws IOException {
        return XContentBuilder.builder((XContent)jsonXContent);
    }

    private JsonXContent() {
    }

    public MediaType mediaType() {
        return XContentType.JSON;
    }

    public byte streamSeparator() {
        return 10;
    }

    public XContentGenerator createGenerator(OutputStream os, Set<String> includes, Set<String> excludes) throws IOException {
        return new JsonXContentGenerator(jsonFactory.createGenerator(os, JsonEncoding.UTF8), os, includes, excludes);
    }

    public XContentParser createParser(NamedXContentRegistry xContentRegistry, DeprecationHandler deprecationHandler, String content) throws IOException {
        return new JsonXContentParser(xContentRegistry, deprecationHandler, jsonFactory.createParser(content));
    }

    public XContentParser createParser(NamedXContentRegistry xContentRegistry, DeprecationHandler deprecationHandler, InputStream is) throws IOException {
        return new JsonXContentParser(xContentRegistry, deprecationHandler, jsonFactory.createParser(is));
    }

    public XContentParser createParser(NamedXContentRegistry xContentRegistry, DeprecationHandler deprecationHandler, byte[] data) throws IOException {
        return new JsonXContentParser(xContentRegistry, deprecationHandler, jsonFactory.createParser(data));
    }

    public XContentParser createParser(NamedXContentRegistry xContentRegistry, DeprecationHandler deprecationHandler, byte[] data, int offset, int length) throws IOException {
        return new JsonXContentParser(xContentRegistry, deprecationHandler, jsonFactory.createParser(data, offset, length));
    }

    public XContentParser createParser(NamedXContentRegistry xContentRegistry, DeprecationHandler deprecationHandler, Reader reader) throws IOException {
        return new JsonXContentParser(xContentRegistry, deprecationHandler, jsonFactory.createParser(reader));
    }

    static {
        jsonFactory.configure(JsonGenerator.Feature.QUOTE_FIELD_NAMES, true);
        jsonFactory.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        jsonFactory.configure(JsonFactory.Feature.FAIL_ON_SYMBOL_HASH_OVERFLOW, false);
        jsonFactory.configure(JsonGenerator.Feature.AUTO_CLOSE_JSON_CONTENT, false);
        jsonFactory.configure(JsonParser.Feature.STRICT_DUPLICATE_DETECTION, true);
        jsonFactory.setStreamReadConstraints(StreamReadConstraints.builder().maxStringLength(DEFAULT_MAX_STRING_LEN).build());
        jsonFactory.configure(StreamReadFeature.USE_FAST_DOUBLE_PARSER.mappedFeature(), true);
        jsonXContent = new JsonXContent();
    }
}

