/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.common.xcontent.json;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import io.skylite.common.util.io.IOUtils;
import io.skylite.common.xcontent.XContentType;
import io.skylite.core.xcontent.AbstractXContentParser;
import io.skylite.core.xcontent.DeprecationHandler;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.XContentLocation;
import io.skylite.core.xcontent.XContentParser;
import java.io.Closeable;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.CharBuffer;

public class JsonXContentParser
extends AbstractXContentParser {
    final JsonParser parser;

    public JsonXContentParser(NamedXContentRegistry xContentRegistry, DeprecationHandler deprecationHandler, JsonParser parser) {
        super(xContentRegistry, deprecationHandler);
        this.parser = parser;
    }

    public XContentType contentType() {
        return XContentType.JSON;
    }

    public XContentParser.Token nextToken() throws IOException {
        return this.convertToken(this.parser.nextToken());
    }

    public void skipChildren() throws IOException {
        this.parser.skipChildren();
    }

    public XContentParser.Token currentToken() {
        return this.convertToken(this.parser.getCurrentToken());
    }

    public XContentParser.NumberType numberType() throws IOException {
        return this.convertNumberType(this.parser.getNumberType());
    }

    public String currentName() throws IOException {
        return this.parser.getCurrentName();
    }

    protected boolean doBooleanValue() throws IOException {
        return this.parser.getBooleanValue();
    }

    public String text() throws IOException {
        if (this.currentToken().isValue()) {
            return this.parser.getText();
        }
        throw new IllegalStateException("Can't get text on a " + String.valueOf(this.currentToken()) + " at " + String.valueOf(this.getTokenLocation()));
    }

    public CharBuffer charBuffer() throws IOException {
        return CharBuffer.wrap(this.parser.getTextCharacters(), this.parser.getTextOffset(), this.parser.getTextLength());
    }

    public Object objectText() throws IOException {
        JsonToken currentToken = this.parser.getCurrentToken();
        if (currentToken == JsonToken.VALUE_STRING) {
            return this.text();
        }
        if (currentToken == JsonToken.VALUE_NUMBER_INT || currentToken == JsonToken.VALUE_NUMBER_FLOAT) {
            return this.parser.getNumberValue();
        }
        if (currentToken == JsonToken.VALUE_TRUE) {
            return Boolean.TRUE;
        }
        if (currentToken == JsonToken.VALUE_FALSE) {
            return Boolean.FALSE;
        }
        if (currentToken == JsonToken.VALUE_NULL) {
            return null;
        }
        return this.text();
    }

    public Object objectBytes() throws IOException {
        JsonToken currentToken = this.parser.getCurrentToken();
        if (currentToken == JsonToken.VALUE_STRING) {
            return this.charBuffer();
        }
        if (currentToken == JsonToken.VALUE_NUMBER_INT || currentToken == JsonToken.VALUE_NUMBER_FLOAT) {
            return this.parser.getNumberValue();
        }
        if (currentToken == JsonToken.VALUE_TRUE) {
            return Boolean.TRUE;
        }
        if (currentToken == JsonToken.VALUE_FALSE) {
            return Boolean.FALSE;
        }
        if (currentToken == JsonToken.VALUE_NULL) {
            return null;
        }
        return this.charBuffer();
    }

    public boolean hasTextCharacters() {
        return this.parser.hasTextCharacters();
    }

    public char[] textCharacters() throws IOException {
        return this.parser.getTextCharacters();
    }

    public int textLength() throws IOException {
        return this.parser.getTextLength();
    }

    public int textOffset() throws IOException {
        return this.parser.getTextOffset();
    }

    public Number numberValue() throws IOException {
        return this.parser.getNumberValue();
    }

    public short doShortValue() throws IOException {
        return this.parser.getShortValue();
    }

    public int doIntValue() throws IOException {
        return this.parser.getIntValue();
    }

    public long doLongValue() throws IOException {
        return this.parser.getLongValue();
    }

    public float doFloatValue() throws IOException {
        return this.parser.getFloatValue();
    }

    public double doDoubleValue() throws IOException {
        return this.parser.getDoubleValue();
    }

    public BigInteger doBigIntegerValue() throws IOException {
        if (this.parser.getCurrentToken() == JsonToken.VALUE_NUMBER_FLOAT) {
            return this.parser.getDecimalValue().toBigInteger();
        }
        return this.parser.getBigIntegerValue();
    }

    public byte[] binaryValue() throws IOException {
        return this.parser.getBinaryValue();
    }

    public XContentLocation getTokenLocation() {
        JsonLocation loc = this.parser.getTokenLocation();
        if (loc == null) {
            return null;
        }
        return new XContentLocation(loc.getLineNr(), loc.getColumnNr());
    }

    public void close() {
        IOUtils.closeWhileHandlingException((Closeable)this.parser);
    }

    private XContentParser.NumberType convertNumberType(JsonParser.NumberType numberType) {
        switch (numberType) {
            case INT: {
                return XContentParser.NumberType.INT;
            }
            case BIG_INTEGER: {
                return XContentParser.NumberType.BIG_INTEGER;
            }
            case LONG: {
                return XContentParser.NumberType.LONG;
            }
            case FLOAT: {
                return XContentParser.NumberType.FLOAT;
            }
            case DOUBLE: {
                return XContentParser.NumberType.DOUBLE;
            }
            case BIG_DECIMAL: {
                return XContentParser.NumberType.BIG_DECIMAL;
            }
        }
        throw new IllegalStateException("No matching token for number_type [" + String.valueOf(numberType) + "]");
    }

    private XContentParser.Token convertToken(JsonToken token) {
        if (token == null) {
            return null;
        }
        switch (token) {
            case FIELD_NAME: {
                return XContentParser.Token.FIELD_NAME;
            }
            case VALUE_FALSE: 
            case VALUE_TRUE: {
                return XContentParser.Token.VALUE_BOOLEAN;
            }
            case VALUE_STRING: {
                return XContentParser.Token.VALUE_STRING;
            }
            case VALUE_NUMBER_INT: 
            case VALUE_NUMBER_FLOAT: {
                return XContentParser.Token.VALUE_NUMBER;
            }
            case VALUE_NULL: {
                return XContentParser.Token.VALUE_NULL;
            }
            case START_OBJECT: {
                return XContentParser.Token.START_OBJECT;
            }
            case END_OBJECT: {
                return XContentParser.Token.END_OBJECT;
            }
            case START_ARRAY: {
                return XContentParser.Token.START_ARRAY;
            }
            case END_ARRAY: {
                return XContentParser.Token.END_ARRAY;
            }
            case VALUE_EMBEDDED_OBJECT: {
                return XContentParser.Token.VALUE_EMBEDDED_OBJECT;
            }
        }
        throw new IllegalStateException("No matching token for json_token [" + String.valueOf(token) + "]");
    }

    public boolean isClosed() {
        return this.parser.isClosed();
    }
}

