/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.telemetry.tracing.runnable;

import io.skylite.common.telemetry.tracing.ScopedSpan;
import io.skylite.common.telemetry.tracing.SpanCreationContext;
import io.skylite.common.telemetry.tracing.Tracer;

public class TraceableRunnable
implements Runnable {
    private final Runnable runnable;
    private final SpanCreationContext spanCreationContext;
    private final Tracer tracer;

    public TraceableRunnable(Tracer tracer, SpanCreationContext spanCreationContext, Runnable runnable) {
        this.tracer = tracer;
        this.spanCreationContext = spanCreationContext;
        this.runnable = runnable;
    }

    @Override
    public void run() {
        try (ScopedSpan spanScope = this.tracer.startScopedSpan(this.spanCreationContext);){
            this.runnable.run();
        }
    }
}

