/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.index.reindex;

import io.lucenia.client.RestClient;
import io.lucenia.client.RestClientBuilder;
import io.lucenia.index.reindex.AbstractAsyncBulkByScrollAction;
import io.lucenia.index.reindex.BulkByScrollParallelizationHelper;
import io.lucenia.index.reindex.ReindexSslConfig;
import io.lucenia.index.reindex.TransportReindexAction;
import io.lucenia.index.reindex.remote.RemoteScrollableHitSource;
import io.lucenia.index.reindex.spi.RemoteReindexExtension;
import io.skylite.common.action.ActionListener;
import io.skylite.core.ParseField;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.DocWriteRequest;
import io.skylite.core.action.bulk.BackoffPolicy;
import io.skylite.core.action.bulk.BulkItemResponse;
import io.skylite.core.action.index.IndexRequest;
import io.skylite.core.client.Client;
import io.skylite.core.client.ParentTaskAssigningClient;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.Strings;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.index.VersionType;
import io.skylite.core.script.Script;
import io.skylite.core.script.ScriptService;
import io.skylite.core.tasks.Task;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.xcontent.DeprecationHandler;
import io.skylite.core.xcontent.MediaType;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.XContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManager;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManagerBuilder;
import org.apache.hc.client5.http.nio.AsyncClientConnectionManager;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.util.Timeout;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.index.reindex.BulkByScrollResponse;
import org.opensearch.index.reindex.BulkByScrollTask;
import org.opensearch.index.reindex.ReindexAction;
import org.opensearch.index.reindex.ReindexRequest;
import org.opensearch.index.reindex.RemoteInfo;
import org.opensearch.index.reindex.ScrollableHitSource;
import org.opensearch.index.reindex.WorkerBulkByScrollTaskState;

public class Reindexer {
    private static final Logger logger = LogManager.getLogger(Reindexer.class);
    private final ClusterService clusterService;
    private final Client client;
    private final ThreadPool threadPool;
    private final ScriptService scriptService;
    private final ReindexSslConfig reindexSslConfig;
    private final Optional<RemoteReindexExtension> remoteExtension;

    Reindexer(ClusterService clusterService, Client client, ThreadPool threadPool, ScriptService scriptService, ReindexSslConfig reindexSslConfig) {
        this(clusterService, client, threadPool, scriptService, reindexSslConfig, Optional.empty());
    }

    Reindexer(ClusterService clusterService, Client client, ThreadPool threadPool, ScriptService scriptService, ReindexSslConfig reindexSslConfig, Optional<RemoteReindexExtension> remoteExtension) {
        this.clusterService = clusterService;
        this.client = client;
        this.threadPool = threadPool;
        this.scriptService = scriptService;
        this.reindexSslConfig = reindexSslConfig;
        this.remoteExtension = remoteExtension;
    }

    public void initTask(BulkByScrollTask task, ReindexRequest request, ActionListener<Void> listener) {
        BulkByScrollParallelizationHelper.initTaskState(task, request, this.client, listener);
    }

    public void execute(BulkByScrollTask task, ReindexRequest request, ActionListener<BulkByScrollResponse> listener) {
        ActionListener<BulkByScrollResponse> remoteReindexActionListener = this.getRemoteReindexWrapperListener(listener, request);
        BulkByScrollParallelizationHelper.executeSlicedAction(task, request, (ActionType<BulkByScrollResponse>)ReindexAction.INSTANCE, listener, this.client, this.clusterService.localNode(), () -> {
            ParentTaskAssigningClient assigningClient = new ParentTaskAssigningClient(this.client, this.clusterService.localNode(), (Task)task);
            AsyncIndexBySearchAction searchAction = new AsyncIndexBySearchAction(task, logger, assigningClient, this.threadPool, this.scriptService, this.reindexSslConfig, request, remoteReindexActionListener, this.getInterceptor(request));
            searchAction.start();
        });
    }

    private Optional<HttpRequestInterceptor> getInterceptor(ReindexRequest request) {
        if (request.getRemoteInfo() == null) {
            return Optional.empty();
        }
        return this.remoteExtension.map(x -> x.getInterceptorProvider()).flatMap(provider -> provider.getRestInterceptor(request, this.threadPool.getThreadContext()));
    }

    private ActionListener<BulkByScrollResponse> getRemoteReindexWrapperListener(ActionListener<BulkByScrollResponse> listener, ReindexRequest reindexRequest) {
        if (reindexRequest.getRemoteInfo() == null) {
            return listener;
        }
        if (this.remoteExtension.isPresent()) {
            return this.remoteExtension.get().getRemoteReindexActionListener(listener, reindexRequest);
        }
        logger.info("No extension found for remote reindex listener");
        return listener;
    }

    static RestClient buildRestClient(RemoteInfo remoteInfo, ReindexSslConfig sslConfig, long taskId, List<Thread> threadCollector) {
        return Reindexer.buildRestClient(remoteInfo, sslConfig, taskId, threadCollector, Optional.empty());
    }

    static RestClient buildRestClient(RemoteInfo remoteInfo, ReindexSslConfig sslConfig, long taskId, List<Thread> threadCollector, Optional<HttpRequestInterceptor> restInterceptor) {
        Header[] clientHeaders = new Header[remoteInfo.getHeaders().size()];
        int i = 0;
        for (Map.Entry header : remoteInfo.getHeaders().entrySet()) {
            clientHeaders[i++] = new BasicHeader((String)header.getKey(), header.getValue());
        }
        HttpHost httpHost = new HttpHost(remoteInfo.getScheme(), remoteInfo.getHost(), remoteInfo.getPort());
        RestClientBuilder builder = RestClient.builder((HttpHost[])new HttpHost[]{httpHost}).setDefaultHeaders(clientHeaders).setRequestConfigCallback(c -> {
            c.setConnectTimeout(Timeout.ofMilliseconds((long)Math.toIntExact(remoteInfo.getConnectTimeout().millis())));
            c.setResponseTimeout(Timeout.ofMilliseconds((long)Math.toIntExact(remoteInfo.getSocketTimeout().millis())));
            return c;
        }).setHttpClientConfigCallback(c -> {
            if (remoteInfo.getUsername() != null) {
                UsernamePasswordCredentials creds = new UsernamePasswordCredentials(remoteInfo.getUsername(), remoteInfo.getPassword().toCharArray());
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(new AuthScope(httpHost, null, "Basic"), (Credentials)creds);
                c.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
            } else {
                restInterceptor.ifPresent(interceptor -> c.addRequestInterceptorLast(interceptor));
            }
            AtomicInteger threads = new AtomicInteger();
            c.setThreadFactory(r -> {
                String name = "es-client-" + taskId + "-" + threads.getAndIncrement();
                Thread t = new Thread(r, name);
                threadCollector.add(t);
                return t;
            });
            c.setIOReactorConfig(IOReactorConfig.custom().setIoThreadCount(1).build());
            PoolingAsyncClientConnectionManager connectionManager = PoolingAsyncClientConnectionManagerBuilder.create().setTlsStrategy(sslConfig.getStrategy()).build();
            c.setConnectionManager((AsyncClientConnectionManager)connectionManager);
            return c;
        });
        if (Strings.hasLength((String)remoteInfo.getPathPrefix()) && !"/".equals(remoteInfo.getPathPrefix())) {
            builder.setPathPrefix(remoteInfo.getPathPrefix());
        }
        return builder.build();
    }

    static class AsyncIndexBySearchAction
    extends AbstractAsyncBulkByScrollAction<ReindexRequest, TransportReindexAction> {
        private List<Thread> createdThreads = Collections.emptyList();

        AsyncIndexBySearchAction(BulkByScrollTask task, Logger logger, ParentTaskAssigningClient client, ThreadPool threadPool, ScriptService scriptService, ReindexSslConfig sslConfig, ReindexRequest request, ActionListener<BulkByScrollResponse> listener) {
            this(task, logger, client, threadPool, scriptService, sslConfig, request, listener, Optional.empty());
        }

        AsyncIndexBySearchAction(BulkByScrollTask task, Logger logger, ParentTaskAssigningClient client, ThreadPool threadPool, ScriptService scriptService, ReindexSslConfig sslConfig, ReindexRequest request, ActionListener<BulkByScrollResponse> listener, Optional<HttpRequestInterceptor> interceptor) {
            super(task, request.getDestination().versionType() != VersionType.INTERNAL, false, logger, client, threadPool, request, listener, scriptService, sslConfig, interceptor);
        }

        @Override
        protected ScrollableHitSource buildScrollableResultSource(BackoffPolicy backoffPolicy) {
            if (((ReindexRequest)this.mainRequest).getRemoteInfo() != null) {
                RemoteInfo remoteInfo = ((ReindexRequest)this.mainRequest).getRemoteInfo();
                this.createdThreads = Collections.synchronizedList(new ArrayList());
                assert (this.sslConfig != null) : "Reindex ssl config must be set";
                RestClient restClient = Reindexer.buildRestClient(remoteInfo, this.sslConfig, this.task.getId(), this.createdThreads, this.interceptor);
                return new RemoteScrollableHitSource(this.logger, backoffPolicy, this.threadPool, () -> ((WorkerBulkByScrollTaskState)this.worker).countSearchRetry(), this::onScrollResponse, this::finishHim, restClient, remoteInfo.getQuery(), ((ReindexRequest)this.mainRequest).getSearchRequest());
            }
            return super.buildScrollableResultSource(backoffPolicy);
        }

        @Override
        protected void finishHim(Exception failure, List<BulkItemResponse.Failure> indexingFailures, List<ScrollableHitSource.SearchFailure> searchFailures, boolean timedOut) {
            super.finishHim(failure, indexingFailures, searchFailures, timedOut);
            for (Thread thread : this.createdThreads) {
                if (!thread.isAlive()) continue;
                assert (false) : "Failed to properly stop client thread [" + thread.getName() + "]";
                this.logger.error("Failed to properly stop client thread [{}]", (Object)thread.getName());
            }
        }

        @Override
        public BiFunction<AbstractAsyncBulkByScrollAction.RequestWrapper<?>, ScrollableHitSource.Hit, AbstractAsyncBulkByScrollAction.RequestWrapper<?>> buildScriptApplier() {
            Script script = ((ReindexRequest)this.mainRequest).getScript();
            if (script != null) {
                assert (this.scriptService != null) : "Script service must be set";
                return new ReindexScriptApplier(this, this.worker, this.scriptService, script, script.getParams());
            }
            return super.buildScriptApplier();
        }

        @Override
        protected AbstractAsyncBulkByScrollAction.RequestWrapper<IndexRequest> buildRequest(ScrollableHitSource.Hit doc) {
            IndexRequest index;
            block25: {
                index = new IndexRequest();
                index.index(((ReindexRequest)this.mainRequest).getDestination().index());
                index.versionType(((ReindexRequest)this.mainRequest).getDestination().versionType());
                if (index.versionType() == VersionType.INTERNAL) {
                    assert (doc.getVersion() == -1L) : "fetched version when we didn't have to";
                    index.version(((ReindexRequest)this.mainRequest).getDestination().version());
                } else {
                    index.version(doc.getVersion());
                }
                index.id(doc.getId());
                MediaType sourceMediaType = doc.getMediaType();
                MediaType mainRequestMediaType = ((ReindexRequest)this.mainRequest).getDestination().getContentType();
                if (mainRequestMediaType != null && doc.getMediaType() != mainRequestMediaType) {
                    try (StreamInput stream = doc.getSource().streamInput();
                         XContentParser parser = sourceMediaType.xContent().createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, (InputStream)stream);
                         XContentBuilder builder = XContentBuilder.builder((XContent)mainRequestMediaType.xContent());){
                        parser.nextToken();
                        builder.copyCurrentStructure(parser);
                        index.source(BytesReference.bytes((XContentBuilder)builder), builder.contentType());
                        break block25;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException("failed to convert hit from " + String.valueOf(sourceMediaType) + " to " + String.valueOf(mainRequestMediaType), e);
                    }
                }
                index.source(doc.getSource(), doc.getMediaType());
            }
            index.routing(((ReindexRequest)this.mainRequest).getDestination().routing());
            index.setPipeline(((ReindexRequest)this.mainRequest).getDestination().getPipeline());
            if (((ReindexRequest)this.mainRequest).getDestination().opType() == DocWriteRequest.OpType.CREATE) {
                index.opType(((ReindexRequest)this.mainRequest).getDestination().opType());
            }
            return AsyncIndexBySearchAction.wrap(index);
        }

        @Override
        protected void copyRouting(AbstractAsyncBulkByScrollAction.RequestWrapper<?> request, String routing) {
            String routingSpec = ((ReindexRequest)this.mainRequest).getDestination().routing();
            if (routingSpec == null) {
                super.copyRouting(request, routing);
                return;
            }
            if (routingSpec.startsWith("=")) {
                super.copyRouting(request, ((ReindexRequest)this.mainRequest).getDestination().routing().substring(1));
                return;
            }
            switch (routingSpec) {
                case "keep": {
                    super.copyRouting(request, routing);
                    break;
                }
                case "discard": {
                    super.copyRouting(request, null);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported routing command");
                }
            }
        }

        class ReindexScriptApplier
        extends AbstractAsyncBulkByScrollAction.ScriptApplier {
            ReindexScriptApplier(AsyncIndexBySearchAction this$0, WorkerBulkByScrollTaskState taskWorker, ScriptService scriptService, Script script, Map<String, Object> params) {
                super(taskWorker, scriptService, script, params);
            }

            @Override
            protected void scriptChangedIndex(AbstractAsyncBulkByScrollAction.RequestWrapper<?> request, Object to) {
                Objects.requireNonNull(to, "Can't reindex without a destination index!");
                request.setIndex(to.toString());
            }

            @Override
            protected void scriptChangedId(AbstractAsyncBulkByScrollAction.RequestWrapper<?> request, Object to) {
                request.setId(Objects.toString(to, null));
            }

            @Override
            protected void scriptChangedVersion(AbstractAsyncBulkByScrollAction.RequestWrapper<?> request, Object to) {
                if (to == null) {
                    request.setVersion(-3L);
                    request.setVersionType(VersionType.INTERNAL);
                } else {
                    request.setVersion(this.asLong(to, ParseField.CommonMetaFields.VERSION_FIELD.getPreferredName()));
                }
            }

            @Override
            protected void scriptChangedRouting(AbstractAsyncBulkByScrollAction.RequestWrapper<?> request, Object to) {
                request.setRouting(Objects.toString(to, null));
            }

            private long asLong(Object from, String name) {
                Number fromNumber;
                try {
                    fromNumber = (Number)from;
                }
                catch (ClassCastException e) {
                    throw new IllegalArgumentException(name + " may only be set to an int or a long but was [" + String.valueOf(from) + "]", e);
                }
                long l = fromNumber.longValue();
                if (fromNumber.doubleValue() != (double)l) {
                    throw new IllegalArgumentException(name + " may only be set to an int or a long but was [" + String.valueOf(from) + "]");
                }
                return l;
            }
        }
    }
}

