/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.index.reindex;

import io.lucenia.index.reindex.AsyncDeleteByQueryAction;
import io.lucenia.index.reindex.BulkByScrollParallelizationHelper;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.client.Client;
import io.skylite.core.client.ParentTaskAssigningClient;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.script.ScriptService;
import io.skylite.core.tasks.Task;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import org.opensearch.index.reindex.BulkByScrollResponse;
import org.opensearch.index.reindex.BulkByScrollTask;
import org.opensearch.index.reindex.DeleteByQueryAction;
import org.opensearch.index.reindex.DeleteByQueryRequest;

public class TransportDeleteByQueryAction
extends HandledTransportAction<DeleteByQueryRequest, BulkByScrollResponse> {
    private final ThreadPool threadPool;
    private final Client client;
    private final ScriptService scriptService;
    private final ClusterService clusterService;

    @Inject
    public TransportDeleteByQueryAction(ThreadPool threadPool, ActionFilters actionFilters, Client client, TransportService transportService, ScriptService scriptService, ClusterService clusterService) {
        super("indices:data/write/delete/byquery", transportService, actionFilters, DeleteByQueryRequest::new);
        this.threadPool = threadPool;
        this.client = client;
        this.scriptService = scriptService;
        this.clusterService = clusterService;
    }

    public void doExecute(Task task, DeleteByQueryRequest request, ActionListener<BulkByScrollResponse> listener) {
        BulkByScrollTask bulkByScrollTask = (BulkByScrollTask)task;
        BulkByScrollParallelizationHelper.startSlicedAction(request, bulkByScrollTask, (ActionType<BulkByScrollResponse>)DeleteByQueryAction.INSTANCE, listener, this.client, this.clusterService.localNode(), () -> {
            ParentTaskAssigningClient assigningClient = new ParentTaskAssigningClient(this.client, this.clusterService.localNode(), (Task)bulkByScrollTask);
            new AsyncDeleteByQueryAction(bulkByScrollTask, this.logger, assigningClient, this.threadPool, request, this.scriptService, listener).start();
        });
    }
}

