/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.math.kernel;

import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import com.oracle.labs.mlrg.olcut.config.Config;
import com.oracle.labs.mlrg.olcut.config.Configurable;
import com.oracle.labs.mlrg.olcut.provenance.ConfiguredObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.impl.ConfiguredObjectProvenanceImpl;
import java.util.Objects;
import org.tribuo.math.kernel.Kernel;
import org.tribuo.math.la.SparseVector;
import org.tribuo.math.protos.KernelProto;
import org.tribuo.math.protos.PolynomialKernelProto;
import org.tribuo.protos.ProtoSerializable;
import org.tribuo.protos.ProtoSerializableClass;
import org.tribuo.protos.ProtoSerializableField;
import org.tribuo.protos.ProtoUtil;

@ProtoSerializableClass(version=0, serializedDataClass=PolynomialKernelProto.class)
public class Polynomial
implements Kernel {
    private static final long serialVersionUID = 1L;
    public static final int CURRENT_VERSION = 0;
    @Config(mandatory=true, description="Coefficient to multiply the dot product by.")
    @ProtoSerializableField
    private double gamma;
    @Config(mandatory=true, description="Scalar to add to the dot product.")
    @ProtoSerializableField
    private double intercept;
    @Config(mandatory=true, description="Degree of the polynomial.")
    @ProtoSerializableField
    private double degree;

    private Polynomial() {
    }

    public Polynomial(double gamma, double intercept, double degree) {
        this.gamma = gamma;
        this.intercept = intercept;
        this.degree = degree;
    }

    public static Polynomial deserializeFromProto(int version, String className, Any message) throws InvalidProtocolBufferException {
        if (version < 0 || version > 0) {
            throw new IllegalArgumentException("Unknown version " + version + ", this class supports at most version " + 0);
        }
        PolynomialKernelProto kernelProto = (PolynomialKernelProto)message.unpack(PolynomialKernelProto.class);
        return new Polynomial(kernelProto.getGamma(), kernelProto.getIntercept(), kernelProto.getDegree());
    }

    public KernelProto serialize() {
        return (KernelProto)ProtoUtil.serialize((ProtoSerializable)this);
    }

    @Override
    public double similarity(SparseVector a, SparseVector b) {
        return Math.pow(this.gamma * a.dot(b) + this.intercept, this.degree);
    }

    public String toString() {
        return "Polynomial(gamma=" + this.gamma + ",intercept=" + this.intercept + ",degree=" + this.degree + ")";
    }

    public ConfiguredObjectProvenance getProvenance() {
        return new ConfiguredObjectProvenanceImpl((Configurable)this, "Kernel");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Polynomial that = (Polynomial)o;
        return Double.compare(that.gamma, this.gamma) == 0 && Double.compare(that.intercept, this.intercept) == 0 && Double.compare(that.degree, this.degree) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.gamma, this.intercept, this.degree);
    }
}

