/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.math.kernel;

import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import com.oracle.labs.mlrg.olcut.config.Config;
import com.oracle.labs.mlrg.olcut.config.Configurable;
import com.oracle.labs.mlrg.olcut.provenance.ConfiguredObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.impl.ConfiguredObjectProvenanceImpl;
import java.util.Objects;
import org.tribuo.math.kernel.Kernel;
import org.tribuo.math.la.SparseVector;
import org.tribuo.math.protos.KernelProto;
import org.tribuo.math.protos.RBFKernelProto;
import org.tribuo.protos.ProtoSerializable;
import org.tribuo.protos.ProtoSerializableClass;
import org.tribuo.protos.ProtoSerializableField;
import org.tribuo.protos.ProtoUtil;

@ProtoSerializableClass(version=0, serializedDataClass=RBFKernelProto.class)
public class RBF
implements Kernel {
    private static final long serialVersionUID = 1L;
    public static final int CURRENT_VERSION = 0;
    @Config(mandatory=true, description="Kernel output = exp(-gamma*|u-v|^2).")
    @ProtoSerializableField
    private double gamma;

    private RBF() {
    }

    public RBF(double gamma) {
        this.gamma = gamma;
    }

    public static RBF deserializeFromProto(int version, String className, Any message) throws InvalidProtocolBufferException {
        if (version < 0 || version > 0) {
            throw new IllegalArgumentException("Unknown version " + version + ", this class supports at most version " + 0);
        }
        RBFKernelProto kernelProto = (RBFKernelProto)message.unpack(RBFKernelProto.class);
        return new RBF(kernelProto.getGamma());
    }

    public KernelProto serialize() {
        return (KernelProto)ProtoUtil.serialize((ProtoSerializable)this);
    }

    @Override
    public double similarity(SparseVector a, SparseVector b) {
        return Math.exp(-this.gamma * Math.pow(a.subtract(b).twoNorm(), 2.0));
    }

    public String toString() {
        return "RBF(gamma=" + this.gamma + ")";
    }

    public ConfiguredObjectProvenance getProvenance() {
        return new ConfiguredObjectProvenanceImpl((Configurable)this, "Kernel");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RBF rbf = (RBF)o;
        return Double.compare(rbf.gamma, this.gamma) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.gamma);
    }
}

