/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.math.kernel;

import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import com.oracle.labs.mlrg.olcut.config.Config;
import com.oracle.labs.mlrg.olcut.config.Configurable;
import com.oracle.labs.mlrg.olcut.provenance.ConfiguredObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.impl.ConfiguredObjectProvenanceImpl;
import java.util.Objects;
import org.tribuo.math.kernel.Kernel;
import org.tribuo.math.la.SparseVector;
import org.tribuo.math.protos.KernelProto;
import org.tribuo.math.protos.SigmoidKernelProto;
import org.tribuo.protos.ProtoSerializable;
import org.tribuo.protos.ProtoSerializableClass;
import org.tribuo.protos.ProtoSerializableField;
import org.tribuo.protos.ProtoUtil;

@ProtoSerializableClass(version=0, serializedDataClass=SigmoidKernelProto.class)
public class Sigmoid
implements Kernel {
    private static final long serialVersionUID = 1L;
    public static final int CURRENT_VERSION = 0;
    @Config(mandatory=true, description="Coefficient to multiply the dot product by.")
    @ProtoSerializableField
    private double gamma;
    @Config(mandatory=true, description="Scalar intercept to add to the dot product.")
    @ProtoSerializableField
    private double intercept;

    private Sigmoid() {
    }

    public Sigmoid(double gamma, double intercept) {
        this.gamma = gamma;
        this.intercept = intercept;
    }

    public static Sigmoid deserializeFromProto(int version, String className, Any message) throws InvalidProtocolBufferException {
        if (version < 0 || version > 0) {
            throw new IllegalArgumentException("Unknown version " + version + ", this class supports at most version " + 0);
        }
        SigmoidKernelProto kernelProto = (SigmoidKernelProto)message.unpack(SigmoidKernelProto.class);
        return new Sigmoid(kernelProto.getGamma(), kernelProto.getIntercept());
    }

    public KernelProto serialize() {
        return (KernelProto)ProtoUtil.serialize((ProtoSerializable)this);
    }

    @Override
    public double similarity(SparseVector a, SparseVector b) {
        return Math.tanh(this.gamma * a.dot(b) + this.intercept);
    }

    public String toString() {
        return "Sigmoid(gamma=" + this.gamma + ",intercept=" + this.intercept + ")";
    }

    public ConfiguredObjectProvenance getProvenance() {
        return new ConfiguredObjectProvenanceImpl((Configurable)this, "Kernel");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Sigmoid sigmoid = (Sigmoid)o;
        return Double.compare(sigmoid.gamma, this.gamma) == 0 && Double.compare(sigmoid.intercept, this.intercept) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.gamma, this.intercept);
    }
}

