/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.math.la;

import org.tribuo.math.la.DenseSparseMatrix;
import org.tribuo.math.la.DenseVector;
import org.tribuo.math.la.MatrixTuple;
import org.tribuo.math.la.SGDVector;
import org.tribuo.math.la.Tensor;

public interface Matrix
extends Tensor,
Iterable<MatrixTuple> {
    @Override
    public Matrix copy();

    public double get(int var1, int var2);

    public void set(int var1, int var2, double var3);

    public void add(int var1, int var2, double var3);

    public int getDimension1Size();

    public int getDimension2Size();

    public int numActiveElements(int var1);

    public SGDVector leftMultiply(SGDVector var1);

    public SGDVector rightMultiply(SGDVector var1);

    public Matrix matrixMultiply(Matrix var1);

    public Matrix matrixMultiply(Matrix var1, boolean var2, boolean var3);

    public DenseVector rowSum();

    public void rowScaleInPlace(DenseVector var1);

    public SGDVector getRow(int var1);

    public SGDVector getColumn(int var1);

    public static interface Factorization {
        public int dim1();

        public int dim2();

        public double determinant();

        public SGDVector solve(SGDVector var1);

        public Matrix solve(Matrix var1);

        default public Matrix inverse() {
            return this.solve(DenseSparseMatrix.createIdentity(this.dim2()));
        }
    }
}

