/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.math.neighbour;

import org.tribuo.math.distance.Distance;
import org.tribuo.math.neighbour.NeighboursQueryFactory;
import org.tribuo.math.neighbour.bruteforce.NeighboursBruteForceFactory;
import org.tribuo.math.neighbour.kdtree.KDTreeFactory;

public enum NeighboursQueryFactoryType {
    BRUTE_FORCE,
    KD_TREE;


    public static NeighboursQueryFactory getNeighboursQueryFactory(NeighboursQueryFactoryType nqFactoryType, Distance distance, int numThreads) {
        NeighboursQueryFactory neighboursQueryFactory;
        switch (nqFactoryType) {
            case BRUTE_FORCE: {
                neighboursQueryFactory = new NeighboursBruteForceFactory(distance, numThreads);
                break;
            }
            case KD_TREE: {
                neighboursQueryFactory = new KDTreeFactory(distance, numThreads);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown neighbour query factory " + (Object)((Object)nqFactoryType));
            }
        }
        return neighboursQueryFactory;
    }
}

