/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ingest.useragent;

import io.lucenia.ingest.useragent.UserAgentCache;
import io.lucenia.ingest.useragent.UserAgentParser;
import io.lucenia.ingest.useragent.UserAgentProcessor;
import io.lucenia.plugins.Plugin;
import io.skylite.common.processor.AbstractProcessor;
import io.skylite.core.ingest.IngestProcessor;
import io.skylite.core.plugins.IngestPlugin;
import io.skylite.core.settings.Setting;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

public class IngestUserAgentModulePlugin
extends Plugin
implements IngestPlugin {
    private final Setting<Long> CACHE_SIZE_SETTING = Setting.longSetting((String)"ingest.user_agent.cache_size", (long)1000L, (long)0L, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    static final String DEFAULT_PARSER_NAME = "_default_";

    public Map<String, AbstractProcessor.Factory<?>> getProcessors(IngestProcessor.Parameters parameters) {
        Map<String, UserAgentParser> userAgentParsers;
        Path userAgentConfigDirectory = parameters.env.configDir().resolve("ingest-user-agent");
        if (!Files.exists(userAgentConfigDirectory, new LinkOption[0]) && Files.isDirectory(userAgentConfigDirectory, new LinkOption[0])) {
            throw new IllegalStateException("the user agent directory [" + String.valueOf(userAgentConfigDirectory) + "] containing the regex file doesn't exist");
        }
        long cacheSize = (Long)this.CACHE_SIZE_SETTING.get(parameters.env.settings());
        try {
            userAgentParsers = IngestUserAgentModulePlugin.createUserAgentParsers(userAgentConfigDirectory, new UserAgentCache(cacheSize));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return Collections.singletonMap("user_agent", new UserAgentProcessor.Factory(userAgentParsers));
    }

    static Map<String, UserAgentParser> createUserAgentParsers(Path userAgentConfigDirectory, UserAgentCache cache) throws IOException {
        HashMap<String, UserAgentParser> userAgentParsers = new HashMap<String, UserAgentParser>();
        UserAgentParser defaultParser = new UserAgentParser(DEFAULT_PARSER_NAME, IngestUserAgentModulePlugin.class.getResourceAsStream("/regexes.yml"), cache);
        userAgentParsers.put(DEFAULT_PARSER_NAME, defaultParser);
        if (Files.exists(userAgentConfigDirectory, new LinkOption[0]) && Files.isDirectory(userAgentConfigDirectory, new LinkOption[0])) {
            PathMatcher pathMatcher = userAgentConfigDirectory.getFileSystem().getPathMatcher("glob:**.yml");
            try (Stream<Path> regexFiles = Files.find(userAgentConfigDirectory, 1, (path, attr) -> attr.isRegularFile() && pathMatcher.matches((Path)path), new FileVisitOption[0]);){
                Iterable iterable = regexFiles::iterator;
                for (Path path2 : iterable) {
                    String parserName = path2.getFileName().toString();
                    InputStream regexStream = Files.newInputStream(path2, StandardOpenOption.READ);
                    try {
                        userAgentParsers.put(parserName, new UserAgentParser(parserName, regexStream, cache));
                    }
                    finally {
                        if (regexStream == null) continue;
                        regexStream.close();
                    }
                }
            }
        }
        return Collections.unmodifiableMap(userAgentParsers);
    }

    public List<Setting<?>> getSettings() {
        return Collections.singletonList(this.CACHE_SIZE_SETTING);
    }
}

