/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.labs.mlrg.olcut.config.protobuf;

import com.google.protobuf.Message;
import com.google.protobuf.TextFormat;
import com.oracle.labs.mlrg.olcut.config.ConfigurationData;
import com.oracle.labs.mlrg.olcut.config.ConfigurationManager;
import com.oracle.labs.mlrg.olcut.config.PropertyException;
import com.oracle.labs.mlrg.olcut.config.SerializedObject;
import com.oracle.labs.mlrg.olcut.config.io.ConfigLoader;
import com.oracle.labs.mlrg.olcut.config.io.ConfigLoaderException;
import com.oracle.labs.mlrg.olcut.config.io.URLLoader;
import com.oracle.labs.mlrg.olcut.config.property.GlobalProperties;
import com.oracle.labs.mlrg.olcut.config.property.ListProperty;
import com.oracle.labs.mlrg.olcut.config.property.MapProperty;
import com.oracle.labs.mlrg.olcut.config.property.Property;
import com.oracle.labs.mlrg.olcut.config.property.SimpleProperty;
import com.oracle.labs.mlrg.olcut.config.protobuf.protos.ComponentProto;
import com.oracle.labs.mlrg.olcut.config.protobuf.protos.ConfigFileProto;
import com.oracle.labs.mlrg.olcut.config.protobuf.protos.ConfigProto;
import com.oracle.labs.mlrg.olcut.config.protobuf.protos.PropertyListProto;
import com.oracle.labs.mlrg.olcut.config.protobuf.protos.PropertyMapProto;
import com.oracle.labs.mlrg.olcut.config.protobuf.protos.SerializedObjectProto;
import com.oracle.labs.mlrg.olcut.util.IOUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ProtoLoader
implements ConfigLoader {
    private static final Logger logger = Logger.getLogger(ProtoLoader.class.getName());
    private final URLLoader parent;
    private final Map<String, ConfigurationData> rpdMap;
    private final Map<String, ConfigurationData> existingRPD;
    private final Map<String, SerializedObject> serializedObjects;
    private final GlobalProperties globalProperties;
    private final boolean parseTextFormat;

    public ProtoLoader(URLLoader parent, Map<String, ConfigurationData> rpdMap, Map<String, ConfigurationData> existingRPD, Map<String, SerializedObject> serializedObjects, GlobalProperties globalProperties, boolean parseTextFormat) {
        this.parent = parent;
        this.rpdMap = rpdMap;
        this.existingRPD = existingRPD;
        this.serializedObjects = serializedObjects;
        this.globalProperties = globalProperties;
        this.parseTextFormat = parseTextFormat;
    }

    public void load(URL url) throws ConfigLoaderException {
        AccessController.doPrivileged(() -> {
            String workingDir = "";
            if (url.getProtocol().equals("file")) {
                workingDir = new File(url.getFile()).getParent();
            } else if (IOUtil.isDisallowedProtocol((URL)url)) {
                throw new ConfigLoaderException("Unable to load configurations from URLs with protocol: " + url.getProtocol());
            }
            try (InputStream is = url.openStream();){
                ConfigProto proto;
                if (this.parseTextFormat) {
                    ConfigProto.Builder protoBuilder = ConfigProto.newBuilder();
                    BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
                    TextFormat.getParser().merge((Readable)reader, (Message.Builder)protoBuilder);
                    proto = protoBuilder.build();
                } else {
                    proto = ConfigProto.parseFrom(is);
                }
                this.parseConfigProto(workingDir, proto);
            }
            catch (IOException e) {
                throw new ConfigLoaderException((Exception)e, e.getMessage());
            }
            return null;
        });
    }

    public void load(InputStream stream) throws ConfigLoaderException {
        try {
            ConfigProto proto;
            if (this.parseTextFormat) {
                ConfigProto.Builder protoBuilder = ConfigProto.newBuilder();
                BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
                TextFormat.getParser().merge((Readable)reader, (Message.Builder)protoBuilder);
                proto = protoBuilder.build();
            } else {
                proto = ConfigProto.parseFrom(stream);
            }
            this.parseConfigProto("", proto);
        }
        catch (IOException e) {
            String msg = "Error while parsing input: " + e.getMessage();
            throw new ConfigLoaderException((Exception)e, msg);
        }
    }

    private void parseConfigProto(String workingDir, ConfigProto proto) {
        String name;
        for (Map.Entry<String, String> e : proto.getPropertiesMap().entrySet()) {
            try {
                this.globalProperties.setValue(e.getKey(), e.getValue());
            }
            catch (PropertyException ex) {
                throw new ConfigLoaderException("Invalid global property name: " + e.getKey());
            }
        }
        for (ConfigFileProto file : proto.getConfigFileList()) {
            name = file.getName();
            String value = file.getValue();
            if (name.isEmpty() || value.isEmpty()) {
                throw new ConfigLoaderException("File element must have 'name' and 'value' attributes, found " + name + ", " + value);
            }
            try {
                URL newURL = ConfigurationManager.class.getResource(value);
                if (newURL == null) {
                    File newFile = new File(value);
                    if (!newFile.isAbsolute()) {
                        newFile = new File(workingDir, value);
                    }
                    newURL = newFile.toURI().toURL();
                }
                this.parent.addURL(newURL);
            }
            catch (MalformedURLException ex) {
                throw new ConfigLoaderException((Exception)ex, "Incorrectly formatted file element " + name + " with value " + value);
            }
        }
        for (SerializedObjectProto serObj : proto.getSerializedObjectList()) {
            name = serObj.getName();
            String type = serObj.getType();
            String location = serObj.getLocation();
            if (name.isEmpty() || type.isEmpty() || location.isEmpty()) {
                throw new ConfigLoaderException("Serialized element must have 'name', 'type' and 'location' elements, found " + serObj.toString());
            }
            this.serializedObjects.put(name, new SerializedObject(name, location, type));
        }
        for (ComponentProto component : proto.getComponentsList()) {
            this.parseComponentProto(component);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void parseComponentProto(ComponentProto component) {
        ConfigurationData rpd;
        String serializedForm;
        String name = component.getName();
        String type = component.getType();
        String override = component.getOverride();
        if (name.isEmpty() || type.isEmpty() && override.isEmpty()) {
            throw new ConfigLoaderException("Component element must specify 'name' and either 'type' or 'inherit' attributes, found " + component);
        }
        boolean exportable = component.getExportable();
        boolean importable = component.getImportable();
        if (!exportable && component.hasLeaseTime()) {
            throw new ConfigLoaderException("lease timeout " + component.getLeaseTime() + " specified for component '" + name + "' that does not have export set");
        }
        if (component.hasLeaseTime() && component.getLeaseTime() < 0L) {
            throw new ConfigLoaderException("lease timeout " + component.getLeaseTime() + " must be greater than 0, for component " + name);
        }
        long leaseTime = component.hasLeaseTime() ? component.getLeaseTime() : -1L;
        String entriesName = component.hasEntries() ? component.getEntries() : null;
        String string = serializedForm = component.hasSerialized() ? component.getSerialized() : null;
        if (!override.isEmpty()) {
            ConfigurationData spd = this.rpdMap.get(override);
            if (spd == null) {
                if (this.existingRPD == null || !this.existingRPD.containsKey(override)) {
                    throw new ConfigLoaderException("Failed to find base component '" + override + "' inherited from '" + name + "'.");
                }
                spd = this.existingRPD.get(override);
            }
            if (!type.isEmpty() && !type.equals(spd.getClassName())) {
                logger.log(Level.FINE, String.format("Overriding component %s with component %s, new type is %s overridden type was %s", spd.getName(), name, type, spd.getClassName()));
            }
            if (type.isEmpty()) {
                type = spd.getClassName();
            }
            rpd = new ConfigurationData(name, type, spd.getProperties(), serializedForm, entriesName, exportable, importable, leaseTime);
        } else {
            if (this.rpdMap.get(name) != null) {
                throw new ConfigLoaderException("duplicate definition for " + name);
            }
            rpd = new ConfigurationData(name, type, serializedForm, entriesName, exportable, importable, leaseTime);
        }
        for (Map.Entry<String, String> entry : component.getPropertiesMap().entrySet()) {
            rpd.add(entry.getKey(), (Property)new SimpleProperty(entry.getValue()));
        }
        for (PropertyMapProto propertyMapProto : component.getMapPropertyList()) {
            HashMap<String, SimpleProperty> mapOutput = new HashMap<String, SimpleProperty>();
            for (Map.Entry<String, String> entry : propertyMapProto.getElementsMap().entrySet()) {
                mapOutput.put(entry.getKey(), new SimpleProperty(entry.getValue()));
            }
            rpd.add(propertyMapProto.getName(), (Property)new MapProperty(mapOutput));
        }
        for (PropertyListProto propertyListProto : component.getListPropertyList()) {
            void var16_25;
            ArrayList<SimpleProperty> listOutput = new ArrayList<SimpleProperty>();
            ArrayList classListOutput = new ArrayList();
            for (String item : propertyListProto.getItemList()) {
                listOutput.add(new SimpleProperty(item));
            }
            for (String listType : propertyListProto.getTypeList()) {
                try {
                    classListOutput.add(Class.forName(listType));
                }
                catch (ClassNotFoundException cnfe) {
                    throw new ConfigLoaderException("Unable to find class " + listType + " in component '" + name + "', propertylist '" + propertyListProto.getName() + "'");
                }
            }
            if (classListOutput.isEmpty()) {
                ListProperty listProperty = new ListProperty(listOutput);
            } else {
                ListProperty listProperty = new ListProperty(listOutput, classListOutput);
            }
            rpd.add(propertyListProto.getName(), (Property)var16_25);
        }
        this.rpdMap.put(rpd.getName(), rpd);
    }
}

