/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.anomaly;

import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.oracle.labs.mlrg.olcut.provenance.Provenance;
import java.util.Map;
import org.tribuo.ImmutableOutputInfo;
import org.tribuo.MutableOutputInfo;
import org.tribuo.OutputFactory;
import org.tribuo.anomaly.Event;
import org.tribuo.anomaly.MutableAnomalyInfo;
import org.tribuo.anomaly.evaluation.AnomalyEvaluation;
import org.tribuo.anomaly.evaluation.AnomalyEvaluator;
import org.tribuo.evaluation.Evaluator;
import org.tribuo.protos.core.OutputFactoryProto;
import org.tribuo.provenance.OutputFactoryProvenance;

public final class AnomalyFactory
implements OutputFactory<Event> {
    private static final long serialVersionUID = 1L;
    public static final Event UNKNOWN_EVENT = new Event(Event.EventType.UNKNOWN);
    public static final Event EXPECTED_EVENT = new Event(Event.EventType.EXPECTED);
    public static final Event ANOMALOUS_EVENT = new Event(Event.EventType.ANOMALOUS);
    private static final AnomalyEvaluator evaluator = new AnomalyEvaluator();

    public static AnomalyFactory deserializeFromProto(int version, String className, Any message) {
        if (version < 0 || version > 0) {
            throw new IllegalArgumentException("Unknown version " + version + ", this class supports at most version " + 0);
        }
        if (message.getValue() != ByteString.EMPTY) {
            throw new IllegalArgumentException("Invalid proto");
        }
        return new AnomalyFactory();
    }

    public OutputFactoryProto serialize() {
        return OutputFactoryProto.newBuilder().setVersion(0).setClassName(AnomalyFactory.class.getName()).build();
    }

    public <V> Event generateOutput(V label) {
        if (label.toString().equalsIgnoreCase(Event.EventType.ANOMALOUS.toString())) {
            return ANOMALOUS_EVENT;
        }
        return EXPECTED_EVENT;
    }

    public Event getUnknownOutput() {
        return UNKNOWN_EVENT;
    }

    public MutableOutputInfo<Event> generateInfo() {
        return new MutableAnomalyInfo();
    }

    public ImmutableOutputInfo<Event> constructInfoForExternalModel(Map<Event, Integer> mapping) {
        OutputFactory.validateMapping(mapping);
        Integer expectedMapping = mapping.get(EXPECTED_EVENT);
        Integer anomalousMapping = mapping.get(ANOMALOUS_EVENT);
        if (expectedMapping != null && expectedMapping.intValue() != Event.EventType.EXPECTED.getID() || anomalousMapping != null && anomalousMapping.intValue() != Event.EventType.ANOMALOUS.getID()) {
            throw new IllegalArgumentException("Anomaly detection requires that anomalous events have id " + Event.EventType.ANOMALOUS.getID() + ", and expected events have id " + Event.EventType.EXPECTED.getID());
        }
        MutableAnomalyInfo info = new MutableAnomalyInfo();
        return info.generateImmutableOutputInfo();
    }

    public Evaluator<Event, AnomalyEvaluation> getEvaluator() {
        return evaluator;
    }

    public Class<Event> getTypeWitness() {
        return Event.class;
    }

    public int hashCode() {
        return "AnomalyFactory".hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof AnomalyFactory;
    }

    public OutputFactoryProvenance getProvenance() {
        return new AnomalyFactoryProvenance();
    }

    public static final class AnomalyFactoryProvenance
    implements OutputFactoryProvenance {
        private static final long serialVersionUID = 1L;

        AnomalyFactoryProvenance() {
        }

        public AnomalyFactoryProvenance(Map<String, Provenance> map) {
        }

        public String getClassName() {
            return AnomalyFactory.class.getName();
        }

        public String toString() {
            return this.generateString("OutputFactory");
        }

        public boolean equals(Object other) {
            return other instanceof AnomalyFactoryProvenance;
        }

        public int hashCode() {
            return 31;
        }
    }
}

