/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.anomaly;

import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import org.tribuo.MutableOutputInfo;
import org.tribuo.anomaly.AnomalyFactory;
import org.tribuo.anomaly.AnomalyInfo;
import org.tribuo.anomaly.Event;
import org.tribuo.anomaly.protos.AnomalyInfoProto;
import org.tribuo.protos.ProtoSerializableClass;

@ProtoSerializableClass(serializedDataClass=AnomalyInfoProto.class, version=0)
public final class MutableAnomalyInfo
extends AnomalyInfo
implements MutableOutputInfo<Event> {
    private static final long serialVersionUID = 1L;

    MutableAnomalyInfo() {
    }

    MutableAnomalyInfo(AnomalyInfo info) {
        super(info);
    }

    private MutableAnomalyInfo(long expectedCount, long anomalyCount, int unknownCount) {
        super(expectedCount, anomalyCount, unknownCount);
    }

    public static MutableAnomalyInfo deserializeFromProto(int version, String className, Any message) throws InvalidProtocolBufferException {
        if (version < 0 || version > 0) {
            throw new IllegalArgumentException("Unknown version " + version + ", this class supports at most version " + 0);
        }
        AnomalyInfoProto proto = (AnomalyInfoProto)message.unpack(AnomalyInfoProto.class);
        return new MutableAnomalyInfo(proto.getExpectedCount(), proto.getAnomalyCount(), proto.getUnknownCount());
    }

    public void observe(Event output) {
        if (output == AnomalyFactory.UNKNOWN_EVENT) {
            ++this.unknownCount;
        } else {
            switch (output.getType()) {
                case ANOMALOUS: {
                    ++this.anomalyCount;
                    break;
                }
                case EXPECTED: {
                    ++this.expectedCount;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected EventType, found " + (Object)((Object)output.getType()));
                }
            }
        }
    }

    public void clear() {
        this.unknownCount = 0;
        this.anomalyCount = 0L;
        this.expectedCount = 0L;
    }

    @Override
    public MutableAnomalyInfo copy() {
        return new MutableAnomalyInfo(this);
    }
}

