/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo;

import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.tribuo.FeatureMap;
import org.tribuo.VariableIDInfo;
import org.tribuo.VariableInfo;
import org.tribuo.protos.ProtoSerializableClass;
import org.tribuo.protos.ProtoUtil;
import org.tribuo.protos.core.FeatureDomainProto;
import org.tribuo.protos.core.ImmutableFeatureMapProto;
import org.tribuo.protos.core.VariableInfoProto;

@ProtoSerializableClass(version=0, serializedDataClass=ImmutableFeatureMapProto.class)
public class ImmutableFeatureMap
extends FeatureMap
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int CURRENT_VERSION = 0;
    protected final Map<Integer, VariableIDInfo> idMap = new HashMap<Integer, VariableIDInfo>();
    protected int size;

    public ImmutableFeatureMap(FeatureMap map) {
        this(ImmutableFeatureMap.generateIDs(map));
    }

    public ImmutableFeatureMap(List<VariableInfo> infoList) {
        this(ImmutableFeatureMap.generateIDs(infoList));
    }

    private ImmutableFeatureMap(Map<String, VariableIDInfo> map) {
        super(map);
        for (Map.Entry e : this.m.entrySet()) {
            VariableIDInfo idInfo = (VariableIDInfo)e.getValue();
            this.idMap.put(idInfo.getID(), idInfo);
        }
        this.size = this.m.size();
    }

    protected ImmutableFeatureMap() {
    }

    public static ImmutableFeatureMap deserializeFromProto(int version, String className, Any message) throws InvalidProtocolBufferException {
        if (version < 0 || version > 0) {
            throw new IllegalArgumentException("Unknown version " + version + ", this class supports at most version " + 0);
        }
        ImmutableFeatureMapProto proto = (ImmutableFeatureMapProto)message.unpack(ImmutableFeatureMapProto.class);
        ImmutableFeatureMap obj = new ImmutableFeatureMap();
        for (VariableInfoProto infoProto : proto.getInfoList()) {
            VariableIDInfo info = (VariableIDInfo)ProtoUtil.deserialize(infoProto);
            VariableIDInfo o = obj.idMap.put(info.getID(), info);
            VariableIDInfo otherO = obj.m.put(info.getName(), info);
            if (o == null && otherO == null) continue;
            throw new IllegalStateException("Invalid protobuf, found two mappings for " + info.getName());
        }
        obj.size = proto.getInfoCount();
        return obj;
    }

    @Override
    public FeatureDomainProto serialize() {
        return (FeatureDomainProto)ProtoUtil.serialize(this);
    }

    public VariableIDInfo get(int id) {
        return this.idMap.get(id);
    }

    @Override
    public VariableIDInfo get(String name) {
        return (VariableIDInfo)super.get(name);
    }

    public int getID(String name) {
        VariableIDInfo info = this.get(name);
        if (info != null) {
            return info.getID();
        }
        return -1;
    }

    @Override
    public int size() {
        return this.size;
    }

    public static Map<String, VariableIDInfo> generateIDs(FeatureMap map) {
        TreeMap<String, VariableInfo> sortedMap = new TreeMap<String, VariableInfo>(map.m);
        return ImmutableFeatureMap.generateIDs(sortedMap);
    }

    public static Map<String, VariableIDInfo> generateIDs(List<? extends VariableInfo> list) {
        TreeMap<String, VariableInfo> sortedMap = new TreeMap<String, VariableInfo>();
        for (VariableInfo variableInfo : list) {
            sortedMap.put(variableInfo.getName(), variableInfo);
        }
        return ImmutableFeatureMap.generateIDs(sortedMap);
    }

    private static Map<String, VariableIDInfo> generateIDs(TreeMap<String, VariableInfo> sortedMap) {
        HashMap<String, VariableIDInfo> outputMap = new HashMap<String, VariableIDInfo>();
        int counter = 0;
        for (Map.Entry<String, VariableInfo> e : sortedMap.entrySet()) {
            VariableIDInfo newInfo = e.getValue().makeIDInfo(counter);
            outputMap.put(e.getKey(), newInfo);
            ++counter;
        }
        return outputMap;
    }
}

