/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo;

import ai.onnx.proto.OnnxMl;
import com.oracle.labs.mlrg.olcut.config.protobuf.ProtoProvenanceSerialization;
import com.oracle.labs.mlrg.olcut.provenance.ObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.Provenancable;
import com.oracle.labs.mlrg.olcut.provenance.io.ProvenanceSerialization;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import org.tribuo.provenance.ModelProvenance;
import org.tribuo.util.onnx.ONNXContext;
import org.tribuo.util.onnx.ONNXNode;
import org.tribuo.util.onnx.ONNXOperators;
import org.tribuo.util.onnx.ONNXRef;

public interface ONNXExportable {
    public static final ProvenanceSerialization SERIALIZER = new ProtoProvenanceSerialization(true);
    public static final String PROVENANCE_METADATA_FIELD = "TRIBUO_PROVENANCE";

    public static <M extends Provenancable<ModelProvenance>> OnnxMl.ModelProto buildModel(ONNXContext onnxContext, String domain, long modelVersion, M model) {
        return OnnxMl.ModelProto.newBuilder().setGraph(onnxContext.buildGraph()).setDomain(domain).setProducerName("Tribuo").setProducerVersion("4.3.1").setModelVersion(modelVersion).addOpsetImport(ONNXOperators.getOpsetProto()).setIrVersion(6L).setDocString(model.toString()).addMetadataProps(OnnxMl.StringStringEntryProto.newBuilder().setKey(PROVENANCE_METADATA_FIELD).setValue(SERIALIZER.marshalAndSerialize((ObjectProvenance)model.getProvenance())).build()).build();
    }

    public OnnxMl.ModelProto exportONNXModel(String var1, long var2);

    public ONNXNode writeONNXGraph(ONNXRef<?> var1);

    default public void saveONNXModel(String domain, long modelVersion, Path outputPath) throws IOException {
        OnnxMl.ModelProto proto = this.exportONNXModel(domain, modelVersion);
        try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(outputPath.toFile()));){
            proto.writeTo((OutputStream)bos);
        }
    }

    default public String serializeProvenance(ModelProvenance provenance) {
        return SERIALIZER.marshalAndSerialize((ObjectProvenance)provenance);
    }
}

