/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo;

import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.tribuo.Example;
import org.tribuo.Output;
import org.tribuo.protos.ProtoSerializable;
import org.tribuo.protos.ProtoSerializableClass;
import org.tribuo.protos.ProtoSerializableField;
import org.tribuo.protos.ProtoSerializableMapField;
import org.tribuo.protos.ProtoUtil;
import org.tribuo.protos.core.OutputProto;
import org.tribuo.protos.core.PredictionImplProto;
import org.tribuo.protos.core.PredictionProto;

@ProtoSerializableClass(version=0, serializedDataClass=PredictionImplProto.class)
public class Prediction<T extends Output<T>>
implements ProtoSerializable<PredictionProto>,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final int CURRENT_VERSION = 0;
    @ProtoSerializableField
    private final Example<T> example;
    @ProtoSerializableField
    private final T output;
    @ProtoSerializableField
    private final boolean probability;
    @ProtoSerializableField
    private final int numUsed;
    @ProtoSerializableField
    private final int exampleSize;
    @ProtoSerializableMapField
    private final Map<String, T> outputScores;

    private Prediction(T output, Map<String, T> outputScores, int numUsed, int exampleSize, Example<T> example, boolean probability) {
        this.example = example;
        this.outputScores = outputScores;
        this.numUsed = numUsed;
        this.exampleSize = exampleSize;
        this.output = output;
        this.probability = probability;
    }

    public Prediction(T output, Map<String, T> outputScores, int numUsed, Example<T> example, boolean probability) {
        this(output, outputScores, numUsed, example.size(), example, probability);
    }

    public Prediction(T output, int numUsed, Example<T> example) {
        this(output, Collections.emptyMap(), numUsed, example.size(), example, false);
    }

    public Prediction(Prediction<T> other, int numUsed, Example<T> example) {
        this(other.output, new LinkedHashMap<String, T>(other.outputScores), numUsed, example.size(), example, other.probability);
    }

    public static Prediction<?> deserializeFromProto(int version, String className, Any message) throws InvalidProtocolBufferException {
        if (version < 0 || version > 0) {
            throw new IllegalArgumentException("Unknown version " + version + ", this class supports at most version " + 0);
        }
        PredictionImplProto proto = (PredictionImplProto)message.unpack(PredictionImplProto.class);
        int numUsed = proto.getNumUsed();
        if (numUsed < 0) {
            throw new IllegalStateException("Invalid protobuf, used a negative number of features");
        }
        int exampleSize = proto.getExampleSize();
        if (exampleSize < 0) {
            throw new IllegalStateException("Invalid protobuf, found a negative example size");
        }
        Example example = (Example)ProtoUtil.deserialize(proto.getExample());
        Output output = (Output)ProtoUtil.deserialize(proto.getOutput());
        if (!output.getClass().equals(example.getOutput().getClass())) {
            throw new IllegalStateException("Invalid protobuf, example and output types do not match, example = " + example.getOutput().getClass() + ", output = " + output.getClass());
        }
        HashMap<String, Output> map = new HashMap<String, Output>();
        for (Map.Entry<String, OutputProto> e : proto.getOutputScoresMap().entrySet()) {
            Output tmpOutput = (Output)ProtoUtil.deserialize(e.getValue());
            if (!tmpOutput.getClass().equals(output.getClass())) {
                throw new IllegalStateException("Invalid protobuf, output scores not all the same type, found " + tmpOutput.getClass() + ", expected " + output.getClass());
            }
            map.put(e.getKey(), tmpOutput);
        }
        return new Prediction<Output>(output, map, numUsed, exampleSize, example, proto.getProbability());
    }

    public T getOutput() {
        return this.output;
    }

    public int getNumActiveFeatures() {
        return this.numUsed;
    }

    public int getExampleSize() {
        return this.exampleSize;
    }

    public Example<T> getExample() {
        return this.example;
    }

    public Map<String, T> getOutputScores() {
        return this.outputScores;
    }

    public boolean hasProbabilities() {
        return this.probability;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Prediction(maxLabel=");
        buffer.append(this.output);
        buffer.append(",outputScores={");
        for (Map.Entry<String, T> e : this.outputScores.entrySet()) {
            buffer.append(e.toString());
            buffer.append(",");
        }
        buffer.delete(buffer.length() - 1, buffer.length());
        buffer.append("})");
        return buffer.toString();
    }

    public boolean distributionEquals(Prediction<T> other) {
        return this.distributionEquals(other, 0.0);
    }

    public boolean distributionEquals(Prediction<T> other, double threshold) {
        if (this.outputScores.size() != other.outputScores.size()) {
            return false;
        }
        for (Map.Entry<String, T> e : this.outputScores.entrySet()) {
            Output otherScore = (Output)other.outputScores.get(e.getKey());
            if (otherScore == null) {
                return false;
            }
            if (((Output)e.getValue()).fullEquals(otherScore, threshold)) continue;
            return false;
        }
        return true;
    }

    @Override
    public PredictionProto serialize() {
        return (PredictionProto)ProtoUtil.serialize(this);
    }
}

