/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo;

import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Objects;
import java.util.SplittableRandom;
import org.tribuo.RealIDInfo;
import org.tribuo.SkeletalVariableInfo;
import org.tribuo.protos.ProtoSerializableClass;
import org.tribuo.protos.ProtoSerializableField;
import org.tribuo.protos.ProtoUtil;
import org.tribuo.protos.core.RealInfoProto;
import org.tribuo.protos.core.VariableInfoProto;

@ProtoSerializableClass(version=0, serializedDataClass=RealInfoProto.class)
public class RealInfo
extends SkeletalVariableInfo {
    private static final long serialVersionUID = 1L;
    public static final int CURRENT_VERSION = 0;
    @ProtoSerializableField
    protected double max = Double.NEGATIVE_INFINITY;
    @ProtoSerializableField
    protected double min = Double.POSITIVE_INFINITY;
    @ProtoSerializableField
    protected double mean = 0.0;
    @ProtoSerializableField
    protected double sumSquares = 0.0;

    public RealInfo(String name) {
        super(name);
    }

    public RealInfo(String name, int count) {
        super(name, count);
    }

    public RealInfo(String name, int count, double max, double min, double mean, double sumSquares) {
        super(name, count);
        if (max < min) {
            throw new IllegalArgumentException("Invalid RealInfo, min greater than max.");
        }
        if (mean > max) {
            throw new IllegalArgumentException("Invalid RealInfo, mean greater than max.");
        }
        if (mean < min) {
            throw new IllegalArgumentException("Invalid RealInfo, mean less than min.");
        }
        if (sumSquares < 0.0) {
            throw new IllegalArgumentException("Invalid RealInfo, variance must be non-negative.");
        }
        this.max = max;
        this.min = min;
        this.mean = mean;
        this.sumSquares = sumSquares;
    }

    public RealInfo(RealInfo other) {
        this(other, other.name);
    }

    protected RealInfo(RealInfo other, String newName) {
        super(newName, other.count);
        this.max = other.max;
        this.min = other.min;
        this.mean = other.mean;
        this.sumSquares = other.sumSquares;
    }

    public static RealInfo deserializeFromProto(int version, String className, Any message) throws InvalidProtocolBufferException {
        if (version < 0 || version > 0) {
            throw new IllegalArgumentException("Unknown version " + version + ", this class supports at most version " + 0);
        }
        RealInfoProto proto = (RealInfoProto)message.unpack(RealInfoProto.class);
        RealInfo info = new RealInfo(proto.getName(), proto.getCount(), proto.getMax(), proto.getMin(), proto.getMean(), proto.getSumSquares());
        return info;
    }

    @Override
    public VariableInfoProto serialize() {
        return (VariableInfoProto)ProtoUtil.serialize(this);
    }

    @Override
    protected void observe(double value) {
        if (value != 0.0) {
            super.observe(value);
            if (value < this.min) {
                this.min = value;
            }
            if (value > this.max) {
                this.max = value;
            }
            double delta = value - this.mean;
            this.mean += delta / (double)this.count;
            double delta2 = value - this.mean;
            this.sumSquares += delta * delta2;
        }
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public double getMean() {
        return this.mean;
    }

    public double getVariance() {
        return this.sumSquares / (double)(this.count - 1);
    }

    @Override
    public RealInfo copy() {
        return new RealInfo(this);
    }

    @Override
    public RealIDInfo makeIDInfo(int id) {
        return new RealIDInfo(this, id);
    }

    @Override
    public RealInfo rename(String newName) {
        return new RealInfo(this, newName);
    }

    @Override
    public double uniformSample(SplittableRandom rng) {
        return rng.nextDouble() * this.max - this.min;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RealInfo realInfo = (RealInfo)o;
        return Double.compare(realInfo.max, this.max) == 0 && Double.compare(realInfo.min, this.min) == 0 && Double.compare(realInfo.mean, this.mean) == 0 && Double.compare(realInfo.sumSquares, this.sumSquares) == 0;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.max, this.min, this.mean, this.sumSquares);
    }

    @Override
    public String toString() {
        return String.format("RealFeature(name=%s,count=%d,max=%f,min=%f,mean=%f,variance=%f)", this.name, this.count, this.max, this.min, this.mean, this.sumSquares / (double)(this.count - 1));
    }
}

