/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.dataset;

import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.ProtocolStringList;
import com.oracle.labs.mlrg.olcut.provenance.ListProvenance;
import com.oracle.labs.mlrg.olcut.provenance.ObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.Provenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.IntProvenance;
import com.oracle.labs.mlrg.olcut.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;
import org.tribuo.Dataset;
import org.tribuo.Example;
import org.tribuo.Feature;
import org.tribuo.FeatureMap;
import org.tribuo.ImmutableDataset;
import org.tribuo.ImmutableFeatureMap;
import org.tribuo.ImmutableOutputInfo;
import org.tribuo.MutableFeatureMap;
import org.tribuo.Output;
import org.tribuo.OutputFactory;
import org.tribuo.VariableInfo;
import org.tribuo.impl.ArrayExample;
import org.tribuo.impl.DatasetDataCarrier;
import org.tribuo.protos.core.DatasetProto;
import org.tribuo.protos.core.ExampleProto;
import org.tribuo.protos.core.MinimumCardinalityDatasetProto;
import org.tribuo.provenance.DataProvenance;
import org.tribuo.provenance.DatasetProvenance;

public class MinimumCardinalityDataset<T extends Output<T>>
extends ImmutableDataset<T> {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(MinimumCardinalityDataset.class.getName());
    public static final int CURRENT_VERSION = 0;
    private final int minCardinality;
    private int numExamplesRemoved = 0;
    private final Set<String> removed = new HashSet<String>();

    public MinimumCardinalityDataset(Dataset<T> dataset, int minCardinality) {
        super((DataProvenance)dataset.getProvenance(), dataset.getOutputFactory());
        this.minCardinality = minCardinality;
        if (minCardinality < 0) {
            throw new IllegalArgumentException("Minimum cardinality must be non-negative, found " + minCardinality);
        }
        MutableFeatureMap featureInfos = new MutableFeatureMap();
        ArrayList<Feature> features = new ArrayList<Feature>();
        FeatureMap wfm = dataset.getFeatureMap();
        for (Example<T> ex : dataset) {
            features.clear();
            ArrayExample<T> nex = new ArrayExample<T>(ex.getOutput());
            nex.setWeight(ex.getWeight());
            for (Feature f : ex) {
                VariableInfo finfo = wfm.get(f.getName());
                if (finfo == null || finfo.getCount() < minCardinality) {
                    this.removed.add(f.getName());
                    continue;
                }
                features.add(f);
            }
            nex.addAll(features);
            if (nex.size() > 0) {
                if (!nex.validateExample()) {
                    throw new IllegalStateException("Duplicate features found in example " + nex.toString());
                }
                this.data.add(nex);
                continue;
            }
            ++this.numExamplesRemoved;
        }
        for (VariableInfo info : wfm) {
            if (info.getCount() < minCardinality) continue;
            featureInfos.put(info.copy());
        }
        this.outputIDInfo = dataset.getOutputIDInfo();
        this.featureIDMap = new ImmutableFeatureMap(featureInfos);
        if (this.numExamplesRemoved > 0) {
            logger.info(String.format("filtered out %d examples because it had zero features after the minimum frequency count was applied.", this.numExamplesRemoved));
        }
    }

    private MinimumCardinalityDataset(DataProvenance provenance, OutputFactory<T> factory, String tribuoVersion, ImmutableFeatureMap fmap, ImmutableOutputInfo<T> outputInfo, List<Example<T>> examples, boolean dropInvalidExamples, int minCardinality, int numExamplesRemoved, Set<String> removed) {
        super(provenance, factory, tribuoVersion, fmap, outputInfo, examples, dropInvalidExamples);
        this.minCardinality = minCardinality;
        this.numExamplesRemoved = numExamplesRemoved;
        this.removed.addAll(removed);
    }

    public static MinimumCardinalityDataset<?> deserializeFromProto(int version, String className, Any message) throws InvalidProtocolBufferException {
        if (version < 0 || version > 0) {
            throw new IllegalArgumentException("Unknown version " + version + ", this class supports at most version " + 0);
        }
        MinimumCardinalityDatasetProto proto = (MinimumCardinalityDatasetProto)message.unpack(MinimumCardinalityDatasetProto.class);
        DatasetDataCarrier<?> carrier = DatasetDataCarrier.deserialize(proto.getMetadata());
        Class<?> outputClass = carrier.outputFactory().getUnknownOutput().getClass();
        FeatureMap fmap = carrier.featureDomain();
        List examples = MinimumCardinalityDataset.deserializeExamples(proto.getExamplesList(), outputClass, fmap);
        if (!(fmap instanceof ImmutableFeatureMap)) {
            throw new IllegalStateException("Invalid protobuf, feature map was not immutable");
        }
        if (!(carrier.outputDomain() instanceof ImmutableOutputInfo)) {
            throw new IllegalStateException("Invalid protobuf, output info was not immutable");
        }
        int minCardinality = proto.getMinCardinality();
        if (minCardinality < 0) {
            throw new IllegalStateException("Invalid protobuf, minimum cardinality must be non-negative, found " + minCardinality);
        }
        int numRemoved = proto.getNumExamplesRemoved();
        if (numRemoved < 0) {
            throw new IllegalStateException("Invalid protobuf, number of examples removed must be non-negative, found " + numRemoved);
        }
        ProtocolStringList removedList = proto.getRemovedList();
        HashSet<String> removedFeatures = new HashSet<String>((Collection<String>)removedList);
        if (removedFeatures.size() != removedList.size()) {
            throw new IllegalStateException("Invalid protobuf, features removed contained duplicates, removed = " + removedList);
        }
        return new MinimumCardinalityDataset(carrier.provenance(), carrier.outputFactory(), carrier.tribuoVersion(), (ImmutableFeatureMap)fmap, (ImmutableOutputInfo)carrier.outputDomain(), examples, proto.getDropInvalidExamples(), minCardinality, numRemoved, removedFeatures);
    }

    public Set<String> getRemoved() {
        return this.removed;
    }

    public int getNumExamplesRemoved() {
        return this.numExamplesRemoved;
    }

    public int getMinCardinality() {
        return this.minCardinality;
    }

    @Override
    public DatasetProvenance getProvenance() {
        return new MinimumCardinalityDatasetProvenance(this);
    }

    @Override
    public DatasetProto serialize() {
        MinimumCardinalityDatasetProto.Builder datasetBuilder = MinimumCardinalityDatasetProto.newBuilder();
        datasetBuilder.setDropInvalidExamples(this.dropInvalidExamples);
        datasetBuilder.setMetadata(this.createDataCarrier(this.featureIDMap, this.outputIDInfo).serialize());
        for (Example e : this.data) {
            datasetBuilder.addExamples((ExampleProto)e.serialize());
        }
        datasetBuilder.setMinCardinality(this.minCardinality);
        datasetBuilder.setNumExamplesRemoved(this.numExamplesRemoved);
        datasetBuilder.addAllRemoved(this.removed);
        DatasetProto.Builder builder = DatasetProto.newBuilder();
        builder.setVersion(0);
        builder.setClassName(MinimumCardinalityDataset.class.getName());
        builder.setSerializedData(Any.pack((Message)datasetBuilder.build()));
        return builder.build();
    }

    public static class MinimumCardinalityDatasetProvenance
    extends DatasetProvenance {
        private static final long serialVersionUID = 1L;
        private static final String MIN_CARDINALITY = "min-cardinality";
        private final IntProvenance minCardinality;

        <T extends Output<T>> MinimumCardinalityDatasetProvenance(MinimumCardinalityDataset<T> dataset) {
            super(((MinimumCardinalityDataset)dataset).sourceProvenance, (ListProvenance<ObjectProvenance>)new ListProvenance(), dataset);
            this.minCardinality = new IntProvenance(MIN_CARDINALITY, ((MinimumCardinalityDataset)dataset).minCardinality);
        }

        public MinimumCardinalityDatasetProvenance(Map<String, Provenance> map) {
            super(map);
            this.minCardinality = (IntProvenance)ObjectProvenance.checkAndExtractProvenance(map, (String)MIN_CARDINALITY, IntProvenance.class, (String)MinimumCardinalityDatasetProvenance.class.getSimpleName());
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MinimumCardinalityDatasetProvenance)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            MinimumCardinalityDatasetProvenance pairs = (MinimumCardinalityDatasetProvenance)o;
            return this.minCardinality.equals((Object)pairs.minCardinality);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.minCardinality);
        }

        @Override
        protected List<Pair<String, Provenance>> allProvenances() {
            List<Pair<String, Provenance>> provenances = super.allProvenances();
            provenances.add((Pair<String, Provenance>)new Pair((Object)MIN_CARDINALITY, (Object)this.minCardinality));
            return provenances;
        }
    }
}

