/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.datasource;

import com.oracle.labs.mlrg.olcut.provenance.ListProvenance;
import com.oracle.labs.mlrg.olcut.provenance.ObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.Provenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.EnumProvenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.StringProvenance;
import com.oracle.labs.mlrg.olcut.util.Pair;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import org.tribuo.DataSource;
import org.tribuo.Example;
import org.tribuo.Output;
import org.tribuo.OutputFactory;
import org.tribuo.provenance.DataSourceProvenance;

public class AggregateDataSource<T extends Output<T>>
implements DataSource<T> {
    private final IterationOrder order;
    private final List<DataSource<T>> sources;

    public AggregateDataSource(List<DataSource<T>> sources) {
        this(sources, IterationOrder.SEQUENTIAL);
    }

    public AggregateDataSource(List<DataSource<T>> sources, IterationOrder order) {
        this.sources = Collections.unmodifiableList(new ArrayList<DataSource<T>>(sources));
        this.order = order;
    }

    public String toString() {
        return "AggregateDataSource(sources=" + this.sources.toString() + ",order=" + (Object)((Object)this.order) + ")";
    }

    @Override
    public OutputFactory<T> getOutputFactory() {
        return this.sources.get(0).getOutputFactory();
    }

    @Override
    public Iterator<Example<T>> iterator() {
        switch (this.order) {
            case ROUNDROBIN: {
                return new ADSRRIterator<T>(this.sources);
            }
            case SEQUENTIAL: {
                return new ADSSeqIterator<T>(this.sources);
            }
        }
        throw new IllegalStateException("Unknown enum value " + (Object)((Object)this.order));
    }

    public DataSourceProvenance getProvenance() {
        return new AggregateDataSourceProvenance(this);
    }

    public static enum IterationOrder {
        ROUNDROBIN,
        SEQUENTIAL;

    }

    static class ADSRRIterator<T extends Output<T>>
    implements Iterator<Example<T>> {
        private final Deque<Iterator<Example<T>>> queue;

        ADSRRIterator(List<? extends DataSource<T>> sources) {
            this.queue = new ArrayDeque<Iterator<Example<T>>>(sources.size());
            for (DataSource<T> ds : sources) {
                Iterator itr = ds.iterator();
                if (!itr.hasNext()) continue;
                this.queue.addLast(itr);
            }
        }

        @Override
        public boolean hasNext() {
            return !this.queue.isEmpty();
        }

        @Override
        public Example<T> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("Iterator exhausted");
            }
            Iterator<Example<T>> itr = this.queue.pollFirst();
            if (itr.hasNext()) {
                Example<T> buff = itr.next();
                if (itr.hasNext()) {
                    this.queue.addLast(itr);
                }
                return buff;
            }
            throw new IllegalStateException("Invalid iterator in queue");
        }
    }

    static class ADSSeqIterator<T extends Output<T>>
    implements Iterator<Example<T>> {
        private final Iterator<? extends DataSource<T>> si;
        private Iterator<Example<T>> curr;

        ADSSeqIterator(List<? extends DataSource<T>> sources) {
            this.si = sources.iterator();
            this.curr = null;
        }

        @Override
        public boolean hasNext() {
            if (this.curr == null) {
                if (this.si.hasNext()) {
                    DataSource<T> nds = this.si.next();
                    this.curr = nds.iterator();
                    return this.hasNext();
                }
                return false;
            }
            if (this.curr.hasNext()) {
                return true;
            }
            this.curr = null;
            return this.hasNext();
        }

        @Override
        public Example<T> next() {
            if (this.hasNext()) {
                return this.curr.next();
            }
            throw new NoSuchElementException("No more data");
        }
    }

    public static class AggregateDataSourceProvenance
    implements DataSourceProvenance {
        private static final long serialVersionUID = 1L;
        private static final String SOURCES = "sources";
        private static final String ORDER = "order";
        private final StringProvenance className;
        private final ListProvenance<DataSourceProvenance> provenances;
        private EnumProvenance<IterationOrder> orderProvenance;

        <T extends Output<T>> AggregateDataSourceProvenance(AggregateDataSource<T> host) {
            this.className = new StringProvenance("class-name", host.getClass().getName());
            this.provenances = ListProvenance.createListProvenance((Collection)((AggregateDataSource)host).sources);
            this.orderProvenance = new EnumProvenance(ORDER, (Enum)((AggregateDataSource)host).order);
        }

        public AggregateDataSourceProvenance(Map<String, Provenance> map) {
            this.className = (StringProvenance)ObjectProvenance.checkAndExtractProvenance(map, (String)"class-name", StringProvenance.class, (String)AggregateDataSourceProvenance.class.getSimpleName());
            this.provenances = (ListProvenance)ObjectProvenance.checkAndExtractProvenance(map, (String)SOURCES, ListProvenance.class, (String)AggregateDataSourceProvenance.class.getSimpleName());
            Optional opt = ObjectProvenance.maybeExtractProvenance(map, (String)ORDER, EnumProvenance.class, (String)AggregateDataSourceProvenance.class.getSimpleName());
            this.orderProvenance = opt.orElseGet(() -> new EnumProvenance(ORDER, (Enum)IterationOrder.SEQUENTIAL));
        }

        public String getClassName() {
            return this.className.getValue();
        }

        public Iterator<Pair<String, Provenance>> iterator() {
            ArrayList<Pair> list = new ArrayList<Pair>();
            list.add(new Pair((Object)"class-name", (Object)this.className));
            list.add(new Pair((Object)SOURCES, this.provenances));
            list.add(new Pair((Object)ORDER, this.getOrder()));
            return list.iterator();
        }

        private EnumProvenance<IterationOrder> getOrder() {
            if (this.orderProvenance != null) {
                return this.orderProvenance;
            }
            return new EnumProvenance(ORDER, (Enum)IterationOrder.SEQUENTIAL);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AggregateDataSourceProvenance)) {
                return false;
            }
            AggregateDataSourceProvenance pairs = (AggregateDataSourceProvenance)o;
            return this.className.equals((Object)pairs.className) && this.provenances.equals(pairs.provenances) && this.getOrder().equals(pairs.getOrder());
        }

        public int hashCode() {
            return Objects.hash(this.className, this.provenances, this.getOrder());
        }

        public String toString() {
            return this.generateString("DataSource");
        }
    }
}

