/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.hash;

import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Map;
import java.util.TreeMap;
import org.tribuo.FeatureMap;
import org.tribuo.ImmutableFeatureMap;
import org.tribuo.VariableIDInfo;
import org.tribuo.VariableInfo;
import org.tribuo.hash.Hasher;
import org.tribuo.protos.ProtoSerializableClass;
import org.tribuo.protos.ProtoSerializableField;
import org.tribuo.protos.ProtoUtil;
import org.tribuo.protos.core.HashedFeatureMapProto;
import org.tribuo.protos.core.HasherProto;
import org.tribuo.protos.core.VariableInfoProto;

@ProtoSerializableClass(version=0, serializedDataClass=HashedFeatureMapProto.class)
public final class HashedFeatureMap
extends ImmutableFeatureMap {
    private static final long serialVersionUID = 1L;
    public static final int CURRENT_VERSION = 0;
    @ProtoSerializableField
    private final Hasher hasher;

    private HashedFeatureMap(Hasher hasher) {
        this.hasher = hasher;
    }

    public static HashedFeatureMap deserializeFromProto(int version, String className, Any message) throws InvalidProtocolBufferException {
        if (version < 0 || version > 0) {
            throw new IllegalArgumentException("Unknown version " + version + ", this class supports at most version " + 0);
        }
        HashedFeatureMapProto proto = (HashedFeatureMapProto)message.unpack(HashedFeatureMapProto.class);
        HasherProto hasherProto = proto.getHasher();
        Hasher hasher = (Hasher)ProtoUtil.deserialize(hasherProto);
        HashedFeatureMap obj = new HashedFeatureMap(hasher);
        for (VariableInfoProto infoProto : proto.getInfoList()) {
            VariableIDInfo info = (VariableIDInfo)ProtoUtil.deserialize(infoProto);
            VariableIDInfo o = obj.idMap.put(info.getID(), info);
            VariableIDInfo otherO = obj.m.put(info.getName(), info);
            if (o == null && otherO == null) continue;
            throw new IllegalStateException("Invalid protobuf, found two mappings for " + info.getName());
        }
        obj.size = proto.getInfoCount();
        return obj;
    }

    @Override
    public VariableIDInfo get(String name) {
        String hash = this.hasher.hash(name);
        return (VariableIDInfo)this.m.get(hash);
    }

    @Override
    public int getID(String name) {
        VariableIDInfo info = this.get(name);
        if (info != null) {
            return info.getID();
        }
        return -1;
    }

    public void setSalt(String salt) {
        this.hasher.setSalt(salt);
    }

    public static HashedFeatureMap generateHashedFeatureMap(FeatureMap map, Hasher hasher) {
        VariableInfo newF;
        HashedFeatureMap hashedMap = new HashedFeatureMap(hasher);
        TreeMap<String, VariableInfo> treeHashMap = new TreeMap<String, VariableInfo>();
        for (VariableInfo f : map) {
            String hash = hasher.hash(f.getName());
            if (treeHashMap.containsKey(f.getName())) continue;
            newF = f.rename(hash);
            treeHashMap.put(f.getName(), newF);
        }
        int counter = 0;
        for (Map.Entry e : treeHashMap.entrySet()) {
            newF = ((VariableInfo)e.getValue()).makeIDInfo(counter);
            if (hashedMap.m.containsKey(newF.getName())) continue;
            hashedMap.m.put(newF.getName(), newF);
            hashedMap.idMap.put(newF.getID(), newF);
            ++counter;
        }
        hashedMap.size = hashedMap.m.size();
        return hashedMap;
    }
}

