/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.impl;

import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.oracle.labs.mlrg.olcut.util.SortUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.logging.Logger;
import org.tribuo.Example;
import org.tribuo.Feature;
import org.tribuo.FeatureMap;
import org.tribuo.ImmutableFeatureMap;
import org.tribuo.ImmutableOutputInfo;
import org.tribuo.Output;
import org.tribuo.OutputInfo;
import org.tribuo.impl.ArrayExample;
import org.tribuo.protos.ProtoUtil;
import org.tribuo.protos.core.ExampleProto;
import org.tribuo.protos.core.IndexedArrayExampleProto;
import org.tribuo.protos.core.OutputProto;
import org.tribuo.util.Merger;

public class IndexedArrayExample<T extends Output<T>>
extends ArrayExample<T> {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(IndexedArrayExample.class.getName());
    public static final int CURRENT_VERSION = 0;
    protected int[] featureIDs;
    protected final int outputID;
    private final ImmutableFeatureMap featureMap;
    private final ImmutableOutputInfo<T> outputMap;

    public IndexedArrayExample(IndexedArrayExample<T> other) {
        super(other.getOutput(), other.getWeight(), other.getMetadata());
        this.featureNames = Arrays.copyOf(other.featureNames, other.featureNames.length);
        this.featureIDs = Arrays.copyOf(other.featureIDs, other.size());
        this.featureValues = Arrays.copyOf(other.featureValues, other.featureValues.length);
        this.featureMap = other.featureMap;
        this.outputMap = other.outputMap;
        this.outputID = this.outputMap.getID(this.output);
        this.size = other.size;
    }

    public IndexedArrayExample(Example<T> other, ImmutableFeatureMap featureMap, ImmutableOutputInfo<T> outputMap) {
        super(other);
        this.featureIDs = new int[other.size()];
        this.featureMap = featureMap;
        this.outputMap = outputMap;
        this.outputID = outputMap.getID(this.output);
        for (int i = 0; i < this.featureNames.length; ++i) {
            this.featureIDs[i] = featureMap.getID(this.featureNames[i]);
        }
        int[] newIDs = new int[other.size()];
        String[] newNames = new String[other.size()];
        double[] newValues = new double[other.size()];
        int counter = 0;
        for (int i = 0; i < this.featureIDs.length; ++i) {
            if (this.featureIDs[i] == -1) continue;
            newIDs[counter] = this.featureIDs[i];
            newValues[counter] = this.featureValues[i];
            newNames[counter] = this.featureNames[i];
            ++counter;
        }
        this.size = counter;
        this.featureNames = newNames;
        this.featureIDs = newIDs;
        this.featureValues = newValues;
    }

    private IndexedArrayExample(T output, int outputID, float weight, String[] featureNames, int[] featureIDs, double[] featureValues, Map<String, String> metadata, ImmutableFeatureMap featureDomain, ImmutableOutputInfo<T> outputDomain) {
        super(output, weight);
        this.outputID = outputID;
        this.featureNames = Arrays.copyOf(featureNames, featureNames.length);
        this.featureIDs = Arrays.copyOf(featureIDs, featureIDs.length);
        this.featureValues = Arrays.copyOf(featureValues, featureValues.length);
        this.size = featureNames.length;
        for (Map.Entry<String, String> e : metadata.entrySet()) {
            this.setMetadataValue(e.getKey(), e.getValue());
        }
        this.featureMap = featureDomain;
        this.outputMap = outputDomain;
    }

    public static ArrayExample<?> deserializeFromProto(int version, String className, Any message) throws InvalidProtocolBufferException {
        if (version < 0 || version > 0) {
            throw new IllegalArgumentException("Unknown version " + version + ", this class supports at most version " + 0);
        }
        IndexedArrayExampleProto proto = (IndexedArrayExampleProto)message.unpack(IndexedArrayExampleProto.class);
        if (proto.getFeatureNameCount() != proto.getFeatureValueCount() || proto.getFeatureNameCount() != proto.getFeatureIdxCount()) {
            throw new IllegalStateException("Invalid protobuf, different numbers of feature names, ids and values, found " + proto.getFeatureNameCount() + " names, " + proto.getFeatureIdxCount() + " ids, and " + proto.getFeatureValueCount() + " values.");
        }
        Output output = (Output)ProtoUtil.deserialize(proto.getOutput());
        int outputID = proto.getOutputIdx();
        FeatureMap fmap = (FeatureMap)ProtoUtil.deserialize(proto.getFeatureDomain());
        if (!(fmap instanceof ImmutableFeatureMap)) {
            throw new IllegalStateException("Invalid protobuf, feature domain was not ImmutableFeatureMap, found " + fmap.getClass());
        }
        ImmutableFeatureMap featureDomain = (ImmutableFeatureMap)fmap;
        OutputInfo outputMap = (OutputInfo)ProtoUtil.deserialize(proto.getOutputDomain());
        if (!(outputMap instanceof ImmutableOutputInfo)) {
            throw new IllegalStateException("Invalid protobuf, output domain was not ImmutableOutputInfo, found " + outputMap.getClass());
        }
        ImmutableOutputInfo outputDomain = (ImmutableOutputInfo)outputMap;
        if (output.getClass() != outputDomain.getDomain().iterator().next().getClass()) {
            throw new IllegalStateException("Invalid protobuf, output type did not match domain type, output " + output.getClass() + ", output domain " + outputDomain.getClass());
        }
        if (outputID != outputDomain.getID(output)) {
            throw new IllegalStateException("Invalid protobuf, output id did not match the id from the domain, found " + outputID + ", expected " + outputDomain.getID(output));
        }
        String[] featureNames = new String[proto.getFeatureNameCount()];
        int[] featureIDs = new int[proto.getFeatureIdxCount()];
        double[] featureValues = new double[proto.getFeatureValueCount()];
        for (int i = 0; i < proto.getFeatureNameCount(); ++i) {
            featureNames[i] = proto.getFeatureName(i);
            featureIDs[i] = proto.getFeatureIdx(i);
            if (featureIDs[i] != featureDomain.getID(featureNames[i])) {
                throw new IllegalStateException("Invalid protobuf, feature id did not match the id from the domain, found " + featureIDs[i] + ", expected " + featureDomain.getID(featureNames[i]));
            }
            featureValues[i] = proto.getFeatureValue(i);
        }
        return new IndexedArrayExample<Output>(output, outputID, proto.getWeight(), featureNames, featureIDs, featureValues, proto.getMetadataMap(), featureDomain, outputDomain);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IndexedArrayExample)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IndexedArrayExample that = (IndexedArrayExample)o;
        return this.outputID == that.outputID && Arrays.equals(this.featureIDs, that.featureIDs) && this.featureMap.equals(that.featureMap) && this.outputMap.equals(that.outputMap);
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(super.hashCode(), this.outputID, this.featureMap, this.outputMap);
        result = 31 * result + Arrays.hashCode(this.featureIDs);
        return result;
    }

    @Override
    protected void growArray(int minCapacity) {
        int newCapacity = this.newCapacity(minCapacity);
        this.featureNames = Arrays.copyOf(this.featureNames, newCapacity);
        this.featureIDs = Arrays.copyOf(this.featureIDs, newCapacity);
        this.featureValues = Arrays.copyOf(this.featureValues, newCapacity);
    }

    @Override
    public void add(Feature feature) {
        if (this.size >= this.featureNames.length) {
            this.growArray();
        }
        this.featureNames[this.size] = feature.getName();
        this.featureIDs[this.size] = this.featureMap.getID(feature.getName());
        this.featureValues[this.size] = feature.getValue();
        ++this.size;
        this.sort();
    }

    @Override
    public void addAll(Collection<? extends Feature> features) {
        if (this.size + features.size() >= this.featureNames.length) {
            this.growArray(this.size + features.size());
        }
        for (Feature feature : features) {
            this.featureNames[this.size] = feature.getName();
            this.featureIDs[this.size] = this.featureMap.getID(feature.getName());
            this.featureValues[this.size] = feature.getValue();
            ++this.size;
        }
        this.sort();
    }

    @Override
    protected void sort() {
        int[] sortedIndices = SortUtil.argsort((Comparable[])this.featureNames, (int)0, (int)this.size, (boolean)true);
        String[] newNames = Arrays.copyOf(this.featureNames, this.size);
        int[] newIDs = Arrays.copyOf(this.featureIDs, this.size);
        double[] newValues = Arrays.copyOf(this.featureValues, this.size);
        for (int i = 0; i < sortedIndices.length; ++i) {
            this.featureNames[i] = newNames[sortedIndices[i]];
            this.featureIDs[i] = newIDs[sortedIndices[i]];
            this.featureValues[i] = newValues[sortedIndices[i]];
        }
    }

    @Override
    public void reduceByName(Merger merger) {
        if (this.size > 0) {
            int[] sortedIndices = SortUtil.argsort((Comparable[])this.featureNames, (int)0, (int)this.size, (boolean)true);
            String[] newNames = new String[this.featureNames.length];
            int[] newIDs = new int[this.featureIDs.length];
            double[] newValues = new double[this.featureNames.length];
            for (int i = 0; i < sortedIndices.length; ++i) {
                newNames[i] = this.featureNames[sortedIndices[i]];
                newIDs[i] = this.featureIDs[sortedIndices[i]];
                newValues[i] = this.featureValues[sortedIndices[i]];
            }
            this.featureNames[0] = newNames[0];
            this.featureIDs[0] = newIDs[0];
            this.featureValues[0] = newValues[0];
            int dest = 0;
            for (int i = 1; i < this.size; ++i) {
                while (i < this.size && newNames[i].equals(this.featureNames[dest])) {
                    this.featureValues[dest] = merger.merge(this.featureValues[dest], newValues[i]);
                    ++i;
                }
                if (i >= this.size) continue;
                this.featureNames[++dest] = newNames[i];
                this.featureIDs[dest] = newIDs[i];
                this.featureValues[dest] = newValues[i];
            }
            this.size = dest + 1;
        }
    }

    @Override
    public void removeFeatures(List<Feature> featureList) {
        HashMap<String, List> map = new HashMap<String, List>();
        for (int i = 0; i < this.featureNames.length; ++i) {
            List list = map.computeIfAbsent(this.featureNames[i], k -> new ArrayList());
            list.add(i);
        }
        PriorityQueue removeQueue = new PriorityQueue();
        for (Feature f : featureList) {
            List i = (List)map.get(f.getName());
            if (i == null) continue;
            map.remove(f.getName());
            removeQueue.addAll(i);
        }
        String[] newNames = new String[this.size - removeQueue.size()];
        int[] newIDs = new int[this.size - removeQueue.size()];
        double[] newValues = new double[this.size - removeQueue.size()];
        int source = 0;
        int dest = 0;
        while (!removeQueue.isEmpty()) {
            int curRemoveIdx = (Integer)removeQueue.poll();
            while (source < curRemoveIdx) {
                newNames[dest] = this.featureNames[source];
                newIDs[dest] = this.featureIDs[source];
                newValues[dest] = this.featureValues[source];
                ++source;
                ++dest;
            }
            ++source;
        }
        while (source < this.size) {
            newNames[dest] = this.featureNames[source];
            newIDs[dest] = this.featureIDs[source];
            newValues[dest] = this.featureValues[source];
            ++source;
            ++dest;
        }
        this.featureNames = newNames;
        this.featureIDs = newIDs;
        this.featureValues = newValues;
        this.size = this.featureNames.length;
    }

    public boolean contains(int i) {
        return Arrays.binarySearch(this.featureIDs, i) > -1;
    }

    @Override
    public IndexedArrayExample<T> copy() {
        return new IndexedArrayExample<T>(this);
    }

    @Override
    public void densify(List<String> featureList) {
        if (featureList.size() > this.featureNames.length) {
            this.growArray(featureList.size());
        }
        int insertedCount = 0;
        int curPos = 0;
        for (String curName : featureList) {
            int newId = this.featureMap.getID(curName);
            if (newId == -1) {
                throw new IllegalArgumentException("Unexpected feature name '" + curName + "'");
            }
            if (curPos == this.size) {
                this.featureNames[this.size + insertedCount] = curName;
                this.featureIDs[this.size + insertedCount] = newId;
                ++insertedCount;
                continue;
            }
            int comparison = curName.compareTo(this.featureNames[curPos]);
            if (comparison < 0) {
                this.featureNames[this.size + insertedCount] = curName;
                this.featureIDs[this.size + insertedCount] = newId;
                ++insertedCount;
                continue;
            }
            if (comparison != 0) continue;
            ++curPos;
        }
        this.size += insertedCount;
        this.sort();
    }

    public int getIdx(int i) {
        return this.featureIDs[i];
    }

    public int getOutputID() {
        return this.outputID;
    }

    public Iterable<FeatureTuple> idIterator() {
        return () -> new ArrayIndexedExampleIterator();
    }

    @Override
    public ExampleProto serialize() {
        ExampleProto.Builder builder = ExampleProto.newBuilder();
        builder.setClassName(IndexedArrayExample.class.getName());
        builder.setVersion(0);
        IndexedArrayExampleProto.Builder exampleBuilder = IndexedArrayExampleProto.newBuilder();
        exampleBuilder.setWeight(this.weight);
        exampleBuilder.setOutput((OutputProto)this.output.serialize());
        for (int i = 0; i < this.size; ++i) {
            exampleBuilder.addFeatureName(this.featureNames[i]);
            exampleBuilder.addFeatureIdx(this.featureIDs[i]);
            exampleBuilder.addFeatureValue(this.featureValues[i]);
        }
        if (this.metadata != null) {
            for (Map.Entry e : this.metadata.entrySet()) {
                if (!(e.getValue() instanceof String)) {
                    logger.warning("Serializing non-string metadata for key '" + (String)e.getKey() + "' of type " + e.getValue().getClass());
                }
                exampleBuilder.putMetadata((String)e.getKey(), e.getValue().toString());
            }
        }
        builder.setSerializedData(Any.pack((Message)exampleBuilder.build()));
        return builder.build();
    }

    class ArrayIndexedExampleIterator
    implements Iterator<FeatureTuple> {
        int pos = 0;
        FeatureTuple tuple = new FeatureTuple();

        ArrayIndexedExampleIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.pos < IndexedArrayExample.this.size;
        }

        @Override
        public FeatureTuple next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("Off the end of the iterator.");
            }
            this.tuple.name = IndexedArrayExample.this.featureNames[this.pos];
            this.tuple.id = IndexedArrayExample.this.featureIDs[this.pos];
            this.tuple.value = IndexedArrayExample.this.featureValues[this.pos];
            ++this.pos;
            return this.tuple;
        }
    }

    public static class FeatureTuple {
        public String name;
        public int id;
        public double value;

        public FeatureTuple() {
        }

        public FeatureTuple(String name, int id, double value) {
            this.name = name;
            this.id = id;
            this.value = value;
        }
    }
}

