/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.impl;

import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import org.tribuo.Example;
import org.tribuo.Feature;
import org.tribuo.FeatureMap;
import org.tribuo.Output;
import org.tribuo.VariableInfo;
import org.tribuo.protos.ProtoUtil;
import org.tribuo.protos.core.ExampleDataProto;
import org.tribuo.protos.core.ExampleProto;
import org.tribuo.protos.core.OutputProto;
import org.tribuo.transform.Transformer;
import org.tribuo.transform.TransformerMap;
import org.tribuo.util.Merger;

public class ListExample<T extends Output<T>>
extends Example<T>
implements Serializable {
    private static final Logger logger = Logger.getLogger(ListExample.class.getName());
    private static final long serialVersionUID = 1L;
    public static final int CURRENT_VERSION = 0;
    private final List<Feature> features = new ArrayList<Feature>();

    public ListExample(T output, float weight) {
        super(output, weight);
    }

    public ListExample(T output) {
        super(output);
    }

    public ListExample(Example<T> other) {
        super(other);
        for (Feature f : other) {
            this.addWithoutSort(f.clone());
        }
        this.sort();
    }

    public ListExample(T output, List<? extends Feature> features) {
        super(output);
        for (Feature feature : features) {
            this.addWithoutSort(feature.clone());
        }
        this.sort();
    }

    public ListExample(T output, String[] featureNames, double[] featureValues) {
        super(output);
        if (featureNames.length != featureValues.length) {
            throw new IllegalArgumentException("Supplied names have length " + featureNames.length + ", supplied values have length " + featureValues.length);
        }
        for (int i = 0; i < featureNames.length; ++i) {
            this.addWithoutSort(new Feature(featureNames[i], featureValues[i]));
        }
        this.sort();
    }

    private ListExample(T output, float weight, String[] featureNames, double[] featureValues, Map<String, String> metadata) {
        super(output, weight);
        for (int i = 0; i < featureNames.length; ++i) {
            this.features.add(new Feature(featureNames[i], featureValues[i]));
        }
        for (Map.Entry<String, String> e : metadata.entrySet()) {
            this.setMetadataValue(e.getKey(), e.getValue());
        }
    }

    public static ListExample<?> deserializeFromProto(int version, String className, Any message) throws InvalidProtocolBufferException {
        if (version < 0 || version > 0) {
            throw new IllegalArgumentException("Unknown version " + version + ", this class supports at most version " + 0);
        }
        ExampleDataProto proto = (ExampleDataProto)message.unpack(ExampleDataProto.class);
        if (proto.getFeatureNameCount() != proto.getFeatureValueCount()) {
            throw new IllegalStateException("Invalid protobuf, different numbers of feature names and values, found " + proto.getFeatureNameCount() + " names and " + proto.getFeatureValueCount() + " values.");
        }
        Output output = (Output)ProtoUtil.deserialize(proto.getOutput());
        String[] featureNames = new String[proto.getFeatureNameCount()];
        double[] featureValues = new double[proto.getFeatureValueCount()];
        for (int i = 0; i < proto.getFeatureNameCount(); ++i) {
            featureNames[i] = proto.getFeatureName(i);
            featureValues[i] = proto.getFeatureValue(i);
        }
        return new ListExample<Output>(output, proto.getWeight(), featureNames, featureValues, proto.getMetadataMap());
    }

    private void addWithoutSort(Feature feature) {
        this.features.add(feature);
    }

    @Override
    public void add(Feature feature) {
        this.addWithoutSort(feature);
        this.sort();
    }

    @Override
    public void addAll(Collection<? extends Feature> features) {
        this.features.addAll(features);
        this.sort();
    }

    public void clear() {
        this.features.clear();
    }

    @Override
    public int size() {
        return this.features.size();
    }

    @Override
    public ListExample<T> copy() {
        return new ListExample<T>(this);
    }

    @Override
    public Iterator<Feature> iterator() {
        return this.features.iterator();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ListExample(numFeatures=");
        builder.append(this.features.size());
        builder.append(",output=");
        builder.append(this.output);
        builder.append(",weight=");
        builder.append(this.weight);
        if (this.metadata != null) {
            builder.append(",metadata=");
            builder.append(this.metadata.toString());
        }
        builder.append(",features=");
        builder.append(this.features.toString());
        builder.append(")");
        return builder.toString();
    }

    @Override
    protected void sort() {
        this.features.sort(Feature.featureNameComparator());
    }

    @Override
    public void removeFeatures(List<Feature> featureList) {
        this.features.removeAll(featureList);
    }

    @Override
    public void reduceByName(Merger merger) {
        if (this.features.size() > 0) {
            ArrayList<Feature> featuresToRemove = new ArrayList<Feature>();
            int buffer = 0;
            String name = this.features.get(buffer).getName();
            for (int i = 1; i < this.features.size(); ++i) {
                Feature f = this.features.get(i);
                if (f.getName().equals(name)) {
                    featuresToRemove.add(f);
                    Feature old = this.features.remove(buffer);
                    this.features.add(buffer, new Feature(old.getName(), merger.merge(old.getValue(), f.getValue())));
                    continue;
                }
                name = f.getName();
                buffer = i;
            }
            this.features.removeAll(featuresToRemove);
        } else {
            logger.finer("Reducing an example with no features.");
        }
    }

    @Override
    public Feature lookup(String i) {
        int index = Collections.binarySearch(this.features, new Feature(i, 1.0));
        if (index < 0) {
            return null;
        }
        return this.features.get(index);
    }

    @Override
    public void set(Feature feature) {
        int index = Collections.binarySearch(this.features, feature);
        if (index < 0) {
            throw new IllegalArgumentException("Feature " + feature + " not found in example.");
        }
        this.features.set(index, feature);
    }

    @Override
    public boolean validateExample() {
        if (this.features.isEmpty()) {
            return false;
        }
        HashSet<String> names = new HashSet<String>();
        for (Feature f : this.features) {
            names.add(f.getName());
            if (!Double.isNaN(f.getValue())) continue;
            return false;
        }
        return names.size() == this.features.size();
    }

    @Override
    public void transform(TransformerMap transformerMap) {
        for (Map.Entry<String, List<Transformer>> e : transformerMap.entrySet()) {
            int index = Collections.binarySearch(this.features, new Feature(e.getKey(), 1.0));
            if (index < 0) continue;
            double value = this.features.get(index).getValue();
            for (Transformer t : e.getValue()) {
                value = t.transform(value);
            }
            this.features.set(index, new Feature(e.getKey(), value));
        }
    }

    @Override
    public boolean isDense(FeatureMap fMap) {
        if (fMap.size() == this.size()) {
            for (Feature feature : this.features) {
                if (fMap.get(feature.getName()) != null) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    protected void densify(List<String> featureNames) {
        HashSet<String> featureSet = new HashSet<String>(featureNames);
        for (Feature f : this.features) {
            featureSet.remove(f.getName());
        }
        for (String s : featureSet) {
            this.features.add(new Feature(s, 0.0));
        }
        this.sort();
    }

    @Override
    public void canonicalize(FeatureMap featureMap) {
        ArrayList<Feature> remadeFeatures = new ArrayList<Feature>();
        for (Feature f : this.features) {
            VariableInfo vi = featureMap.get(f.getName());
            if (vi != null) {
                remadeFeatures.add(new Feature(vi.getName(), f.getValue()));
                continue;
            }
            remadeFeatures.add(f);
        }
        this.features.clear();
        this.features.addAll(remadeFeatures);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListExample)) {
            return false;
        }
        ListExample that = (ListExample)o;
        if (Objects.equals(this.metadata, that.metadata) && this.output.getClass().equals(that.output.getClass())) {
            boolean outputTest = this.output.fullEquals(that.output);
            return outputTest && this.features.equals(that.features);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.features);
    }

    @Override
    public ExampleProto serialize() {
        ExampleProto.Builder builder = ExampleProto.newBuilder();
        builder.setClassName(ListExample.class.getName());
        builder.setVersion(0);
        ExampleDataProto.Builder exampleBuilder = ExampleDataProto.newBuilder();
        exampleBuilder.setWeight(this.weight);
        exampleBuilder.setOutput((OutputProto)this.output.serialize());
        for (int i = 0; i < this.features.size(); ++i) {
            exampleBuilder.addFeatureName(this.features.get(i).getName());
            exampleBuilder.addFeatureValue(this.features.get(i).getValue());
        }
        if (this.metadata != null) {
            for (Map.Entry e : this.metadata.entrySet()) {
                if (!(e.getValue() instanceof String)) {
                    logger.warning("Serializing non-string metadata for key '" + (String)e.getKey() + "' of type " + e.getValue().getClass());
                }
                exampleBuilder.putMetadata((String)e.getKey(), e.getValue().toString());
            }
        }
        builder.setSerializedData(Any.pack((Message)exampleBuilder.build()));
        return builder.build();
    }
}

