/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.impl;

import com.oracle.labs.mlrg.olcut.config.protobuf.ProtoProvenanceSerialization;
import com.oracle.labs.mlrg.olcut.provenance.ObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.ProvenanceUtil;
import java.util.List;
import java.util.Objects;
import org.tribuo.FeatureMap;
import org.tribuo.ImmutableFeatureMap;
import org.tribuo.ImmutableOutputInfo;
import org.tribuo.Output;
import org.tribuo.OutputInfo;
import org.tribuo.protos.core.ModelDataProto;
import org.tribuo.protos.core.OutputDomainProto;
import org.tribuo.provenance.ModelProvenance;

public final class ModelDataCarrier<T extends Output<T>> {
    private static final ProtoProvenanceSerialization PROVENANCE_SERIALIZER = new ProtoProvenanceSerialization(false);
    private final String name;
    private final ModelProvenance provenance;
    private final ImmutableFeatureMap featureDomain;
    private final ImmutableOutputInfo<T> outputDomain;
    private final boolean generatesProbabilities;
    private final String tribuoVersion;

    public ModelDataCarrier(String name, ModelProvenance provenance, ImmutableFeatureMap featureDomain, ImmutableOutputInfo<T> outputDomain, boolean generatesProbabilities, String tribuoVersion) {
        this.name = name;
        this.provenance = provenance;
        this.featureDomain = featureDomain;
        this.outputDomain = outputDomain;
        this.generatesProbabilities = generatesProbabilities;
        this.tribuoVersion = tribuoVersion;
    }

    public String name() {
        return this.name;
    }

    public ModelProvenance provenance() {
        return this.provenance;
    }

    public ImmutableFeatureMap featureDomain() {
        return this.featureDomain;
    }

    public ImmutableOutputInfo<T> outputDomain() {
        return this.outputDomain;
    }

    public boolean generatesProbabilities() {
        return this.generatesProbabilities;
    }

    public String tribuoVersion() {
        return this.tribuoVersion;
    }

    public static ModelDataCarrier<?> deserialize(ModelDataProto proto) {
        ModelProvenance provenance = (ModelProvenance)ProvenanceUtil.unmarshalProvenance((List)PROVENANCE_SERIALIZER.deserializeFromProto(proto.getProvenance()));
        ImmutableFeatureMap featureDomain = (ImmutableFeatureMap)FeatureMap.deserialize(proto.getFeatureDomain());
        ImmutableOutputInfo outputDomain = (ImmutableOutputInfo)OutputInfo.deserialize(proto.getOutputDomain());
        return new ModelDataCarrier(proto.getName(), provenance, featureDomain, outputDomain, proto.getGenerateProbabilities(), proto.getTribuoVersion());
    }

    public ModelDataProto serialize() {
        ModelDataProto.Builder builder = ModelDataProto.newBuilder();
        builder.setName(this.name);
        builder.setGenerateProbabilities(this.generatesProbabilities);
        builder.setFeatureDomain(this.featureDomain.serialize());
        builder.setOutputDomain((OutputDomainProto)this.outputDomain.serialize());
        builder.setProvenance(PROVENANCE_SERIALIZER.serializeToProto(ProvenanceUtil.marshalProvenance((ObjectProvenance)this.provenance)));
        builder.setTribuoVersion(this.tribuoVersion);
        return builder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModelDataCarrier)) {
            return false;
        }
        ModelDataCarrier that = (ModelDataCarrier)o;
        return this.generatesProbabilities == that.generatesProbabilities && this.name.equals(that.name) && this.provenance.equals(that.provenance) && this.featureDomain.equals(that.featureDomain) && this.outputDomain.equals(that.outputDomain) && this.tribuoVersion.equals(that.tribuoVersion);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.provenance, this.featureDomain, this.outputDomain, this.generatesProbabilities, this.tribuoVersion);
    }

    public String toString() {
        return "ModelDataCarrier{name='" + this.name + '\'' + ", provenance=" + this.provenance + ", featureDomain=" + this.featureDomain + ", outputDomain=" + this.outputDomain + ", generatesProbabilities=" + this.generatesProbabilities + ", tribuoVersion=" + this.tribuoVersion + '}';
    }
}

