/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.protos;

import com.google.protobuf.Any;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.oracle.labs.mlrg.olcut.provenance.ObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.ProvenanceUtil;
import com.oracle.labs.mlrg.olcut.util.MutableDouble;
import com.oracle.labs.mlrg.olcut.util.MutableLong;
import com.oracle.labs.mlrg.olcut.util.Pair;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.tribuo.protos.ProtoSerializable;
import org.tribuo.protos.ProtoSerializableClass;
import org.tribuo.protos.ProtoSerializableField;
import org.tribuo.protos.ProtoSerializableKeysValuesField;
import org.tribuo.protos.ProtoSerializableMapField;
import org.tribuo.protos.ProtoSerializableMapValuesField;

public final class ProtoUtil {
    private static final Logger logger = Logger.getLogger(ProtoUtil.class.getName());
    private static final Map<Pair<Integer, String>, String> REDIRECT_MAP = new HashMap<Pair<Integer, String>, String>();

    private ProtoUtil() {
    }

    public static <SERIALIZED extends Message, PROTO_SERIALIZABLE extends ProtoSerializable<SERIALIZED>> PROTO_SERIALIZABLE deserialize(SERIALIZED serialized) {
        Descriptors.FieldDescriptor fieldDescriptor = serialized.getDescriptorForType().findFieldByName("version");
        int version = (Integer)serialized.getField(fieldDescriptor);
        fieldDescriptor = serialized.getDescriptorForType().findFieldByName("class_name");
        String className = (String)serialized.getField(fieldDescriptor);
        Pair key = new Pair((Object)version, (Object)className);
        String targetClassName = REDIRECT_MAP.getOrDefault(key, className);
        try {
            Class<?> protoSerializableClass = Class.forName(targetClassName);
            if (!ProtoSerializable.class.isAssignableFrom(protoSerializableClass)) {
                throw new IllegalStateException("Class " + targetClassName + " does not implement ProtoSerializable");
            }
            fieldDescriptor = serialized.getDescriptorForType().findFieldByName("serialized_data");
            Any serializedData = (Any)serialized.getField(fieldDescriptor);
            Method method = protoSerializableClass.getDeclaredMethod("deserializeFromProto", Integer.TYPE, String.class, Any.class);
            Class<?> deserializationReturnType = method.getReturnType();
            if (!ProtoSerializable.class.isAssignableFrom(deserializationReturnType)) {
                throw new IllegalStateException("Method " + protoSerializableClass + "." + "deserializeFromProto" + " does not return an instance of " + protoSerializableClass);
            }
            method.setAccessible(true);
            ProtoSerializable protoSerializable = (ProtoSerializable)method.invoke(null, version, targetClassName, serializedData);
            method.setAccessible(false);
            return (PROTO_SERIALIZABLE)protoSerializable;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Failed to find class " + targetClassName, e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Failed to find deserialization method deserializeFromProto(int, String, com.google.protobuf.Any) on class " + targetClassName, e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Failed to invoke deserialization method deserializeFromProto(int, String, com.google.protobuf.Any) on class " + targetClassName, e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException("The deserialization method for deserializeFromProto(int, String, com.google.protobuf.Any) on class " + targetClassName + " threw an exception", e);
        }
    }

    public static <SERIALIZED_CLASS extends Message, SERIALIZED_DATA extends Message, PROTO_SERIALIZABLE extends ProtoSerializable<SERIALIZED_CLASS>> SERIALIZED_CLASS serialize(PROTO_SERIALIZABLE protoSerializable) {
        try {
            ProtoSerializableClass annotation = protoSerializable.getClass().getAnnotation(ProtoSerializableClass.class);
            if (annotation == null) {
                throw new IllegalArgumentException("instance of ProtoSerializable must be annotated with @ProtoSerializableClass to be serialized with ProtoUtil.serialize()");
            }
            Class<SERIALIZED_CLASS> serializedClass = ProtoUtil.getSerializedClass(protoSerializable);
            Message.Builder serializedClassBuilder = (Message.Builder)serializedClass.getMethod("newBuilder", new Class[0]).invoke(null, new Object[0]);
            Class<?> serializedClassBuilderClass = serializedClassBuilder.getClass();
            serializedClassBuilderClass.getMethod("setVersion", Integer.TYPE).invoke((Object)serializedClassBuilder, annotation.version());
            serializedClassBuilderClass.getMethod("setClassName", String.class).invoke((Object)serializedClassBuilder, protoSerializable.getClass().getName());
            Class<? extends Message> serializedDataClass = annotation.serializedDataClass();
            if (serializedDataClass != Message.class) {
                Message.Builder serializedDataBuilder = (Message.Builder)serializedDataClass.getMethod("newBuilder", new Class[0]).invoke(null, new Object[0]);
                Class<?> serializedDataBuilderClass = serializedDataBuilder.getClass();
                for (Field field : ProtoUtil.getFields(protoSerializable.getClass())) {
                    ProtoSerializableMapValuesField psmvf;
                    ProtoSerializableKeysValuesField pskvf;
                    ProtoSerializableMapField psmf;
                    field.setAccessible(true);
                    List<Object> obj = field.get(protoSerializable);
                    ProtoSerializableField protoSerializableField = field.getAnnotation(ProtoSerializableField.class);
                    if (protoSerializableField != null) {
                        Class<?> fieldClazz;
                        String fieldName = protoSerializableField.name();
                        if (fieldName.equals("[DEFAULT_FIELD_NAME]")) {
                            fieldName = field.getName();
                        }
                        String nameStub = (fieldClazz = field.getType()).isArray() || Collection.class.isAssignableFrom(fieldClazz) ? "addAll" : "set";
                        Method setter = ProtoUtil.findMethod(serializedDataBuilderClass, nameStub, fieldName, 1);
                        obj = ProtoUtil.convert(obj);
                        setter.setAccessible(true);
                        setter.invoke((Object)serializedDataBuilder, obj);
                        setter.setAccessible(false);
                    }
                    if ((psmf = field.getAnnotation(ProtoSerializableMapField.class)) != null) {
                        if (!(obj instanceof Map) && obj != null) {
                            throw new IllegalStateException("Field of type " + obj.getClass() + " was annotated with ProtoSerializableMapField which is only supported on java.util.Map fields");
                        }
                        String fieldName = psmf.name();
                        if (fieldName.equals("[DEFAULT_FIELD_NAME]")) {
                            fieldName = field.getName();
                        }
                        Method setter = ProtoUtil.findMethod(serializedDataBuilderClass, "put", fieldName, 2);
                        Map map = (Map)((Object)obj);
                        if (map != null) {
                            for (Map.Entry e : map.entrySet()) {
                                Object key = ProtoUtil.convert(e.getKey());
                                Object value = ProtoUtil.convert(e.getValue());
                                setter.invoke((Object)serializedDataBuilder, key, value);
                            }
                        }
                    }
                    if ((pskvf = field.getAnnotation(ProtoSerializableKeysValuesField.class)) != null) {
                        if (!(obj instanceof Map) && obj != null) {
                            throw new IllegalStateException("Field of type " + obj.getClass() + " was annotated with ProtoSerializableKeysValuesField which is only supported on java.util.Map fields");
                        }
                        Method keyAdder = ProtoUtil.findMethod(serializedDataBuilderClass, "add", pskvf.keysName(), 1);
                        keyAdder.setAccessible(true);
                        Method valueAdder = ProtoUtil.findMethod(serializedDataBuilderClass, "add", pskvf.valuesName(), 1);
                        valueAdder.setAccessible(true);
                        Map map = (Map)((Object)obj);
                        if (map != null) {
                            for (Map.Entry e : map.entrySet()) {
                                keyAdder.invoke((Object)serializedDataBuilder, ProtoUtil.convert(e.getKey()));
                                valueAdder.invoke((Object)serializedDataBuilder, ProtoUtil.convert(e.getValue()));
                            }
                        }
                        keyAdder.setAccessible(false);
                        valueAdder.setAccessible(false);
                    }
                    if ((psmvf = field.getAnnotation(ProtoSerializableMapValuesField.class)) != null) {
                        if (!(obj instanceof Map) && obj != null) {
                            throw new IllegalStateException("Field of type " + obj.getClass() + " was annotated with ProtoSerializableMapValuesField which is only supported on java.util.Map fields");
                        }
                        Method valuesAdder = ProtoUtil.findMethod(serializedDataBuilderClass, "addAll", psmvf.valuesName(), 1);
                        obj = ProtoUtil.convertValues((Map)((Object)obj));
                        valuesAdder.setAccessible(true);
                        valuesAdder.invoke((Object)serializedDataBuilder, obj);
                        valuesAdder.setAccessible(false);
                    }
                    field.setAccessible(false);
                }
                serializedClassBuilderClass.getMethod("setSerializedData", Any.class).invoke((Object)serializedClassBuilder, Any.pack((Message)serializedDataBuilder.build()));
            }
            return (SERIALIZED_CLASS)serializedClassBuilder.build();
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static int getCurrentVersion(Class<? extends ProtoSerializable<?>> clazz) {
        ProtoSerializableClass ann = clazz.getAnnotation(ProtoSerializableClass.class);
        if (ann != null) {
            return ann.version();
        }
        return -1;
    }

    static <SERIALIZED_CLASS extends Message, PROTO_SERIALIZABLE extends ProtoSerializable<SERIALIZED_CLASS>> Class<SERIALIZED_CLASS> getSerializedClass(PROTO_SERIALIZABLE protoSerializable) {
        Class serializedClass = ProtoUtil.resolveTypeParameter(ProtoSerializable.class, protoSerializable.getClass(), ProtoSerializable.class.getTypeParameters()[0]);
        if (serializedClass != null) {
            return serializedClass;
        }
        String tpName = ProtoSerializable.class.getTypeParameters()[0].getName();
        throw new IllegalArgumentException("unable to resolve type parameter '" + tpName + "' in ProtoSerializable<" + tpName + "> for class " + protoSerializable.getClass().getName());
    }

    private static List<Object> convertValues(Map<?, ?> obj) {
        ArrayList<Object> values = new ArrayList<Object>();
        for (Object value : obj.values()) {
            values.add(ProtoUtil.convert(value));
        }
        return values;
    }

    private static Object convert(Object obj) {
        if (obj instanceof ProtoSerializable) {
            return ((ProtoSerializable)obj).serialize();
        }
        if (obj instanceof ObjectProvenance) {
            return ProtoSerializable.PROVENANCE_SERIALIZER.serializeToProto(ProvenanceUtil.marshalProvenance((ObjectProvenance)((ObjectProvenance)obj)));
        }
        if (obj instanceof MutableLong) {
            return ((MutableLong)obj).longValue();
        }
        if (obj instanceof MutableDouble) {
            return ((MutableDouble)obj).doubleValue();
        }
        if (obj.getClass().isEnum()) {
            return ((Enum)obj).name();
        }
        if (obj instanceof List) {
            List list = (List)obj;
            return list.stream().map(ProtoUtil::convert).collect(Collectors.toList());
        }
        if (obj instanceof int[]) {
            int[] t = (int[])obj;
            return Arrays.stream(t).boxed().collect(Collectors.toList());
        }
        if (obj instanceof long[]) {
            long[] t = (long[])obj;
            return Arrays.stream(t).boxed().collect(Collectors.toList());
        }
        if (obj instanceof float[]) {
            float[] t = (float[])obj;
            ArrayList<Float> floats = new ArrayList<Float>();
            for (float f : t) {
                floats.add(Float.valueOf(f));
            }
            return floats;
        }
        if (obj instanceof double[]) {
            double[] t = (double[])obj;
            return Arrays.stream(t).boxed().collect(Collectors.toList());
        }
        if (obj instanceof String[]) {
            return Arrays.asList((String[])obj);
        }
        if (obj instanceof Double || obj instanceof Float || obj instanceof Byte || obj instanceof Short || obj instanceof Character || obj instanceof Integer || obj instanceof Long || obj instanceof Boolean || obj instanceof String) {
            return obj;
        }
        throw new IllegalArgumentException("Invalid protobuf field type " + obj.getClass());
    }

    private static List<Field> getFields(Class<?> clazz) {
        HashSet<String> fieldNameSet = new HashSet<String>();
        ArrayList<Field> fields = new ArrayList<Field>();
        ProtoUtil.getFields(clazz, fieldNameSet, fields);
        return fields;
    }

    private static void getFields(Class<?> clazz, Set<String> fieldNameSet, List<Field> fields) {
        for (Field field : clazz.getDeclaredFields()) {
            String protoFieldName;
            ProtoSerializableField psf = field.getAnnotation(ProtoSerializableField.class);
            ProtoSerializableMapField psmf = field.getAnnotation(ProtoSerializableMapField.class);
            ProtoSerializableKeysValuesField pskvf = field.getAnnotation(ProtoSerializableKeysValuesField.class);
            ProtoSerializableMapValuesField psmvf = field.getAnnotation(ProtoSerializableMapValuesField.class);
            if (psf != null && psmf == null && pskvf == null && psmvf == null) {
                protoFieldName = psf.name().equals("[DEFAULT_FIELD_NAME]") ? field.getName() : psf.name();
                if (!fieldNameSet.contains(protoFieldName)) {
                    fields.add(field);
                    fieldNameSet.add(field.getName());
                    continue;
                }
                logger.warning("Duplicate field named " + protoFieldName + " detected in class " + clazz);
                continue;
            }
            if (psf == null && psmf != null && pskvf == null && psmvf == null) {
                protoFieldName = psmf.name().equals("[DEFAULT_FIELD_NAME]") ? field.getName() : psmf.name();
                if (!fieldNameSet.contains(protoFieldName)) {
                    fields.add(field);
                    fieldNameSet.add(field.getName());
                    continue;
                }
                logger.warning("Duplicate field named " + protoFieldName + " detected in class " + clazz);
                continue;
            }
            if (psf == null && psmf == null && pskvf != null && psmvf == null) {
                String keyName = pskvf.keysName();
                String valueName = pskvf.valuesName();
                if (fieldNameSet.contains(keyName) && fieldNameSet.contains(valueName)) continue;
                if (fieldNameSet.contains(keyName) || fieldNameSet.contains(valueName)) {
                    throw new IllegalStateException("ProtoSerializableKeysValuesField on " + clazz.getName() + "." + field.getName() + " collides with another ProtoSerializable annotation");
                }
                fields.add(field);
                fieldNameSet.add(keyName);
                fieldNameSet.add(valueName);
                continue;
            }
            if (psf == null && psmf == null && pskvf == null && psmvf != null) {
                String valuesName = psmvf.valuesName();
                if (fieldNameSet.contains(valuesName)) continue;
                fields.add(field);
                fieldNameSet.add(valuesName);
                continue;
            }
            if (psf == null && psmf == null && pskvf == null && psmvf == null) continue;
            String message = "Multiple ProtoSerializable annotations applied to the same field, found ProtoSerializableField = " + psf + ", ProtoSerializableMapField = " + psmf + ", ProtoSerializableKeysValuesField = " + pskvf + ", ProtoSerializableMapValuesField = " + psmvf + " on field named " + field.getName() + " of class " + clazz;
            throw new IllegalStateException(message);
        }
        Class<?> superclass = clazz.getSuperclass();
        if (superclass != null && !superclass.equals(Object.class)) {
            ProtoUtil.getFields(superclass, fieldNameSet, fields);
        }
    }

    private static Method findMethod(Class<?> serializedDataBuilderClass, String prefixName, String fieldName, int expectedParamCount) {
        String methodName = ProtoUtil.generateMethodName(prefixName, fieldName);
        for (Method method : serializedDataBuilderClass.getMethods()) {
            if (!method.getName().equals(methodName) || method.getParameterTypes().length != expectedParamCount) continue;
            if (expectedParamCount == 0) {
                return method;
            }
            Class<?> clazz = method.getParameterTypes()[0];
            if (Message.Builder.class.isAssignableFrom(clazz)) continue;
            return method;
        }
        throw new IllegalArgumentException("Unable to find method " + methodName + " for field name: " + fieldName + " in class: " + serializedDataBuilderClass.getName());
    }

    public static String generateMethodName(String prefix, String name) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix);
        sb.append(("" + name.charAt(0)).toUpperCase());
        sb.append(name.substring(1));
        return sb.toString();
    }

    private static <I, C extends I> Class<?> resolveTypeParameter(Class<I> intrface, Class<C> clazz, TypeVariable<?> typeVariable) {
        return ProtoUtil.resolveTypeParameter(intrface, clazz, new MutableTypeVariable(typeVariable));
    }

    private static <I, C extends I> Class<?> resolveTypeParameter(Class<I> intrface, Class<C> clazz, MutableTypeVariable typeVariable) {
        Class<?> clazz2;
        Class<C> superClass = clazz.getSuperclass();
        if (superClass != null && intrface.isAssignableFrom(superClass) && (clazz2 = ProtoUtil.resolveTypeParameter(intrface, superClass, typeVariable)) != null) {
            return clazz2;
        }
        for (Class<?> iface : clazz.getInterfaces()) {
            Class<?> serializedClass2;
            if (!intrface.isAssignableFrom(iface) || intrface.equals(iface) || (serializedClass2 = ProtoUtil.resolveTypeParameter(intrface, iface, typeVariable)) == null) continue;
            return serializedClass2;
        }
        List<ParameterizedType> list = ProtoUtil.getGenericSuperParameterizedTypes(intrface, clazz);
        for (ParameterizedType genericInterface : list) {
            Type t = ProtoUtil.getParameterType(genericInterface, typeVariable.var);
            if (t instanceof TypeVariable) {
                typeVariable.var = (TypeVariable)t;
                continue;
            }
            if (!(t instanceof Class)) continue;
            return (Class)t;
        }
        return null;
    }

    private static List<ParameterizedType> getGenericSuperParameterizedTypes(Class<?> intrface, Class<?> clazz) {
        ArrayList<ParameterizedType> pts = new ArrayList<ParameterizedType>();
        Type genericSuperclass = clazz.getGenericSuperclass();
        if (genericSuperclass instanceof ParameterizedType) {
            pts.add((ParameterizedType)genericSuperclass);
        }
        for (Type genericInterface : clazz.getGenericInterfaces()) {
            ParameterizedType pt;
            if (!(genericInterface instanceof ParameterizedType) || !intrface.isAssignableFrom((Class)(pt = (ParameterizedType)genericInterface).getRawType())) continue;
            pts.add((ParameterizedType)genericInterface);
        }
        return pts;
    }

    private static Type getParameterType(ParameterizedType parameterizedType, TypeVariable<?> typeVariable) {
        Type[] actualTypeArguments;
        TypeVariable<Class<T>>[] typeParameters;
        Type rawType = parameterizedType.getRawType();
        if (rawType instanceof Class && (typeParameters = ((Class)rawType).getTypeParameters()).length == (actualTypeArguments = parameterizedType.getActualTypeArguments()).length) {
            for (int i = 0; i < typeParameters.length; ++i) {
                TypeVariable tp = typeParameters[i];
                if (!tp.getName().equals(typeVariable.getName())) continue;
                Type actualTypeArgument = actualTypeArguments[i];
                return actualTypeArgument;
            }
        }
        return null;
    }

    private static final class MutableTypeVariable {
        private TypeVariable<?> var;

        MutableTypeVariable(TypeVariable<?> var) {
            this.var = var;
        }
    }
}

