/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.provenance;

import com.oracle.labs.mlrg.olcut.provenance.ObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.Provenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.StringProvenance;
import com.oracle.labs.mlrg.olcut.util.Pair;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.tribuo.provenance.DatasetProvenance;
import org.tribuo.provenance.FeatureSelectorProvenance;
import org.tribuo.provenance.ModelProvenance;

public final class FeatureSetProvenance
implements ObjectProvenance {
    private static final long serialVersionUID = 1L;
    private static final String DATASET = "dataset";
    private static final String SELECTOR = "feature-selector";
    private static final String TRIBUO_VERSION_STRING = "tribuo-version";
    private final String className;
    private final DatasetProvenance datasetProvenance;
    private final FeatureSelectorProvenance fsProvenance;
    private final String versionString;

    public FeatureSetProvenance(String className, DatasetProvenance datasetProvenance, FeatureSelectorProvenance fsProvenance) {
        this.className = className;
        this.datasetProvenance = datasetProvenance;
        this.fsProvenance = fsProvenance;
        this.versionString = "4.3.1";
    }

    public FeatureSetProvenance(Map<String, Provenance> map) {
        this.className = ((StringProvenance)ObjectProvenance.checkAndExtractProvenance(map, (String)"class-name", StringProvenance.class, (String)ModelProvenance.class.getSimpleName())).getValue();
        this.datasetProvenance = (DatasetProvenance)ObjectProvenance.checkAndExtractProvenance(map, (String)DATASET, DatasetProvenance.class, (String)FeatureSetProvenance.class.getSimpleName());
        this.fsProvenance = (FeatureSelectorProvenance)ObjectProvenance.checkAndExtractProvenance(map, (String)SELECTOR, FeatureSelectorProvenance.class, (String)FeatureSetProvenance.class.getSimpleName());
        this.versionString = ((StringProvenance)ObjectProvenance.checkAndExtractProvenance(map, (String)TRIBUO_VERSION_STRING, StringProvenance.class, (String)FeatureSetProvenance.class.getSimpleName())).getValue();
    }

    public DatasetProvenance getDatasetProvenance() {
        return this.datasetProvenance;
    }

    public FeatureSelectorProvenance getFeatureSelectorProvenance() {
        return this.fsProvenance;
    }

    public String getTribuoVersion() {
        return this.versionString;
    }

    public String toString() {
        return this.generateString("FeatureSet");
    }

    public String getClassName() {
        return this.className;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FeatureSetProvenance)) {
            return false;
        }
        FeatureSetProvenance pairs = (FeatureSetProvenance)o;
        return this.className.equals(pairs.className) && this.datasetProvenance.equals(pairs.datasetProvenance) && this.fsProvenance.equals(pairs.fsProvenance) && this.versionString.equals(pairs.versionString);
    }

    public int hashCode() {
        return Objects.hash(this.className, this.datasetProvenance, this.versionString);
    }

    protected List<Pair<String, Provenance>> internalProvenances() {
        ArrayList<Pair<String, Provenance>> iterable = new ArrayList<Pair<String, Provenance>>();
        iterable.add(new Pair((Object)"class-name", (Object)new StringProvenance("class-name", this.className)));
        iterable.add(new Pair((Object)DATASET, (Object)this.datasetProvenance));
        iterable.add(new Pair((Object)SELECTOR, (Object)this.fsProvenance));
        iterable.add(new Pair((Object)TRIBUO_VERSION_STRING, (Object)new StringProvenance(TRIBUO_VERSION_STRING, this.versionString)));
        return iterable;
    }

    public Iterator<Pair<String, Provenance>> iterator() {
        return this.internalProvenances().iterator();
    }
}

