/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.sequence;

import com.oracle.labs.mlrg.olcut.command.Command;
import com.oracle.labs.mlrg.olcut.command.CommandGroup;
import com.oracle.labs.mlrg.olcut.command.CommandInterpreter;
import com.oracle.labs.mlrg.olcut.config.ConfigurationManager;
import com.oracle.labs.mlrg.olcut.config.Option;
import com.oracle.labs.mlrg.olcut.config.Options;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jline.builtins.Completers;
import org.jline.reader.Completer;
import org.jline.reader.impl.completer.NullCompleter;
import org.tribuo.VariableIDInfo;
import org.tribuo.VariableInfo;
import org.tribuo.sequence.SequenceModel;

public class SequenceModelExplorer
implements CommandGroup {
    private static final Logger logger = Logger.getLogger(SequenceModelExplorer.class.getName());
    private final CommandInterpreter shell = new CommandInterpreter();
    private SequenceModel<?> model;

    public SequenceModelExplorer() {
        this.shell.setPrompt("model sh% ");
    }

    public String getName() {
        return "Sequence Model Explorer";
    }

    public String getDescription() {
        return "Commands for inspecting a SequenceModel.";
    }

    public Completer[] fileCompleter() {
        return new Completer[]{new Completers.FileNameCompleter(), new NullCompleter()};
    }

    public void startShell() {
        this.shell.add((CommandGroup)this);
        this.shell.start();
    }

    @Command(usage="<filename> <is-protobuf-format> - Load a model from disk.", completers="fileCompleter")
    public String loadModel(CommandInterpreter ci, File path, boolean protobuf) {
        String output = "Failed to load model";
        if (protobuf) {
            try {
                this.model = SequenceModel.deserializeFromFile(path.toPath());
                output = "Loaded model from path " + path.getAbsolutePath();
            }
            catch (IllegalStateException e) {
                logger.log(Level.SEVERE, "Failed to deserialize protobuf when reading from file " + path.getAbsolutePath(), e);
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "IOException when reading from file " + path.getAbsolutePath(), e);
            }
        } else {
            try (ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(new FileInputStream(path)));){
                this.model = (SequenceModel)ois.readObject();
                output = "Loaded model from path " + path.getAbsolutePath();
            }
            catch (ClassNotFoundException e) {
                logger.log(Level.SEVERE, "Failed to load class from stream " + path.getAbsolutePath(), e);
            }
            catch (FileNotFoundException e) {
                logger.log(Level.SEVERE, "Failed to open file " + path.getAbsolutePath(), e);
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "IOException when reading from file " + path.getAbsolutePath(), e);
            }
        }
        return output;
    }

    @Command(usage="Shows the model description")
    public String modelDescription(CommandInterpreter ci) {
        return this.model.toString();
    }

    @Command(usage="Shows the information on a particular feature")
    public String featureInfo(CommandInterpreter ci, String featureName) {
        VariableIDInfo f = this.model.getFeatureIDMap().get(featureName);
        if (f != null) {
            return "" + f.toString();
        }
        return "Feature " + featureName + " not found.";
    }

    @Command(usage="Shows the output information.")
    public String outputInfo(CommandInterpreter ci) {
        return this.model.getOutputIDInfo().toReadableString();
    }

    @Command(usage="<int> - Shows the top N features in the model")
    public String topFeatures(CommandInterpreter ci, int numFeatures) {
        return "" + this.model.getTopFeatures(numFeatures);
    }

    @Command(usage="Shows the number of features in the model")
    public String numFeatures(CommandInterpreter ci) {
        return "" + this.model.getFeatureIDMap().size();
    }

    @Command(usage="<min count> - Shows the number of features that occurred more than min count times.")
    public String minCount(CommandInterpreter ci, int minCount) {
        int counter = 0;
        for (VariableInfo f : this.model.getFeatureIDMap()) {
            if (f.getCount() <= minCount) continue;
            ++counter;
        }
        return counter + " features occurred more than " + minCount + " times.";
    }

    public static void main(String[] args) {
        SequenceModelExplorerOptions options = new SequenceModelExplorerOptions();
        ConfigurationManager cm = new ConfigurationManager(args, (Options)options, false);
        SequenceModelExplorer driver = new SequenceModelExplorer();
        if (options.modelFilename != null) {
            logger.log(Level.INFO, driver.loadModel(driver.shell, new File(options.modelFilename), options.protobufFormat));
        }
        driver.startShell();
    }

    public static class SequenceModelExplorerOptions
    implements Options {
        @Option(charName=102, longName="filename", usage="Model file to load. Optional.")
        public String modelFilename;
        @Option(charName=112, longName="protobuf-model", usage="Load the model from a protobuf. Optional")
        public boolean protobufFormat;
    }
}

