/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.transform.transformations;

import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import com.oracle.labs.mlrg.olcut.provenance.Provenance;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.tribuo.protos.ProtoSerializableClass;
import org.tribuo.protos.ProtoSerializableField;
import org.tribuo.protos.ProtoUtil;
import org.tribuo.protos.core.IDFTransformerProto;
import org.tribuo.protos.core.TransformerProto;
import org.tribuo.transform.TransformStatistics;
import org.tribuo.transform.Transformation;
import org.tribuo.transform.TransformationProvenance;
import org.tribuo.transform.Transformer;

public class IDFTransformation
implements Transformation {
    private TransformationProvenance provenance;

    @Override
    public TransformStatistics createStats() {
        return new IDFStatistics();
    }

    public TransformationProvenance getProvenance() {
        if (this.provenance == null) {
            this.provenance = new IDFTransformationProvenance();
        }
        return this.provenance;
    }

    private static class IDFStatistics
    implements TransformStatistics {
        private int df;
        private int sparseObservances;

        private IDFStatistics() {
        }

        @Override
        public void observeValue(double value) {
            ++this.df;
        }

        @Override
        @Deprecated
        public void observeSparse() {
            ++this.sparseObservances;
        }

        @Override
        public void observeSparse(int count) {
            this.sparseObservances = count;
        }

        @Override
        public Transformer generateTransformer() {
            return new IDFTransformer(this.df, this.df + this.sparseObservances);
        }
    }

    public static final class IDFTransformationProvenance
    implements TransformationProvenance {
        private static final long serialVersionUID = 1L;

        IDFTransformationProvenance() {
        }

        public IDFTransformationProvenance(Map<String, Provenance> map) {
        }

        public Map<String, Provenance> getConfiguredParameters() {
            return Collections.emptyMap();
        }

        public String getClassName() {
            return IDFTransformation.class.getName();
        }
    }

    @ProtoSerializableClass(version=0, serializedDataClass=IDFTransformerProto.class)
    static class IDFTransformer
    implements Transformer {
        private static final long serialVersionUID = 1L;
        public static final int CURRENT_VERSION = 0;
        @ProtoSerializableField
        private final double df;
        @ProtoSerializableField
        private final double N;

        IDFTransformer(int df, int N) {
            if (df < 0 || N < 0) {
                throw new IllegalArgumentException("Both df and N must be positive");
            }
            this.df = df;
            this.N = N;
        }

        static IDFTransformer deserializeFromProto(int version, String className, Any message) throws InvalidProtocolBufferException {
            IDFTransformerProto proto = (IDFTransformerProto)message.unpack(IDFTransformerProto.class);
            if (version == 0) {
                return new IDFTransformer((int)proto.getDf(), (int)proto.getN());
            }
            throw new IllegalArgumentException("Unknown version " + version + " expected {0}");
        }

        @Override
        public double transform(double tf) {
            return Math.log(this.N / this.df) * (1.0 + Math.log(tf));
        }

        @Override
        public TransformerProto serialize() {
            return (TransformerProto)ProtoUtil.serialize(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IDFTransformer that = (IDFTransformer)o;
            return Double.compare(that.df, this.df) == 0 && Double.compare(that.N, this.N) == 0;
        }

        public int hashCode() {
            return Objects.hash(this.df, this.N);
        }
    }
}

