/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.util;

import com.oracle.labs.mlrg.olcut.util.Pair;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class HTMLOutput {
    private HTMLOutput() {
    }

    public static String toHTML(Pair<String, Double> p) {
        String cleanName = ((String)p.getA()).replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
        return String.format("<td style=\"text-align:left\">%s</td><td style=\"text-align:right\">%.3f</td>", cleanName, p.getB());
    }

    public static void printFeatureMap(Map<String, List<Pair<String, Double>>> m, List<String> keys, PrintStream s) {
        ArrayList<String> realKeys = new ArrayList<String>(keys);
        realKeys.add("ALL_OUTPUTS");
        if (m == null) {
            return;
        }
        s.println("<table>\n<tr>");
        for (String k : realKeys) {
            if (!m.containsKey(k)) continue;
            s.printf("<th colspan=\"2\">%s</th>", k);
        }
        s.print("</tr>\n<tr>");
        for (String k : realKeys) {
            if (!m.containsKey(k)) continue;
            s.print("<th>Feature</th><th>Weight</th>");
        }
        s.println("</tr>");
        HashMap<String, Integer> pos = new HashMap<String, Integer>();
        int done = 0;
        while (done < m.size()) {
            s.print("<tr>");
            for (String k : realKeys) {
                List<Pair<String, Double>> l = m.get(k);
                if (l == null) continue;
                Integer p = pos.getOrDefault(k, 0);
                if (p >= l.size()) {
                    s.print("<td></td><td></td>");
                    continue;
                }
                s.print(HTMLOutput.toHTML(l.get(p)));
                Integer n = p;
                p = p + 1;
                if (p >= l.size()) {
                    ++done;
                }
                pos.put(k, p);
            }
            s.println("</tr>");
        }
        s.println("</table>");
    }
}

