/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.util;

import java.io.Serializable;
import java.util.Objects;
import org.tribuo.util.Util;

public final class MeanVarianceAccumulator
implements Serializable {
    private static final long serialVersionUID = 1L;
    private double max = Double.NEGATIVE_INFINITY;
    private double min = Double.POSITIVE_INFINITY;
    private double mean = 0.0;
    private double sumSquares = 0.0;
    private long count = 0L;

    public MeanVarianceAccumulator() {
    }

    public MeanVarianceAccumulator(double[] values) {
        this.observe(values);
    }

    public MeanVarianceAccumulator(MeanVarianceAccumulator other) {
        this.max = other.max;
        this.min = other.min;
        this.mean = other.mean;
        this.sumSquares = other.sumSquares;
        this.count = other.count;
    }

    private MeanVarianceAccumulator(double max, double min, double mean, double sumSquares, long count) {
        this.max = max;
        this.min = min;
        this.mean = mean;
        this.sumSquares = sumSquares;
        this.count = count;
    }

    public void reset() {
        this.max = Double.NEGATIVE_INFINITY;
        this.min = Double.POSITIVE_INFINITY;
        this.mean = 0.0;
        this.sumSquares = 0.0;
        this.count = 0L;
    }

    public void observe(double value) {
        if (value < this.min) {
            this.min = value;
        }
        if (value > this.max) {
            this.max = value;
        }
        ++this.count;
        double delta = value - this.mean;
        this.mean += delta / (double)this.count;
        double delta2 = value - this.mean;
        this.sumSquares += delta * delta2;
    }

    public void observe(double[] values) {
        for (int i = 0; i < values.length; ++i) {
            this.observe(values[i]);
        }
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public double getMean() {
        return this.mean;
    }

    public double getVariance() {
        return this.sumSquares / (double)(this.count - 1L);
    }

    public long getCount() {
        return this.count;
    }

    public double getStdDev() {
        return Math.sqrt(this.getVariance());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MeanVarianceAccumulator that = (MeanVarianceAccumulator)o;
        return Double.compare(that.max, this.max) == 0 && Double.compare(that.min, this.min) == 0 && Double.compare(that.mean, this.mean) == 0 && Double.compare(that.sumSquares, this.sumSquares) == 0 && this.count == that.count;
    }

    public int hashCode() {
        return Objects.hash(this.max, this.min, this.mean, this.sumSquares, this.count);
    }

    public String toString() {
        return String.format("MeanVarianceAccumulator(count=%d,max=%f,min=%f,mean=%f,variance=%f)", this.count, this.max, this.min, this.mean, this.getVariance());
    }

    public double[] standardize(double[] input) {
        return Util.standardize(input, this.getMean(), this.getVariance());
    }

    public void standardizeInPlace(double[] input) {
        Util.standardizeInPlace(input, this.getMean(), this.getVariance());
    }

    public static MeanVarianceAccumulator merge(MeanVarianceAccumulator first, MeanVarianceAccumulator second) {
        double max = Math.max(first.max, second.max);
        double min = Math.min(first.min, second.min);
        long count = first.count + second.count;
        double mean = (first.mean * (double)first.count + second.mean * (double)second.count) / (double)count;
        double delta = second.mean - first.mean;
        double countFraction = (double)first.count / (double)count;
        double sumSquares = first.sumSquares + second.sumSquares + delta * delta * (countFraction * (double)second.count);
        return new MeanVarianceAccumulator(max, min, mean, sumSquares, count);
    }
}

