/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.util;

import com.oracle.labs.mlrg.olcut.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.SplittableRandom;
import java.util.function.ToIntFunction;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Util {
    private static final Logger logger = Logger.getLogger(Util.class.getName());

    private Util() {
    }

    public static <T extends Comparable<T>> Pair<Integer, T> argmax(List<T> values) {
        if (values.isEmpty()) {
            throw new IllegalArgumentException("argmax on an empty list");
        }
        Comparable vmax = (Comparable)values.get(0);
        int imax = 0;
        for (int i = 1; i < values.size(); ++i) {
            Comparable v = (Comparable)values.get(i);
            if (v.compareTo(vmax) <= 0) continue;
            vmax = v;
            imax = i;
        }
        return new Pair((Object)imax, (Object)vmax);
    }

    public static <T extends Comparable<T>> Pair<Integer, T> argmin(List<T> values) {
        if (values.isEmpty()) {
            throw new IllegalArgumentException("argmin on an empty list");
        }
        Comparable vmin = (Comparable)values.get(0);
        int imin = 0;
        for (int i = 1; i < values.size(); ++i) {
            Comparable v = (Comparable)values.get(i);
            if (v.compareTo(vmin) >= 0) continue;
            vmin = v;
            imin = i;
        }
        return new Pair((Object)imin, (Object)vmin);
    }

    public static float[] toFloatArray(double[] doubles) {
        float[] floats = new float[doubles.length];
        for (int i = 0; i < doubles.length; ++i) {
            floats[i] = (float)doubles[i];
        }
        return floats;
    }

    public static double[] toDoubleArray(float[] floats) {
        double[] doubles = new double[floats.length];
        for (int i = 0; i < floats.length; ++i) {
            doubles[i] = floats[i];
        }
        return doubles;
    }

    public static int[] randperm(int size, Random rng) {
        int i;
        int[] array = new int[size];
        for (i = 0; i < array.length; ++i) {
            array[i] = i;
        }
        for (i = size; i > 1; --i) {
            int j = rng.nextInt(i);
            int tmp = array[i - 1];
            array[i - 1] = array[j];
            array[j] = tmp;
        }
        return array;
    }

    public static int[] randperm(int size, SplittableRandom rng) {
        int i;
        int[] array = new int[size];
        for (i = 0; i < array.length; ++i) {
            array[i] = i;
        }
        for (i = size; i > 1; --i) {
            int j = rng.nextInt(i);
            int tmp = array[i - 1];
            array[i - 1] = array[j];
            array[j] = tmp;
        }
        return array;
    }

    public static void randpermInPlace(int[] input, Random rng) {
        for (int i = input.length; i > 1; --i) {
            int j = rng.nextInt(i);
            int tmp = input[i - 1];
            input[i - 1] = input[j];
            input[j] = tmp;
        }
    }

    public static void randpermInPlace(int[] input, SplittableRandom rng) {
        for (int i = input.length; i > 1; --i) {
            int j = rng.nextInt(i);
            int tmp = input[i - 1];
            input[i - 1] = input[j];
            input[j] = tmp;
        }
    }

    public static void randpermInPlace(double[] input, SplittableRandom rng) {
        for (int i = input.length; i > 1; --i) {
            int j = rng.nextInt(i);
            double tmp = input[i - 1];
            input[i - 1] = input[j];
            input[j] = tmp;
        }
    }

    public static <T> void shuffle(ArrayList<T> list, SplittableRandom rng) {
        for (int i = list.size(); i > 1; --i) {
            int j = rng.nextInt(i);
            T tmp = list.get(i - 1);
            list.set(i - 1, list.get(j));
            list.set(j, tmp);
        }
    }

    public static int[] generateBootstrapIndices(int size, Random rng) {
        int[] array = new int[size];
        for (int i = 0; i < size; ++i) {
            array[i] = rng.nextInt(size);
        }
        return array;
    }

    public static int[] generateBootstrapIndices(int size, SplittableRandom rng) {
        int[] array = new int[size];
        for (int i = 0; i < size; ++i) {
            array[i] = rng.nextInt(size);
        }
        return array;
    }

    public static int[] generateBootstrapIndices(int size, int range, SplittableRandom rng) {
        if (size < 1) {
            throw new IllegalArgumentException("Invalid size, must be positive");
        }
        if (range < 1) {
            throw new IllegalArgumentException("Invalid range, must be positive");
        }
        int[] array = new int[size];
        for (int i = 0; i < size; ++i) {
            array[i] = rng.nextInt(range);
        }
        return array;
    }

    public static int[] generateWeightedIndicesSample(int size, double[] weights, Random rng) {
        double[] cdf = Util.generateCDF(weights);
        if (Math.abs(cdf[cdf.length - 1] - 1.0) > 1.0E-10) {
            throw new IllegalStateException("Weights do not sum to 1, cdf[cdf.length-1] = " + cdf[cdf.length - 1]);
        }
        return Util.generateWeightedIndicesSample(cdf, size, rng);
    }

    public static int[] generateWeightedIndicesSample(int size, float[] weights, Random rng) {
        double[] cdf = Util.generateCDF(weights);
        if (Math.abs(cdf[cdf.length - 1] - 1.0) > 1.0E-6) {
            throw new IllegalStateException("Weights do not sum to 1, cdf[cdf.length-1] = " + cdf[cdf.length - 1]);
        }
        return Util.generateWeightedIndicesSample(cdf, size, rng);
    }

    private static int[] generateWeightedIndicesSample(double[] cdf, int size, Random rng) {
        int[] output = new int[size];
        for (int i = 0; i < output.length; ++i) {
            double uniform = rng.nextDouble();
            int searchVal = Arrays.binarySearch(cdf, uniform);
            output[i] = searchVal < 0 ? -1 - searchVal : searchVal;
        }
        return output;
    }

    public static int[] generateWeightedIndicesSample(int size, double[] weights, SplittableRandom rng) {
        double[] cdf = Util.generateCDF(weights);
        if (Math.abs(cdf[cdf.length - 1] - 1.0) > 1.0E-10) {
            throw new IllegalStateException("Weights do not sum to 1, cdf[cdf.length-1] = " + cdf[cdf.length - 1]);
        }
        return Util.generateWeightedIndicesSample(cdf, size, rng);
    }

    public static int[] generateWeightedIndicesSample(int size, float[] weights, SplittableRandom rng) {
        double[] cdf = Util.generateCDF(weights);
        if (Math.abs(cdf[cdf.length - 1] - 1.0) > 1.0E-6) {
            throw new IllegalStateException("Weights do not sum to 1, cdf[cdf.length-1] = " + cdf[cdf.length - 1]);
        }
        return Util.generateWeightedIndicesSample(cdf, size, rng);
    }

    private static int[] generateWeightedIndicesSample(double[] cdf, int size, SplittableRandom rng) {
        int[] output = new int[size];
        for (int i = 0; i < output.length; ++i) {
            double uniform = rng.nextDouble();
            int searchVal = Arrays.binarySearch(cdf, uniform);
            output[i] = searchVal < 0 ? -1 - searchVal : searchVal;
        }
        return output;
    }

    public static int[] generateWeightedIndicesSampleWithoutReplacement(int size, double[] weights, Random rng) {
        double[] cdf = Util.generateCDF(weights);
        if (Math.abs(cdf[cdf.length - 1] - 1.0) > 1.0E-6) {
            throw new IllegalStateException("Weights do not sum to 1, cdf[cdf.length-1] = " + cdf[cdf.length - 1]);
        }
        int[] output = new int[size];
        HashSet<Integer> seenIdxs = new HashSet<Integer>();
        int i = 0;
        while (i < output.length) {
            double uniform = rng.nextDouble();
            int searchVal = Arrays.binarySearch(cdf, uniform);
            int candidateSample = searchVal < 0 ? -1 - searchVal : searchVal;
            if (seenIdxs.contains(candidateSample)) continue;
            seenIdxs.add(candidateSample);
            output[i] = candidateSample;
            ++i;
        }
        return output;
    }

    public static int[] generateWeightedIndicesSampleWithoutReplacement(int size, float[] weights, Random rng) {
        double[] cdf = Util.generateCDF(weights);
        if (Math.abs(cdf[cdf.length - 1] - 1.0) > 1.0E-6) {
            throw new IllegalStateException("Weights do not sum to 1, cdf[cdf.length-1] = " + cdf[cdf.length - 1]);
        }
        int[] output = new int[size];
        HashSet<Integer> seenIdxs = new HashSet<Integer>();
        int i = 0;
        while (i < output.length) {
            double uniform = rng.nextDouble();
            int searchVal = Arrays.binarySearch(cdf, uniform);
            int candidateSample = searchVal < 0 ? -1 - searchVal : searchVal;
            if (seenIdxs.contains(candidateSample)) continue;
            seenIdxs.add(candidateSample);
            output[i] = candidateSample;
            ++i;
        }
        return output;
    }

    public static double[] generateCDF(double[] pmf) {
        return Util.cumulativeSum(pmf);
    }

    public static double[] cumulativeSum(double[] input) {
        double[] cdf = new double[input.length];
        double sum = 0.0;
        for (int i = 0; i < input.length; ++i) {
            cdf[i] = sum += input[i];
        }
        return cdf;
    }

    public static int[] cumulativeSum(boolean[] input) {
        int[] cumulativeSum = new int[input.length];
        int sum = 0;
        for (int i = 0; i < input.length; ++i) {
            cumulativeSum[i] = sum += input[i] ? 1 : 0;
        }
        return cumulativeSum;
    }

    public static double[] generateCDF(float[] pmf) {
        double[] cdf = new double[pmf.length];
        double sum = 0.0;
        for (int i = 0; i < pmf.length; ++i) {
            cdf[i] = sum += (double)pmf[i];
        }
        return cdf;
    }

    public static double[] generateCDF(long[] counts, long countSum) {
        double[] cdf = new double[counts.length];
        double countSumD = countSum;
        double probSum = 0.0;
        for (int i = 0; i < counts.length; ++i) {
            cdf[i] = probSum += (double)counts[i] / countSumD;
        }
        return cdf;
    }

    public static int sampleFromCDF(double[] cdf, Random rng) {
        if (Math.abs(cdf[cdf.length - 1] - 1.0) > 1.0E-6) {
            throw new IllegalStateException("Weights do not sum to 1, cdf[cdf.length-1] = " + cdf[cdf.length - 1]);
        }
        double uniform = rng.nextDouble();
        int searchVal = Arrays.binarySearch(cdf, uniform);
        if (searchVal < 0) {
            return -1 - searchVal;
        }
        return searchVal;
    }

    public static int sampleFromCDF(double[] cdf, SplittableRandom rng) {
        if (Math.abs(cdf[cdf.length - 1] - 1.0) > 1.0E-6) {
            throw new IllegalStateException("Weights do not sum to 1, cdf[cdf.length-1] = " + cdf[cdf.length - 1]);
        }
        double uniform = rng.nextDouble();
        int searchVal = Arrays.binarySearch(cdf, uniform);
        if (searchVal < 0) {
            return -1 - searchVal;
        }
        return searchVal;
    }

    public static double[] generateUniformVector(int length, double value) {
        double[] output = new double[length];
        Arrays.fill(output, value);
        return output;
    }

    public static float[] generateUniformVector(int length, float value) {
        float[] output = new float[length];
        Arrays.fill(output, value);
        return output;
    }

    public static double[] normalizeToDistribution(double[] input) {
        int i;
        double[] output = new double[input.length];
        double sum = 0.0;
        for (i = 0; i < input.length; ++i) {
            output[i] = input[i];
            sum += output[i];
        }
        i = 0;
        while (i < input.length) {
            int n = i++;
            output[n] = output[n] / sum;
        }
        return output;
    }

    public static double[] normalizeToDistribution(float[] input) {
        int i;
        double[] output = new double[input.length];
        double sum = 0.0;
        for (i = 0; i < input.length; ++i) {
            output[i] = input[i];
            sum += output[i];
        }
        i = 0;
        while (i < input.length) {
            int n = i++;
            output[n] = output[n] / sum;
        }
        return output;
    }

    public static double[] inplaceNormalizeToDistribution(double[] input) {
        int i;
        double sum = 0.0;
        for (i = 0; i < input.length; ++i) {
            sum += input[i];
        }
        i = 0;
        while (i < input.length) {
            int n = i++;
            input[n] = input[n] / sum;
        }
        return input;
    }

    public static void inplaceNormalizeToDistribution(float[] input) {
        int i;
        float sum = 0.0f;
        for (i = 0; i < input.length; ++i) {
            sum += input[i];
        }
        i = 0;
        while (i < input.length) {
            int n = i++;
            input[n] = input[n] / sum;
        }
    }

    public static void logVector(Logger otherLogger, Level level, double[] input) {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < input.length; ++i) {
            buffer.append("(");
            buffer.append(i);
            buffer.append(",");
            buffer.append(input[i]);
            buffer.append(") ");
        }
        buffer.deleteCharAt(buffer.length() - 1);
        otherLogger.log(level, buffer.toString());
    }

    public static void logVector(Logger otherLogger, Level level, float[] input) {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < input.length; ++i) {
            buffer.append("(");
            buffer.append(i);
            buffer.append(",");
            buffer.append(input[i]);
            buffer.append(") ");
        }
        buffer.deleteCharAt(buffer.length() - 1);
        otherLogger.log(level, buffer.toString());
    }

    public static List<Float> toBoxedFloats(float[] input) {
        ArrayList<Float> output = new ArrayList<Float>(input.length);
        for (int i = 0; i < input.length; ++i) {
            output.add(Float.valueOf(input[i]));
        }
        return output;
    }

    public static double[] toPrimitiveDoubleFromInteger(List<Integer> input) {
        double[] output = new double[input.size()];
        for (int i = 0; i < input.size(); ++i) {
            output[i] = input.get(i).intValue();
        }
        return output;
    }

    public static double[] toPrimitiveDouble(List<Double> input) {
        double[] output = new double[input.size()];
        for (int i = 0; i < input.size(); ++i) {
            output[i] = input.get(i);
        }
        return output;
    }

    public static float[] toPrimitiveFloat(List<Float> input) {
        float[] output = new float[input.size()];
        for (int i = 0; i < input.size(); ++i) {
            output[i] = input.get(i).floatValue();
        }
        return output;
    }

    public static int[] toPrimitiveInt(List<Integer> input) {
        int[] output = new int[input.size()];
        for (int i = 0; i < input.size(); ++i) {
            output[i] = input.get(i);
        }
        return output;
    }

    public static long[] toPrimitiveLong(List<Long> input) {
        long[] output = new long[input.size()];
        for (int i = 0; i < input.size(); ++i) {
            output[i] = input.get(i);
        }
        return output;
    }

    public static int[] sampleInts(Random rng, int size, int range) {
        int[] output = new int[size];
        for (int i = 0; i < output.length; ++i) {
            output[i] = rng.nextInt(range);
        }
        return output;
    }

    public static void inPlaceAdd(double[] input, double[] update) {
        for (int i = 0; i < input.length; ++i) {
            int n = i;
            input[n] = input[n] + update[i];
        }
    }

    public static void inPlaceSubtract(double[] input, double[] update) {
        for (int i = 0; i < input.length; ++i) {
            int n = i;
            input[n] = input[n] - update[i];
        }
    }

    public static void inPlaceAdd(float[] input, float[] update) {
        for (int i = 0; i < input.length; ++i) {
            int n = i;
            input[n] = input[n] + update[i];
        }
    }

    public static void inPlaceSubtract(float[] input, float[] update) {
        for (int i = 0; i < input.length; ++i) {
            int n = i;
            input[n] = input[n] - update[i];
        }
    }

    public static double vectorNorm(double[] input) {
        double norm = 0.0;
        for (double d : input) {
            norm += d * d;
        }
        return Math.sqrt(norm);
    }

    public static double sum(double[] input) {
        double sum = 0.0;
        for (double d : input) {
            sum += d;
        }
        return sum;
    }

    public static float sum(float[] input) {
        float sum = 0.0f;
        for (float d : input) {
            sum += d;
        }
        return sum;
    }

    public static double sum(double[] array, int length) {
        double sum = 0.0;
        for (int i = 0; i < length; ++i) {
            sum += array[i];
        }
        return sum;
    }

    public static float sum(float[] array, int length) {
        float sum = 0.0f;
        for (int i = 0; i < length; ++i) {
            sum += array[i];
        }
        return sum;
    }

    public static float sum(int[] indices, int indicesLength, float[] input) {
        float sum = 0.0f;
        for (int i = 0; i < indicesLength; ++i) {
            sum += input[indices[i]];
        }
        return sum;
    }

    public static float sum(int[] indices, float[] input) {
        return Util.sum(indices, indices.length, input);
    }

    public static float[] generateUniformFloatVector(int length, float value) {
        float[] output = new float[length];
        Arrays.fill(output, value);
        return output;
    }

    public static <T> int binarySearch(List<? extends Comparable<? super T>> list, T key) {
        return Util.binarySearch(list, key, 0, list.size() - 1);
    }

    public static <T> int binarySearch(List<? extends Comparable<? super T>> list, T key, int low, int high) {
        while (low <= high) {
            int mid = low + high >>> 1;
            Comparable<T> midVal = list.get(mid);
            int cmp = midVal.compareTo(key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static <T> int binarySearch(List<? extends T> list, int key, ToIntFunction<T> extractionFunc) {
        int low = 0;
        int high = list.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int midVal = extractionFunc.applyAsInt(list.get(mid));
            int cmp = Integer.compare(midVal, key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static double auc(double[] x, double[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("x and y must be the same length, x.length = " + x.length + ", y.length = " + y.length);
        }
        double output = 0.0;
        for (int i = 1; i < x.length; ++i) {
            double ySum = y[i] + y[i - 1];
            double xDiff = x[i] - x[i - 1];
            if (xDiff < -1.0E-12) {
                throw new IllegalStateException(String.format("X is not increasing, x[%d]=%f, x[%d]=%f", i, x[i], i - 1, x[i - 1]));
            }
            output += ySum * xDiff / 2.0;
        }
        return output;
    }

    public static Pair<Double, Double> meanAndVariance(double[] inputs) {
        return Util.meanAndVariance(inputs, inputs.length);
    }

    public static Pair<Double, Double> meanAndVariance(double[] inputs, int length) {
        double mean = 0.0;
        double sumSquares = 0.0;
        for (int i = 0; i < length; ++i) {
            double value = inputs[i];
            double delta = value - mean;
            double delta2 = value - (mean += delta / (double)(i + 1));
            sumSquares += delta * delta2;
        }
        return new Pair((Object)mean, (Object)(sumSquares / (double)(length - 1)));
    }

    public static double weightedMean(double[] inputs, double[] weights) {
        if (inputs.length != weights.length) {
            throw new IllegalArgumentException("inputs and weights must be the same length, inputs.length = " + inputs.length + ", weights.length = " + weights.length);
        }
        double output = 0.0;
        double sum = 0.0;
        for (int i = 0; i < inputs.length; ++i) {
            output += inputs[i] * weights[i];
            sum += weights[i];
        }
        return output / sum;
    }

    public static double mean(double[] inputs) {
        double output = 0.0;
        for (int i = 0; i < inputs.length; ++i) {
            output += inputs[i];
        }
        return output / (double)inputs.length;
    }

    public static double mean(double[] array, int length) {
        double sum = Util.sum(array, length);
        return sum / (double)length;
    }

    public static <V extends Number> double mean(Collection<V> values) {
        double total = 0.0;
        for (Number v : values) {
            total += v.doubleValue();
        }
        return total / (double)values.size();
    }

    public static <V extends Number> double sampleVariance(Collection<V> values) {
        double mean = Util.mean(values);
        double total = 0.0;
        for (Number v : values) {
            total += Math.pow(v.doubleValue() - mean, 2.0);
        }
        return total / (double)(values.size() - 1);
    }

    public static <V extends Number> double sampleStandardDeviation(Collection<V> values) {
        return Math.sqrt(Util.sampleVariance(values));
    }

    public static double weightedMean(double[] array, float[] weights, int length) {
        double sum = Util.weightedSum(array, weights, length);
        return sum / (double)Util.sum(weights, length);
    }

    public static double weightedSum(double[] array, float[] weights, int length) {
        if (array.length != weights.length) {
            throw new IllegalArgumentException("array and weights must be the same length, array.length = " + array.length + ", weights.length = " + weights.length);
        }
        double sum = 0.0;
        for (int i = 0; i < length; ++i) {
            sum += (double)weights[i] * array[i];
        }
        return sum;
    }

    public static int[] differencesIndices(double[] input) {
        return Util.differencesIndices(input, 1.0E-12);
    }

    public static int[] differencesIndices(double[] input, double tolerance) {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        for (int i = 0; i < input.length - 1; ++i) {
            double diff = Math.abs(input[i + 1] - input[i]);
            if (!(diff > tolerance)) continue;
            indices.add(i);
        }
        indices.add(input.length - 1);
        return Util.toPrimitiveInt(indices);
    }

    public static String formatDuration(long startMillis, long stopMillis) {
        long millis = stopMillis - startMillis;
        long second = millis / 1000L % 60L;
        long minute = millis / 60000L % 60L;
        long hour = millis / 3600000L % 24L;
        long days = millis / 3600000L / 24L;
        if (days == 0L) {
            return String.format("(%02d:%02d:%02d:%03d)", hour, minute, second, millis % 1000L);
        }
        return String.format("(%d days, %02d:%02d:%02d:%03d)", days, hour, minute, second, millis % 1000L);
    }

    public static int[] sortedDifference(int[] first, int[] second) {
        ArrayList<Integer> diffIndicesList = new ArrayList<Integer>();
        int i = 0;
        int j = 0;
        while (i < first.length && j < second.length) {
            while (i < first.length && first[i] < second[j]) {
                diffIndicesList.add(first[i]);
                ++i;
            }
            while (j < second.length && first[i] > second[j]) {
                ++j;
            }
            if (first[i] == second[j]) continue;
            diffIndicesList.add(first[i]);
        }
        while (i < first.length) {
            diffIndicesList.add(first[i]);
            ++i;
        }
        return diffIndicesList.stream().mapToInt(Integer::intValue).toArray();
    }

    public static double[] standardize(double[] input, double mean, double variance) {
        if (variance <= 0.0) {
            throw new IllegalArgumentException("Variance must be positive, found " + variance);
        }
        double[] output = new double[input.length];
        for (int i = 0; i < input.length; ++i) {
            output[i] = (input[i] - mean) / variance;
        }
        return output;
    }

    public static void standardizeInPlace(double[] input, double mean, double variance) {
        if (variance <= 0.0) {
            throw new IllegalArgumentException("Variance must be positive, found " + variance);
        }
        for (int i = 0; i < input.length; ++i) {
            input[i] = (input[i] - mean) / variance;
        }
    }

    public static int product(int[] array) {
        int output = 1;
        for (int i = 0; i < array.length; ++i) {
            output *= array[i];
        }
        return output;
    }
}

