/*
 * Decompiled with CFR 0.152.
 */
package com.maxmind.geoip2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.maxmind.db.MaxMindDbParameter;
import com.maxmind.geoip2.JsonSerializable;
import com.maxmind.geoip2.record.Continent;
import com.maxmind.geoip2.record.Country;
import com.maxmind.geoip2.record.MaxMind;
import com.maxmind.geoip2.record.RepresentedCountry;
import com.maxmind.geoip2.record.Traits;
import java.util.List;

public record CountryResponse(@JsonProperty(value="continent") @MaxMindDbParameter(name="continent") Continent continent, @JsonProperty(value="country") @MaxMindDbParameter(name="country") Country country, @JsonProperty(value="maxmind") @MaxMindDbParameter(name="maxmind") MaxMind maxmind, @JsonProperty(value="registered_country") @MaxMindDbParameter(name="registered_country") Country registeredCountry, @JsonProperty(value="represented_country") @MaxMindDbParameter(name="represented_country") RepresentedCountry representedCountry, @JsonProperty(value="traits") @MaxMindDbParameter(name="traits") Traits traits) implements JsonSerializable
{
    public CountryResponse {
        continent = continent != null ? continent : new Continent();
        country = country != null ? country : new Country();
        maxmind = maxmind != null ? maxmind : new MaxMind();
        registeredCountry = registeredCountry != null ? registeredCountry : new Country();
        representedCountry = representedCountry != null ? representedCountry : new RepresentedCountry();
        traits = traits != null ? traits : new Traits();
    }

    public CountryResponse(CountryResponse response, List<String> locales) {
        this(new Continent(response.continent(), locales), new Country(response.country(), locales), response.maxmind(), new Country(response.registeredCountry(), locales), new RepresentedCountry(response.representedCountry(), locales), response.traits());
    }

    @Deprecated(since="5.0.0", forRemoval=true)
    @JsonProperty(value="maxmind")
    public MaxMind getMaxMind() {
        return this.maxmind();
    }

    @Deprecated(since="5.0.0", forRemoval=true)
    @JsonProperty(value="registered_country")
    public Country getRegisteredCountry() {
        return this.registeredCountry();
    }

    @Deprecated(since="5.0.0", forRemoval=true)
    public Continent getContinent() {
        return this.continent();
    }

    @Deprecated(since="5.0.0", forRemoval=true)
    public Country getCountry() {
        return this.country();
    }

    @Deprecated(since="5.0.0", forRemoval=true)
    @JsonProperty(value="represented_country")
    public RepresentedCountry getRepresentedCountry() {
        return this.representedCountry();
    }

    @Deprecated(since="5.0.0", forRemoval=true)
    public Traits getTraits() {
        return this.traits();
    }
}

