/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.upgrade;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.lucenia.upgrade.TaskInput;
import io.lucenia.upgrade.UpgradeTask;
import io.skylite.Version;
import io.skylite.cli.Terminal;
import io.skylite.common.SuppressForbidden;
import io.skylite.common.collect.Tuple;
import io.skylite.core.settings.Settings;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Scanner;

class DetectEsInstallationTask
implements UpgradeTask {
    private static final int ES_DEFAULT_PORT = 9200;
    private static final String ES_CONFIG_ENV = "ES_PATH_CONF";
    private static final String ES_CONFIG_YML = "elasticsearch.yml";
    private static final String ES_HOME = "ES_HOME";

    DetectEsInstallationTask() {
    }

    @Override
    @SuppressForbidden(reason="We need to read external es config files")
    public void accept(Tuple<TaskInput, Terminal> input) {
        block9: {
            TaskInput taskInput = (TaskInput)input.v1();
            Terminal terminal = (Terminal)input.v2();
            try {
                terminal.println("Looking for an elasticsearch installation ...");
                String esHomeEnv = System.getenv(ES_HOME);
                if (esHomeEnv == null && ((esHomeEnv = terminal.readText("Missing ES_HOME env variable, enter the path to elasticsearch home: ")) == null || esHomeEnv.isEmpty())) {
                    throw new RuntimeException("Invalid input for path to elasticsearch home directory.");
                }
                taskInput.setEsHome(new File(esHomeEnv).toPath());
                String esConfEnv = System.getenv(ES_CONFIG_ENV);
                if (esConfEnv == null && ((esConfEnv = terminal.readText("Missing ES_PATH_CONF env variable, enter the path to elasticsearch config directory: ")) == null || esHomeEnv.isEmpty())) {
                    throw new RuntimeException("Invalid input for path to elasticsearch config directory.");
                }
                taskInput.setEsConfig(new File(esConfEnv).toPath());
                Settings esSettings = Settings.builder().loadFromPath(taskInput.getEsConfig().resolve(ES_CONFIG_YML)).build();
                String url = this.retrieveUrl(esSettings);
                taskInput.setBaseUrl(url);
                boolean running = this.isRunning(url);
                taskInput.setRunning(running);
                if (running) {
                    terminal.println("Found a running instance of elasticsearch at " + url);
                    taskInput.setRunning(true);
                    try {
                        this.updateTaskInput(taskInput, this.fetchInfoFromUrl(taskInput.getBaseUrl()));
                    }
                    catch (RuntimeException e) {
                        this.updateTaskInput(taskInput, this.fetchInfoFromEsSettings(esSettings));
                    }
                    try {
                        taskInput.setPlugins(this.fetchPluginsFromUrl(taskInput.getBaseUrl()));
                    }
                    catch (RuntimeException e) {
                        taskInput.setPlugins(this.detectPluginsFromEsHome(taskInput.getEsHome()));
                    }
                    break block9;
                }
                terminal.println("Did not find a running instance of elasticsearch at " + url);
                this.updateTaskInput(taskInput, this.fetchInfoFromEsSettings(esSettings));
                taskInput.setPlugins(this.detectPluginsFromEsHome(taskInput.getEsHome()));
            }
            catch (IOException e) {
                throw new RuntimeException("Error detecting existing elasticsearch installation. " + String.valueOf(e));
            }
        }
    }

    private void updateTaskInput(TaskInput taskInput, Map<?, ?> response) {
        String vStr;
        Map versionMap = (Map)response.get("version");
        if (versionMap != null && (vStr = (String)versionMap.get("number")) != null) {
            taskInput.setVersion(Version.fromString((String)vStr));
        }
        taskInput.setNode((String)response.get("name"));
        taskInput.setCluster((String)response.get("cluster_name"));
    }

    String retrieveUrl(Settings esSettings) {
        int port = Optional.ofNullable(esSettings.get("http.port")).map(this::extractPort).orElse(9200);
        return "http://localhost:" + port;
    }

    private Integer extractPort(String port) {
        try {
            return Integer.parseInt(port.trim());
        }
        catch (Exception ex) {
            return 9200;
        }
    }

    @SuppressForbidden(reason="Need to connect to http endpoint for elasticsearch.")
    private boolean isRunning(String url) {
        try {
            URL esUrl = new URL(url);
            HttpURLConnection conn = (HttpURLConnection)esUrl.openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(1000);
            conn.connect();
            return conn.getResponseCode() == 200;
        }
        catch (IOException e) {
            return false;
        }
    }

    @SuppressForbidden(reason="Retrieve information on the installation.")
    private Map<?, ?> fetchInfoFromUrl(String url) {
        try {
            URL esUrl = new URL(url);
            HttpURLConnection conn = (HttpURLConnection)esUrl.openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(1000);
            conn.connect();
            StringBuilder json = new StringBuilder();
            Scanner scanner = new Scanner(esUrl.openStream());
            while (scanner.hasNext()) {
                json.append(scanner.nextLine());
            }
            scanner.close();
            ObjectMapper mapper = new ObjectMapper();
            return (Map)mapper.readValue(json.toString(), Map.class);
        }
        catch (IOException e) {
            throw new RuntimeException("Error retrieving elasticsearch cluster info, " + String.valueOf(e));
        }
    }

    private Map<?, ?> fetchInfoFromEsSettings(Settings esSettings) throws IOException {
        HashMap<String, String> info = new HashMap<String, String>();
        String node = esSettings.get("node.name") != null ? esSettings.get("node.name") : "unknown";
        String cluster = esSettings.get("cluster.name") != null ? esSettings.get("cluster.name") : "unknown";
        info.put("name", node);
        info.put("cluster_name", cluster);
        return info;
    }

    @SuppressForbidden(reason="Retrieve information on installed plugins.")
    private List<String> fetchPluginsFromUrl(String url) {
        ArrayList<String> plugins = new ArrayList<String>();
        try {
            URL esUrl = new URL(url + "/_cat/plugins?format=json&local=true");
            HttpURLConnection conn = (HttpURLConnection)esUrl.openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(1000);
            conn.connect();
            if (conn.getResponseCode() == 200) {
                Map[] response;
                StringBuilder json = new StringBuilder();
                Scanner scanner = new Scanner(esUrl.openStream());
                while (scanner.hasNext()) {
                    json.append(scanner.nextLine());
                }
                scanner.close();
                ObjectMapper mapper = new ObjectMapper();
                for (Map plugin : response = (Map[])mapper.readValue(json.toString(), Map[].class)) {
                    plugins.add((String)plugin.get("component"));
                }
            }
            return plugins;
        }
        catch (IOException e) {
            throw new RuntimeException("Error retrieving elasticsearch plugin details, " + String.valueOf(e));
        }
    }

    private List<String> detectPluginsFromEsHome(Path esHome) {
        return Collections.emptyList();
    }
}

