/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.upgrade;

import io.lucenia.common.settings.KeystoreWrapperUtil;
import io.lucenia.upgrade.TaskInput;
import io.lucenia.upgrade.UpgradeTask;
import io.skylite.cli.Terminal;
import io.skylite.common.SecureString;
import io.skylite.common.collect.Tuple;
import io.skylite.core.settings.KeyStoreWrapper;
import java.io.InputStream;
import java.nio.file.Path;

class ImportKeystoreTask
implements UpgradeTask {
    private static final String LUCENIA_KEYSTORE_FILENAME = "lucenia.keystore";
    private static final String ES_KEYSTORE_FILENAME = "elasticsearch.keystore";

    ImportKeystoreTask() {
    }

    @Override
    public void accept(Tuple<TaskInput, Terminal> input) {
        TaskInput taskInput = (TaskInput)input.v1();
        Terminal terminal = (Terminal)input.v2();
        try (SecureString keyStorePassword = new SecureString(new char[0]);){
            terminal.println("Importing keystore settings ...");
            KeyStoreWrapper esKeystore = KeyStoreWrapper.load((Path)taskInput.getEsConfig(), (String)ES_KEYSTORE_FILENAME);
            if (esKeystore == null) {
                terminal.println("No elasticsearch keystore settings to import.");
                return;
            }
            KeyStoreWrapper luceniaKeystore = KeyStoreWrapper.load((Path)taskInput.getLuceniaConfig().resolve(LUCENIA_KEYSTORE_FILENAME));
            if (luceniaKeystore == null) {
                luceniaKeystore = KeyStoreWrapper.create();
            }
            if (esKeystore.hasPassword()) {
                char[] passwordArray = terminal.readSecret("Enter password for the elasticsearch keystore : ");
                keyStorePassword = new SecureString(passwordArray);
            }
            esKeystore.decrypt(keyStorePassword.getChars());
            for (String setting : esKeystore.getSettingNames()) {
                if (setting.equals("keystore.seed") || luceniaKeystore.getSettingNames().contains(setting)) continue;
                InputStream settingIS = esKeystore.getFile(setting);
                byte[] bytes = new byte[settingIS.available()];
                settingIS.read(bytes);
                KeystoreWrapperUtil.saveSetting(luceniaKeystore, setting, bytes);
            }
            luceniaKeystore.save(taskInput.getLuceniaConfig(), keyStorePassword.getChars());
            terminal.println("Success!" + System.lineSeparator());
        }
    }
}

