/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.upgrade;

import io.lucenia.upgrade.TaskInput;
import io.lucenia.upgrade.UpgradeTask;
import io.skylite.cli.Terminal;
import io.skylite.common.collect.Tuple;
import io.skylite.common.xcontent.yaml.YamlXContent;
import io.skylite.core.settings.Settings;
import io.skylite.core.settings.SettingsException;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContent;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.HashMap;

class ImportYmlConfigTask
implements UpgradeTask {
    private static final String ES_CONFIG_FILENAME = "elasticsearch.yml";
    private static final String LUCENIA_CONFIG_FILENAME = "lucenia.yml";
    static final String HEADER = "# ======================== Lucenia Configuration =========================\n# NOTE: The settings in this file are imported from an existing Elasticsearch\n#       installation using the lucenia-upgrade tool. The original file is\n#       backed up in this directory as lucenia.yml.bkp for reference.\n\n# Please consult the documentation for further information:\n# https://www.lucenia.io\n#\n";

    ImportYmlConfigTask() {
    }

    @Override
    public void accept(Tuple<TaskInput, Terminal> input) {
        TaskInput taskInput = (TaskInput)input.v1();
        Terminal terminal = (Terminal)input.v2();
        try {
            terminal.println("Importing settings from elasticsearch.yml ...");
            Path openSearchYmlPath = taskInput.getLuceniaConfig().resolve(LUCENIA_CONFIG_FILENAME);
            Path esYamlPath = taskInput.getEsConfig().resolve(ES_CONFIG_FILENAME);
            Settings esSettings = Settings.builder().loadFromPath(esYamlPath).build();
            Settings settings = Settings.builder().loadFromPath(openSearchYmlPath).build();
            if (esSettings.size() > 0) {
                Path backupYmlPath;
                if (settings.size() > 0 && !terminal.promptYesNo("Existing settings in lucenia.yml will be overwritten, proceed?", false)) {
                    terminal.println("Import settings cancelled by user");
                }
                if (!Files.exists(backupYmlPath = taskInput.getLuceniaConfig().resolve("lucenia.yml.bkp"), new LinkOption[0]) || terminal.promptYesNo("A backup file for lucenia.yml already exists, overwrite?", false)) {
                    Files.copy(openSearchYmlPath, backupYmlPath, StandardCopyOption.REPLACE_EXISTING);
                }
                Files.write(openSearchYmlPath, Collections.singleton(HEADER), StandardOpenOption.TRUNCATE_EXISTING);
                Settings mergeSettings = this.mergeSettings(settings, esSettings);
                this.writeSettings(openSearchYmlPath, mergeSettings);
            }
            terminal.println("Success!" + System.lineSeparator());
        }
        catch (IOException ex) {
            throw new RuntimeException("Error importing settings from elasticsearch.yml, " + String.valueOf(ex));
        }
    }

    Settings mergeSettings(Settings first, Settings second) {
        Settings.Builder builder = Settings.builder();
        for (String key : first.keySet()) {
            builder.copy(key, key, first);
        }
        for (String key : second.keySet()) {
            builder.copy(key, key, second);
        }
        return builder.build();
    }

    private void writeSettings(Path configYml, Settings settings) throws IOException {
        try (OutputStream os = Files.newOutputStream(configYml, StandardOpenOption.APPEND);
             XContentBuilder builder = new XContentBuilder((XContent)YamlXContent.yamlXContent, os);){
            builder.startObject();
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("flat_settings", "true");
            settings.toXContent(builder, (ToXContent.Params)new ToXContent.MapParams(params));
            builder.endObject();
            builder.flush();
        }
        catch (Exception e) {
            throw new SettingsException("Failed to write settings to " + configYml.toString(), (Throwable)e);
        }
    }
}

