/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.clustering;

import com.oracle.labs.mlrg.olcut.util.MutableLong;
import com.oracle.labs.mlrg.olcut.util.MutableNumber;
import com.oracle.labs.mlrg.olcut.util.Pair;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.tribuo.ImmutableOutputInfo;
import org.tribuo.MutableOutputInfo;
import org.tribuo.OutputInfo;
import org.tribuo.clustering.ClusterID;
import org.tribuo.clustering.ImmutableClusteringInfo;
import org.tribuo.clustering.MutableClusteringInfo;
import org.tribuo.protos.ProtoSerializable;
import org.tribuo.protos.ProtoSerializableField;
import org.tribuo.protos.ProtoSerializableKeysValuesField;
import org.tribuo.protos.ProtoUtil;
import org.tribuo.protos.core.OutputDomainProto;

public abstract class ClusteringInfo
implements OutputInfo<ClusterID> {
    private static final long serialVersionUID = 1L;
    @ProtoSerializableKeysValuesField(keysName="id", valuesName="count")
    protected final Map<Integer, MutableLong> clusterCounts;
    @ProtoSerializableField
    protected int unknownCount = 0;

    ClusteringInfo() {
        this.clusterCounts = new HashMap<Integer, MutableLong>();
    }

    ClusteringInfo(ClusteringInfo other) {
        this.clusterCounts = MutableNumber.copyMap(other.clusterCounts);
    }

    ClusteringInfo(Map<Integer, MutableLong> clusterCounts, int unknownCount) {
        if (unknownCount < 0) {
            throw new IllegalStateException("unknownCount must be non-negative, found " + unknownCount);
        }
        this.unknownCount = unknownCount;
        this.clusterCounts = new HashMap<Integer, MutableLong>();
        for (Map.Entry<Integer, MutableLong> e : clusterCounts.entrySet()) {
            if (e.getValue().longValue() < 1L) {
                throw new IllegalArgumentException("Count for " + e.getKey() + " must be positive but found " + e.getValue().longValue());
            }
            if (e.getKey() < 0) {
                throw new IllegalArgumentException("Id " + e.getKey() + " is invalid, all ids must be non-negative");
            }
            this.clusterCounts.put(e.getKey(), e.getValue());
        }
    }

    public OutputDomainProto serialize() {
        return (OutputDomainProto)ProtoUtil.serialize((ProtoSerializable)this);
    }

    public int getUnknownCount() {
        return this.unknownCount;
    }

    public Set<ClusterID> getDomain() {
        HashSet<ClusterID> outputs = new HashSet<ClusterID>();
        for (Map.Entry<Integer, MutableLong> e : this.clusterCounts.entrySet()) {
            outputs.add(new ClusterID(e.getKey()));
        }
        return outputs;
    }

    public int size() {
        return this.clusterCounts.size();
    }

    public ImmutableOutputInfo<ClusterID> generateImmutableOutputInfo() {
        return new ImmutableClusteringInfo(this);
    }

    public MutableOutputInfo<ClusterID> generateMutableOutputInfo() {
        return new MutableClusteringInfo(this);
    }

    public abstract ClusteringInfo copy();

    public Iterable<Pair<String, Long>> outputCountsIterable() {
        return () -> new Iterator<Pair<String, Long>>(){
            Iterator<Map.Entry<Integer, MutableLong>> itr;
            {
                this.itr = ClusteringInfo.this.clusterCounts.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.itr.hasNext();
            }

            @Override
            public Pair<String, Long> next() {
                Map.Entry<Integer, MutableLong> e = this.itr.next();
                return new Pair((Object)("" + e.getKey()), (Object)e.getValue().longValue());
            }
        };
    }

    public String toReadableString() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<Integer, MutableLong> e : this.clusterCounts.entrySet()) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append('(');
            builder.append(e.getKey());
            builder.append(',');
            builder.append(e.getValue().longValue());
            builder.append(')');
        }
        return builder.toString();
    }

    public String toString() {
        return this.toReadableString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof ClusteringInfo)) {
            return false;
        }
        ClusteringInfo clusterInfo = (ClusteringInfo)o;
        if (this.unknownCount == clusterInfo.unknownCount && this.clusterCounts.size() == clusterInfo.clusterCounts.size()) {
            for (Map.Entry<Integer, MutableLong> e : this.clusterCounts.entrySet()) {
                MutableLong other = clusterInfo.clusterCounts.get(e.getKey());
                if (other != null && other.longValue() == e.getValue().longValue()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.clusterCounts, this.unknownCount);
    }
}

