/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.index.rankeval;

import io.lucenia.index.rankeval.EvaluationMetric;
import io.lucenia.index.rankeval.RatedRequest;
import io.skylite.core.ParseField;
import io.skylite.core.common.ParsingException;
import io.skylite.core.common.Strings;
import io.skylite.core.common.io.stream.NamedWriteable;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.script.Script;
import io.skylite.core.xcontent.ConstructingObjectParser;
import io.skylite.core.xcontent.MediaType;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class RankEvalSpec
implements Writeable,
ToXContentObject {
    private final List<RatedRequest> ratedRequests;
    private final EvaluationMetric metric;
    private int maxConcurrentSearches = 10;
    private static final int MAX_CONCURRENT_SEARCHES = 10;
    private final Map<String, Script> templates = new HashMap<String, Script>();
    private static final ParseField TEMPLATES_FIELD = new ParseField("templates", new String[0]);
    private static final ParseField METRIC_FIELD = new ParseField("metric", new String[0]);
    private static final ParseField REQUESTS_FIELD = new ParseField("requests", new String[0]);
    private static final ParseField MAX_CONCURRENT_SEARCHES_FIELD = new ParseField("max_concurrent_searches", new String[0]);
    private static final ConstructingObjectParser<RankEvalSpec, Void> PARSER = new ConstructingObjectParser("rank_eval", a -> new RankEvalSpec((List)a[0], (EvaluationMetric)a[1], (Collection)a[2]));

    public RankEvalSpec(List<RatedRequest> ratedRequests, EvaluationMetric metric, Collection<ScriptWithId> templates) {
        this.metric = Objects.requireNonNull(metric, "Cannot evaluate ranking if no evaluation metric is provided.");
        if (ratedRequests == null || ratedRequests.isEmpty()) {
            throw new IllegalArgumentException("Cannot evaluate ranking if no search requests with rated results are provided. Seen: " + String.valueOf(ratedRequests));
        }
        this.ratedRequests = ratedRequests;
        if (templates == null || templates.isEmpty()) {
            for (RatedRequest request : ratedRequests) {
                if (request.getEvaluationRequest() != null) continue;
                throw new IllegalStateException("Cannot evaluate ranking if neither template nor evaluation request is provided. Seen for request id: " + request.getId());
            }
        }
        if (templates != null) {
            for (ScriptWithId idScript : templates) {
                this.templates.put(idScript.id, idScript.script);
            }
        }
    }

    public RankEvalSpec(List<RatedRequest> ratedRequests, EvaluationMetric metric) {
        this(ratedRequests, metric, null);
    }

    public RankEvalSpec(StreamInput in) throws IOException {
        int specSize = in.readVInt();
        this.ratedRequests = new ArrayList<RatedRequest>(specSize);
        for (int i = 0; i < specSize; ++i) {
            this.ratedRequests.add(new RatedRequest(in));
        }
        this.metric = (EvaluationMetric)in.readNamedWriteable(EvaluationMetric.class);
        int size = in.readVInt();
        for (int i = 0; i < size; ++i) {
            String key = in.readString();
            Script value = new Script(in);
            this.templates.put(key, value);
        }
        this.maxConcurrentSearches = in.readVInt();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.ratedRequests.size());
        for (RatedRequest ratedRequest : this.ratedRequests) {
            ratedRequest.writeTo(out);
        }
        out.writeNamedWriteable((NamedWriteable)this.metric);
        out.writeVInt(this.templates.size());
        for (Map.Entry entry : this.templates.entrySet()) {
            out.writeString((String)entry.getKey());
            ((Script)entry.getValue()).writeTo(out);
        }
        out.writeVInt(this.maxConcurrentSearches);
    }

    public EvaluationMetric getMetric() {
        return this.metric;
    }

    public List<RatedRequest> getRatedRequests() {
        return Collections.unmodifiableList(this.ratedRequests);
    }

    public Map<String, Script> getTemplates() {
        return this.templates;
    }

    public int getMaxConcurrentSearches() {
        return this.maxConcurrentSearches;
    }

    public void setMaxConcurrentSearches(int maxConcurrentSearches) {
        this.maxConcurrentSearches = maxConcurrentSearches;
    }

    private static EvaluationMetric parseMetric(XContentParser parser) throws IOException {
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.FIELD_NAME, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        EvaluationMetric metric = (EvaluationMetric)parser.namedObject(EvaluationMetric.class, parser.currentName(), null);
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.END_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        return metric;
    }

    public static RankEvalSpec parse(XContentParser parser) {
        return (RankEvalSpec)PARSER.apply(parser, null);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startArray(TEMPLATES_FIELD.getPreferredName());
        for (Map.Entry<String, Script> entry : this.templates.entrySet()) {
            builder.startObject();
            builder.field(ScriptWithId.TEMPLATE_ID_FIELD.getPreferredName(), entry.getKey());
            builder.field(ScriptWithId.TEMPLATE_FIELD.getPreferredName(), (ToXContent)entry.getValue());
            builder.endObject();
        }
        builder.endArray();
        builder.startArray(REQUESTS_FIELD.getPreferredName());
        for (RatedRequest spec : this.ratedRequests) {
            spec.toXContent(builder, params);
        }
        builder.endArray();
        builder.field(METRIC_FIELD.getPreferredName(), (ToXContent)this.metric);
        builder.field(MAX_CONCURRENT_SEARCHES_FIELD.getPreferredName(), this.maxConcurrentSearches);
        builder.endObject();
        return builder;
    }

    public String toString() {
        return Strings.toString((MediaType)MediaTypeRegistry.JSON, (ToXContent)this);
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RankEvalSpec other = (RankEvalSpec)obj;
        return Objects.equals(this.ratedRequests, other.ratedRequests) && Objects.equals(this.metric, other.metric) && Objects.equals(this.maxConcurrentSearches, other.maxConcurrentSearches) && Objects.equals(this.templates, other.templates);
    }

    public final int hashCode() {
        return Objects.hash(this.ratedRequests, this.metric, this.templates, this.maxConcurrentSearches);
    }

    static {
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (p, c) -> RatedRequest.fromXContent(p), REQUESTS_FIELD);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> RankEvalSpec.parseMetric(p), METRIC_FIELD);
        PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ScriptWithId.fromXContent(p), TEMPLATES_FIELD);
        PARSER.declareInt(RankEvalSpec::setMaxConcurrentSearches, MAX_CONCURRENT_SEARCHES_FIELD);
    }

    static class ScriptWithId {
        private Script script;
        private String id;
        private static final ParseField TEMPLATE_FIELD = new ParseField("template", new String[0]);
        private static final ParseField TEMPLATE_ID_FIELD = new ParseField("id", new String[0]);
        private static final ConstructingObjectParser<ScriptWithId, Void> PARSER = new ConstructingObjectParser("script_with_id", a -> new ScriptWithId((String)a[0], (Script)a[1]));

        ScriptWithId(String id, Script script) {
            this.id = id;
            this.script = script;
        }

        public static ScriptWithId fromXContent(XContentParser parser) {
            return (ScriptWithId)PARSER.apply(parser, null);
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), TEMPLATE_ID_FIELD);
            PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> {
                try {
                    return Script.parse((XContentParser)p, (String)"mustache");
                }
                catch (IOException ex) {
                    throw new ParsingException(p.getTokenLocation(), "error parsing rank request", (Throwable)ex, new Object[0]);
                }
            }, TEMPLATE_FIELD);
        }
    }
}

