/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.index.rankeval;

import io.lucenia.index.rankeval.EvalQueryQuality;
import io.lucenia.index.rankeval.EvaluationMetric;
import io.lucenia.index.rankeval.RankEvalRequest;
import io.lucenia.index.rankeval.RankEvalResponse;
import io.lucenia.index.rankeval.RankEvalSpec;
import io.lucenia.index.rankeval.RatedRequest;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.search.MultiSearchRequest;
import io.skylite.core.action.search.MultiSearchResponse;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.client.Client;
import io.skylite.core.common.bytes.BytesArray;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.script.Script;
import io.skylite.core.script.ScriptService;
import io.skylite.core.script.TemplateScript;
import io.skylite.core.search.SearchHit;
import io.skylite.core.search.SearchRequest;
import io.skylite.core.search.builder.SearchSourceBuilder;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportService;
import io.skylite.core.xcontent.DeprecationHandler;
import io.skylite.core.xcontent.LoggingDeprecationHandler;
import io.skylite.core.xcontent.MediaType;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.XContentHelper;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class TransportRankEvalAction
extends HandledTransportAction<RankEvalRequest, RankEvalResponse> {
    private final Client client;
    private final ScriptService scriptService;
    private final NamedXContentRegistry namedXContentRegistry;

    @Inject
    public TransportRankEvalAction(ActionFilters actionFilters, Client client, TransportService transportService, ScriptService scriptService, NamedXContentRegistry namedXContentRegistry) {
        super("indices:data/read/rank_eval", transportService, actionFilters, RankEvalRequest::new);
        this.scriptService = scriptService;
        this.namedXContentRegistry = namedXContentRegistry;
        this.client = client;
    }

    protected void doExecute(Task task, RankEvalRequest request, ActionListener<RankEvalResponse> listener) {
        RankEvalSpec evaluationSpecification = request.getRankEvalSpec();
        EvaluationMetric metric = evaluationSpecification.getMetric();
        List<RatedRequest> ratedRequests = evaluationSpecification.getRatedRequests();
        ConcurrentHashMap<String, Exception> errors = new ConcurrentHashMap<String, Exception>(ratedRequests.size());
        HashMap<String, TemplateScript.Factory> scriptsWithoutParams = new HashMap<String, TemplateScript.Factory>();
        for (Map.Entry<String, Script> entry : evaluationSpecification.getTemplates().entrySet()) {
            scriptsWithoutParams.put(entry.getKey(), (TemplateScript.Factory)this.scriptService.compile(entry.getValue(), TemplateScript.CONTEXT));
        }
        MultiSearchRequest msearchRequest = new MultiSearchRequest();
        msearchRequest.maxConcurrentSearchRequests(evaluationSpecification.getMaxConcurrentSearches());
        ArrayList<RatedRequest> ratedRequestsInSearch = new ArrayList<RatedRequest>();
        for (RatedRequest ratedRequest : ratedRequests) {
            SearchSourceBuilder evaluationRequest = ratedRequest.getEvaluationRequest();
            if (evaluationRequest == null) {
                Map<String, Object> params = ratedRequest.getParams();
                String templateId = ratedRequest.getTemplateId();
                TemplateScript.Factory templateScript = (TemplateScript.Factory)scriptsWithoutParams.get(templateId);
                String resolvedRequest = templateScript.newInstance(params).execute();
                try (XContentParser subParser = XContentHelper.createParser((NamedXContentRegistry)this.namedXContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (BytesReference)new BytesArray(resolvedRequest), (MediaType)MediaTypeRegistry.JSON);){
                    evaluationRequest = SearchSourceBuilder.fromXContent((XContentParser)subParser, (boolean)false);
                    RatedRequest.validateEvaluatedQuery(evaluationRequest);
                }
                catch (IOException e) {
                    errors.put(ratedRequest.getId(), e);
                    continue;
                }
            }
            if (metric.forcedSearchSize().isPresent()) {
                evaluationRequest.size(metric.forcedSearchSize().getAsInt());
            }
            ratedRequestsInSearch.add(ratedRequest);
            List<String> summaryFields = ratedRequest.getSummaryFields();
            if (summaryFields.isEmpty()) {
                evaluationRequest.fetchSource(false);
            } else {
                evaluationRequest.fetchSource(summaryFields.toArray(new String[0]), new String[0]);
            }
            SearchRequest searchRequest = new SearchRequest(request.indices(), evaluationRequest);
            searchRequest.indicesOptions(request.indicesOptions());
            searchRequest.searchType(request.searchType());
            msearchRequest.add(searchRequest);
        }
        assert (ratedRequestsInSearch.size() == msearchRequest.requests().size());
        this.client.multiSearch(msearchRequest, (ActionListener)new RankEvalActionListener(this, listener, metric, ratedRequestsInSearch.toArray(new RatedRequest[0]), errors));
    }

    class RankEvalActionListener
    implements ActionListener<MultiSearchResponse> {
        private final ActionListener<RankEvalResponse> listener;
        private final RatedRequest[] specifications;
        private final Map<String, Exception> errors;
        private final EvaluationMetric metric;

        RankEvalActionListener(TransportRankEvalAction this$0, ActionListener<RankEvalResponse> listener, EvaluationMetric metric, RatedRequest[] specifications, Map<String, Exception> errors) {
            this.listener = listener;
            this.metric = metric;
            this.errors = errors;
            this.specifications = specifications;
        }

        public void onResponse(MultiSearchResponse multiSearchResponse) {
            int responsePosition = 0;
            HashMap<String, EvalQueryQuality> responseDetails = new HashMap<String, EvalQueryQuality>(this.specifications.length);
            for (MultiSearchResponse.Item response : multiSearchResponse.getResponses()) {
                RatedRequest specification = this.specifications[responsePosition];
                if (!response.isFailure()) {
                    SearchHit[] hits = response.getResponse().getHits().getHits();
                    EvalQueryQuality queryQuality = this.metric.evaluate(specification.getId(), hits, specification.getRatedDocs());
                    responseDetails.put(specification.getId(), queryQuality);
                } else {
                    this.errors.put(specification.getId(), response.getFailure());
                }
                ++responsePosition;
            }
            this.listener.onResponse((Object)new RankEvalResponse(this.metric.combine(responseDetails.values()), responseDetails, this.errors));
        }

        public void onFailure(Exception exception) {
            this.listener.onFailure(exception);
        }
    }
}

