/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.crs;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Map;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.metadata.internal.ImplementationHelper;
import org.apache.sis.referencing.crs.AbstractCRS;
import org.apache.sis.referencing.crs.ParametricCRS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.cs.DefaultParametricCS;
import org.apache.sis.referencing.datum.DefaultParametricDatum;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.referencing.cs.CoordinateSystem;

@XmlType(name="ParametricCRSType", propOrder={"coordinateSystem", "datum"})
@XmlRootElement(name="ParametricCRS")
public class DefaultParametricCRS
extends AbstractCRS
implements ParametricCRS {
    private static final long serialVersionUID = 4013698133331342649L;
    private DefaultParametricDatum datum;

    public DefaultParametricCRS(Map<String, ?> properties, DefaultParametricDatum datum, DefaultParametricCS cs) {
        super(properties, cs);
        ArgumentChecks.ensureNonNull((String)"datum", (Object)datum);
        this.datum = datum;
    }

    protected DefaultParametricCRS(DefaultParametricCRS crs) {
        super(crs);
        this.datum = crs.getDatum();
    }

    @Override
    @XmlElement(name="parametricDatum", required=true)
    public DefaultParametricDatum getDatum() {
        return this.datum;
    }

    @Override
    @XmlElement(name="parametricCS", required=true)
    public DefaultParametricCS getCoordinateSystem() {
        return (DefaultParametricCS)super.getCoordinateSystem();
    }

    @Override
    public DefaultParametricCRS forConvention(AxesConvention convention) {
        return (DefaultParametricCRS)super.forConvention(convention);
    }

    @Override
    final AbstractCRS createSameType(Map<String, ?> properties, CoordinateSystem cs) {
        return new DefaultParametricCRS(properties, this.datum, (DefaultParametricCS)cs);
    }

    @Override
    protected String formatTo(Formatter formatter) {
        super.formatTo(formatter);
        if (formatter.getConvention().majorVersion() == 1) {
            formatter.setInvalidWKT(this, null);
        }
        return DefaultParametricCRS.isBaseCRS(formatter) ? "BaseParamCRS" : "ParametricCRS";
    }

    private DefaultParametricCRS() {
    }

    private void setDatum(DefaultParametricDatum value) {
        if (this.datum == null) {
            this.datum = value;
        } else {
            ImplementationHelper.propertyAlreadySet(DefaultParametricCRS.class, (String)"setDatum", (String)"parametricDatum");
        }
    }

    private void setCoordinateSystem(DefaultParametricCS cs) {
        this.setCoordinateSystem("parametricCS", cs);
    }
}

