/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.repositories.azure;

import io.lucenia.plugins.Plugin;
import io.lucenia.plugins.ReloadablePlugin;
import io.lucenia.plugins.RepositoryPlugin;
import io.lucenia.repositories.azure.AzureRepository;
import io.lucenia.repositories.azure.AzureStorageService;
import io.lucenia.repositories.azure.AzureStorageSettings;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.env.Environment;
import io.skylite.core.indices.recovery.RecoverySettings;
import io.skylite.core.repositories.Repository;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.Settings;
import io.skylite.core.settings.SettingsException;
import io.skylite.core.threadpool.ExecutorBuilder;
import io.skylite.core.threadpool.ScalingExecutorBuilder;
import io.skylite.core.xcontent.NamedXContentRegistry;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class AzureRepositoryPlugin
extends Plugin
implements RepositoryPlugin,
ReloadablePlugin {
    public static final String REPOSITORY_THREAD_POOL_NAME = "repository_azure";
    final AzureStorageService azureStoreService;

    public AzureRepositoryPlugin(Settings settings) {
        this.azureStoreService = this.createAzureStoreService(settings);
    }

    AzureStorageService createAzureStoreService(Settings settings) {
        return new AzureStorageService(settings);
    }

    public Map<String, Repository.Factory> getRepositories(Environment env, NamedXContentRegistry namedXContentRegistry, ClusterService clusterService, RecoverySettings recoverySettings) {
        return Collections.singletonMap("azure", metadata -> new AzureRepository(metadata, namedXContentRegistry, this.azureStoreService, clusterService, recoverySettings));
    }

    public List<Setting<?>> getSettings() {
        return Arrays.asList(AzureStorageSettings.ACCOUNT_SETTING, AzureStorageSettings.KEY_SETTING, AzureStorageSettings.SAS_TOKEN_SETTING, AzureStorageSettings.ENDPOINT_SUFFIX_SETTING, AzureStorageSettings.TIMEOUT_SETTING, AzureStorageSettings.MAX_RETRIES_SETTING, AzureStorageSettings.CONNECT_TIMEOUT_SETTING, AzureStorageSettings.WRITE_TIMEOUT_SETTING, AzureStorageSettings.READ_TIMEOUT_SETTING, AzureStorageSettings.RESPONSE_TIMEOUT_SETTING, AzureStorageSettings.PROXY_TYPE_SETTING, AzureStorageSettings.PROXY_HOST_SETTING, AzureStorageSettings.PROXY_PORT_SETTING, AzureStorageSettings.PROXY_USERNAME_SETTING, AzureStorageSettings.PROXY_PASSWORD_SETTING);
    }

    public List<ExecutorBuilder<?>> getExecutorBuilders(Settings settings) {
        return Collections.singletonList(AzureRepositoryPlugin.executorBuilder());
    }

    public static ExecutorBuilder<?> executorBuilder() {
        return new ScalingExecutorBuilder(REPOSITORY_THREAD_POOL_NAME, 0, 32, TimeValue.timeValueSeconds((long)30L));
    }

    public void reload(Settings settings) {
        Map<String, AzureStorageSettings> clientsSettings = AzureStorageSettings.load(settings);
        if (clientsSettings.isEmpty()) {
            throw new SettingsException("If you want to use an azure repository, you need to define a client configuration.");
        }
        this.azureStoreService.refreshAndClearCache(clientsSettings);
    }
}

