/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.common.settings;

import io.lucenia.cli.KeyStoreAwareCommand;
import io.skylite.cli.Terminal;
import io.skylite.common.posix.UserException;
import io.skylite.core.env.Environment;
import io.skylite.core.settings.KeyStoreWrapper;
import java.nio.file.Path;
import joptsimple.OptionSet;

public class HasPasswordKeyStoreCommand
extends KeyStoreAwareCommand {
    static final int NO_PASSWORD_EXIT_CODE = 1;

    HasPasswordKeyStoreCommand() {
        super("Succeeds if the keystore exists and is password-protected, fails with exit code 1 otherwise.");
    }

    protected void execute(Terminal terminal, OptionSet options, Environment env) throws Exception {
        Path configFile = env.configDir();
        KeyStoreWrapper keyStore = KeyStoreWrapper.load((Path)configFile);
        if (keyStore == null) {
            terminal.errorPrintln(Terminal.Verbosity.NORMAL, "ERROR: Lucenia keystore not found");
            throw new UserException(1, null);
        }
        if (!keyStore.hasPassword()) {
            terminal.errorPrintln(Terminal.Verbosity.NORMAL, "ERROR: Keystore is not password-protected");
            throw new UserException(1, null);
        }
        terminal.println(Terminal.Verbosity.NORMAL, "Keystore is password-protected");
    }
}

