/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.index.reindex;

import io.lucenia.index.reindex.ReindexSslConfig;
import io.skylite.common.Nullable;
import io.skylite.common.action.ActionListener;
import io.skylite.common.unit.TimeValue;
import io.skylite.common.util.concurrent.AbstractRunnable;
import io.skylite.core.ParseField;
import io.skylite.core.action.DocWriteRequest;
import io.skylite.core.action.DocWriteResponse;
import io.skylite.core.action.admin.indices.refresh.RefreshRequest;
import io.skylite.core.action.admin.indices.refresh.RefreshResponse;
import io.skylite.core.action.bulk.BackoffPolicy;
import io.skylite.core.action.bulk.BulkItemResponse;
import io.skylite.core.action.bulk.BulkRequest;
import io.skylite.core.action.bulk.BulkResponse;
import io.skylite.core.action.bulk.Retry;
import io.skylite.core.action.delete.DeleteRequest;
import io.skylite.core.action.index.IndexRequest;
import io.skylite.core.action.support.TransportAction;
import io.skylite.core.client.ParentTaskAssigningClient;
import io.skylite.core.common.unit.ByteSizeValue;
import io.skylite.core.index.VersionType;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.script.Script;
import io.skylite.core.script.ScriptService;
import io.skylite.core.search.builder.SearchSourceBuilder;
import io.skylite.core.search.sort.BaseSortBuilder;
import io.skylite.core.search.sort.SortBuilders;
import io.skylite.core.threadpool.Scheduler;
import io.skylite.core.threadpool.ThreadPool;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.index.reindex.AbstractBulkByScrollRequest;
import org.opensearch.index.reindex.BulkByScrollResponse;
import org.opensearch.index.reindex.BulkByScrollTask;
import org.opensearch.index.reindex.ClientScrollableHitSource;
import org.opensearch.index.reindex.ScrollableHitSource;
import org.opensearch.index.reindex.WorkerBulkByScrollTaskState;
import org.opensearch.script.UpdateScript;

public abstract class AbstractAsyncBulkByScrollAction<Request extends AbstractBulkByScrollRequest<Request>, Action extends TransportAction<Request, ?>> {
    protected final Logger logger;
    protected final BulkByScrollTask task;
    protected final WorkerBulkByScrollTaskState worker;
    protected final ThreadPool threadPool;
    protected final ScriptService scriptService;
    protected final ReindexSslConfig sslConfig;
    protected final Optional<HttpRequestInterceptor> interceptor;
    protected final Request mainRequest;
    private final AtomicLong startTime = new AtomicLong(-1L);
    private final Set<String> destinationIndices = Collections.newSetFromMap(new ConcurrentHashMap());
    private final ParentTaskAssigningClient client;
    private final ActionListener<BulkByScrollResponse> listener;
    private final Retry bulkRetry;
    private final ScrollableHitSource scrollSource;
    private final BiFunction<RequestWrapper<?>, ScrollableHitSource.Hit, RequestWrapper<?>> scriptApplier;
    private int lastBatchSize;

    AbstractAsyncBulkByScrollAction(BulkByScrollTask task, boolean needsSourceDocumentVersions, boolean needsSourceDocumentSeqNoAndPrimaryTerm, Logger logger, ParentTaskAssigningClient client, ThreadPool threadPool, Request mainRequest, ActionListener<BulkByScrollResponse> listener, @Nullable ScriptService scriptService, @Nullable ReindexSslConfig sslConfig) {
        this(task, needsSourceDocumentVersions, needsSourceDocumentSeqNoAndPrimaryTerm, logger, client, threadPool, mainRequest, listener, scriptService, sslConfig, Optional.empty());
    }

    AbstractAsyncBulkByScrollAction(BulkByScrollTask task, boolean needsSourceDocumentVersions, boolean needsSourceDocumentSeqNoAndPrimaryTerm, Logger logger, ParentTaskAssigningClient client, ThreadPool threadPool, Request mainRequest, ActionListener<BulkByScrollResponse> listener, @Nullable ScriptService scriptService, @Nullable ReindexSslConfig sslConfig, Optional<HttpRequestInterceptor> interceptor) {
        this.task = task;
        this.scriptService = scriptService;
        this.sslConfig = sslConfig;
        if (!task.isWorker()) {
            throw new IllegalArgumentException("Given task [" + task.getId() + "] must have a child worker");
        }
        this.worker = task.getWorkerState();
        this.logger = logger;
        this.client = client;
        this.threadPool = threadPool;
        this.mainRequest = mainRequest;
        this.listener = listener;
        this.interceptor = interceptor;
        BackoffPolicy backoffPolicy = this.buildBackoffPolicy();
        this.bulkRetry = new Retry(BackoffPolicy.wrap((BackoffPolicy)backoffPolicy, () -> ((WorkerBulkByScrollTaskState)this.worker).countBulkRetry()), (Scheduler)threadPool);
        this.scrollSource = this.buildScrollableResultSource(backoffPolicy);
        this.scriptApplier = Objects.requireNonNull(this.buildScriptApplier(), "script applier must not be null");
        SearchSourceBuilder sourceBuilder = mainRequest.getSearchRequest().source();
        List sorts = sourceBuilder.sorts();
        if (sorts == null || sorts.isEmpty()) {
            sourceBuilder.sort((BaseSortBuilder)SortBuilders.fieldSort((String)"_doc"));
        }
        sourceBuilder.version(Boolean.valueOf(needsSourceDocumentVersions));
        sourceBuilder.seqNoAndPrimaryTerm(Boolean.valueOf(needsSourceDocumentSeqNoAndPrimaryTerm));
    }

    public BiFunction<RequestWrapper<?>, ScrollableHitSource.Hit, RequestWrapper<?>> buildScriptApplier() {
        return (request, searchHit) -> request;
    }

    protected abstract RequestWrapper<?> buildRequest(ScrollableHitSource.Hit var1);

    protected RequestWrapper<?> copyMetadata(RequestWrapper<?> request, ScrollableHitSource.Hit doc) {
        this.copyRouting(request, doc.getRouting());
        return request;
    }

    protected void copyRouting(RequestWrapper<?> request, String routing) {
        request.setRouting(routing);
    }

    protected boolean accept(ScrollableHitSource.Hit doc) {
        if (doc.getSource() == null) {
            throw new IllegalArgumentException("[" + doc.getIndex() + "][" + doc.getId() + "] didn't store _source");
        }
        return true;
    }

    private BulkRequest buildBulk(Iterable<? extends ScrollableHitSource.Hit> docs) {
        BulkRequest bulkRequest = new BulkRequest();
        for (ScrollableHitSource.Hit hit : docs) {
            RequestWrapper<?> request;
            if (!this.accept(hit) || (request = this.scriptApplier.apply(this.copyMetadata(this.buildRequest(hit), hit), hit)) == null) continue;
            bulkRequest.add(request.self());
        }
        return bulkRequest;
    }

    protected ScrollableHitSource buildScrollableResultSource(BackoffPolicy backoffPolicy) {
        return new ClientScrollableHitSource(this.logger, backoffPolicy, this.threadPool, () -> ((WorkerBulkByScrollTaskState)this.worker).countSearchRetry(), this::onScrollResponse, this::finishHim, this.client, this.mainRequest.getSearchRequest());
    }

    protected BulkByScrollResponse buildResponse(TimeValue took, List<BulkItemResponse.Failure> indexingFailures, List<ScrollableHitSource.SearchFailure> searchFailures, boolean timedOut) {
        return new BulkByScrollResponse(took, this.task.getStatus(), indexingFailures, searchFailures, timedOut);
    }

    public void start() {
        this.logger.debug("[{}]: starting", (Object)this.task.getId());
        if (this.task.isCancelled()) {
            this.logger.debug("[{}]: finishing early because the task was cancelled", (Object)this.task.getId());
            this.finishHim(null);
            return;
        }
        try {
            this.startTime.set(System.nanoTime());
            this.scrollSource.start();
        }
        catch (Exception e) {
            this.finishHim(e);
        }
    }

    void onScrollResponse(ScrollableHitSource.AsyncResponse asyncResponse) {
        this.onScrollResponse(System.nanoTime(), this.lastBatchSize, asyncResponse);
    }

    void onScrollResponse(long lastBatchStartTimeNS, int lastBatchSize, final ScrollableHitSource.AsyncResponse asyncResponse) {
        ScrollableHitSource.Response response = asyncResponse.response();
        this.logger.debug("[{}]: got scroll response with [{}] hits", (Object)this.task.getId(), (Object)response.getHits().size());
        if (this.task.isCancelled()) {
            this.logger.debug("[{}]: finishing early because the task was cancelled", (Object)this.task.getId());
            this.finishHim(null);
            return;
        }
        if (response.getFailures().size() > 0 || response.isTimedOut()) {
            this.refreshAndFinish(Collections.emptyList(), response.getFailures(), response.isTimedOut());
            return;
        }
        long total = response.getTotalHits();
        if (this.mainRequest.getMaxDocs() > 0) {
            total = Math.min(total, (long)this.mainRequest.getMaxDocs());
        }
        this.worker.setTotal(total);
        AbstractRunnable prepareBulkRequestRunnable = new AbstractRunnable(){

            public void doRun() throws Exception {
                AbstractAsyncBulkByScrollAction.this.prepareBulkRequest(System.nanoTime(), asyncResponse);
            }

            public void onFailure(Exception e) {
                AbstractAsyncBulkByScrollAction.this.finishHim(e);
            }
        };
        prepareBulkRequestRunnable = (AbstractRunnable)this.threadPool.getThreadContext().preserveContext((Runnable)prepareBulkRequestRunnable);
        this.worker.delayPrepareBulkRequest(this.threadPool, lastBatchStartTimeNS, lastBatchSize, prepareBulkRequestRunnable);
    }

    void prepareBulkRequest(long thisBatchStartTimeNS, ScrollableHitSource.AsyncResponse asyncResponse) {
        BulkRequest request;
        long remaining;
        ScrollableHitSource.Response response = asyncResponse.response();
        this.logger.debug("[{}]: preparing bulk request", (Object)this.task.getId());
        if (this.task.isCancelled()) {
            this.logger.debug("[{}]: finishing early because the task was cancelled", (Object)this.task.getId());
            this.finishHim(null);
            return;
        }
        if (response.getHits().isEmpty()) {
            this.refreshAndFinish(Collections.emptyList(), Collections.emptyList(), false);
            return;
        }
        this.worker.countBatch();
        List hits = response.getHits();
        if (this.mainRequest.getMaxDocs() != -1 && (remaining = Math.max(0L, (long)this.mainRequest.getMaxDocs() - this.worker.getSuccessfullyProcessed())) < (long)hits.size()) {
            hits = hits.subList(0, (int)remaining);
        }
        if ((request = this.buildBulk(hits)).requests().isEmpty()) {
            this.notifyDone(thisBatchStartTimeNS, asyncResponse, 0);
            return;
        }
        request.timeout(this.mainRequest.getTimeout());
        request.waitForActiveShards(this.mainRequest.getWaitForActiveShards());
        this.sendBulkRequest(request, () -> this.notifyDone(thisBatchStartTimeNS, asyncResponse, request.requests().size()));
    }

    void sendBulkRequest(BulkRequest request, final Runnable onSuccess) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("[{}]: sending [{}] entry, [{}] bulk request", (Object)this.task.getId(), (Object)request.requests().size(), (Object)new ByteSizeValue(request.estimatedSizeInBytes()));
        }
        if (this.task.isCancelled()) {
            this.logger.debug("[{}]: finishing early because the task was cancelled", (Object)this.task.getId());
            this.finishHim(null);
            return;
        }
        this.bulkRetry.withBackoff((arg_0, arg_1) -> ((ParentTaskAssigningClient)this.client).bulk(arg_0, arg_1), request, (ActionListener)new ActionListener<BulkResponse>(){

            public void onResponse(BulkResponse response) {
                AbstractAsyncBulkByScrollAction.this.onBulkResponse(response, onSuccess);
            }

            public void onFailure(Exception e) {
                AbstractAsyncBulkByScrollAction.this.finishHim(e);
            }
        });
    }

    void onBulkResponse(BulkResponse response, Runnable onSuccess) {
        try {
            ArrayList<BulkItemResponse.Failure> failures = new ArrayList<BulkItemResponse.Failure>();
            HashSet<String> destinationIndicesThisBatch = new HashSet<String>();
            for (BulkItemResponse item : response) {
                if (item.isFailed()) {
                    this.recordFailure(item.getFailure(), failures);
                    continue;
                }
                switch (item.getOpType()) {
                    case CREATE: 
                    case INDEX: {
                        if (item.getResponse().getResult() == DocWriteResponse.Result.CREATED) {
                            this.worker.countCreated();
                            break;
                        }
                        this.worker.countUpdated();
                        break;
                    }
                    case UPDATE: {
                        this.worker.countUpdated();
                        break;
                    }
                    case DELETE: {
                        this.worker.countDeleted();
                    }
                }
                destinationIndicesThisBatch.add(item.getIndex());
            }
            if (this.task.isCancelled()) {
                this.logger.debug("[{}]: Finishing early because the task was cancelled", (Object)this.task.getId());
                this.finishHim(null);
                return;
            }
            this.addDestinationIndices(destinationIndicesThisBatch);
            if (!failures.isEmpty()) {
                this.refreshAndFinish(Collections.unmodifiableList(failures), Collections.emptyList(), false);
                return;
            }
            if (this.mainRequest.getMaxDocs() != -1 && this.worker.getSuccessfullyProcessed() >= (long)this.mainRequest.getMaxDocs()) {
                this.refreshAndFinish(Collections.emptyList(), Collections.emptyList(), false);
                return;
            }
            onSuccess.run();
        }
        catch (Exception t) {
            this.finishHim(t);
        }
    }

    void notifyDone(long thisBatchStartTimeNS, ScrollableHitSource.AsyncResponse asyncResponse, int batchSize) {
        if (this.task.isCancelled()) {
            this.logger.debug("[{}]: finishing early because the task was cancelled", (Object)this.task.getId());
            this.finishHim(null);
            return;
        }
        this.lastBatchSize = batchSize;
        asyncResponse.done(this.worker.throttleWaitTime(thisBatchStartTimeNS, System.nanoTime(), batchSize));
    }

    private void recordFailure(BulkItemResponse.Failure failure, List<BulkItemResponse.Failure> failures) {
        if (failure.getStatus() == RestStatus.CONFLICT) {
            this.worker.countVersionConflict();
            if (!this.mainRequest.isAbortOnVersionConflict()) {
                return;
            }
        }
        failures.add(failure);
    }

    void refreshAndFinish(final List<BulkItemResponse.Failure> indexingFailures, final List<ScrollableHitSource.SearchFailure> searchFailures, final boolean timedOut) {
        if (this.task.isCancelled() || !this.mainRequest.isRefresh() || this.destinationIndices.isEmpty()) {
            this.finishHim(null, indexingFailures, searchFailures, timedOut);
            return;
        }
        RefreshRequest refresh = new RefreshRequest(new String[0]);
        refresh.indices(this.destinationIndices.toArray(new String[0]));
        this.logger.debug("[{}]: refreshing", (Object)this.task.getId());
        this.client.admin().indices().refresh(refresh, (ActionListener)new ActionListener<RefreshResponse>(){

            public void onResponse(RefreshResponse response) {
                AbstractAsyncBulkByScrollAction.this.finishHim(null, indexingFailures, searchFailures, timedOut);
            }

            public void onFailure(Exception e) {
                AbstractAsyncBulkByScrollAction.this.finishHim(e);
            }
        });
    }

    protected void finishHim(Exception failure) {
        this.logger.debug(() -> new ParameterizedMessage("[{}]: finishing with a catastrophic failure", (Object)this.task.getId()), (Throwable)failure);
        this.finishHim(failure, Collections.emptyList(), Collections.emptyList(), false);
    }

    protected void finishHim(Exception failure, List<BulkItemResponse.Failure> indexingFailures, List<ScrollableHitSource.SearchFailure> searchFailures, boolean timedOut) {
        this.logger.debug("[{}]: finishing without any catastrophic failures", (Object)this.task.getId());
        this.scrollSource.close(() -> {
            if (failure == null) {
                BulkByScrollResponse response = this.buildResponse(TimeValue.timeValueNanos((long)(System.nanoTime() - this.startTime.get())), indexingFailures, searchFailures, timedOut);
                this.listener.onResponse((Object)response);
            } else {
                this.listener.onFailure(failure);
            }
        });
    }

    BackoffPolicy buildBackoffPolicy() {
        return BackoffPolicy.exponentialBackoff((TimeValue)this.mainRequest.getRetryBackoffInitialTime(), (int)this.mainRequest.getMaxRetries());
    }

    void addDestinationIndices(Collection<String> indices) {
        this.destinationIndices.addAll(indices);
    }

    void setScroll(String scroll) {
        this.scrollSource.setScroll(scroll);
    }

    public static RequestWrapper<IndexRequest> wrap(IndexRequest request) {
        return new IndexRequestWrapper(request);
    }

    public static RequestWrapper<DeleteRequest> wrap(DeleteRequest request) {
        return new DeleteRequestWrapper(request);
    }

    public static interface RequestWrapper<Self extends DocWriteRequest<Self>> {
        public void setIndex(String var1);

        public String getIndex();

        public void setId(String var1);

        public String getId();

        public void setVersion(long var1);

        public long getVersion();

        public void setVersionType(VersionType var1);

        public void setRouting(String var1);

        public String getRouting();

        public void setSource(Map<String, Object> var1);

        public Map<String, Object> getSource();

        public Self self();
    }

    public static class IndexRequestWrapper
    implements RequestWrapper<IndexRequest> {
        private final IndexRequest request;

        IndexRequestWrapper(IndexRequest request) {
            this.request = Objects.requireNonNull(request, "Wrapped IndexRequest can not be null");
        }

        @Override
        public void setIndex(String index) {
            this.request.index(index);
        }

        @Override
        public String getIndex() {
            return this.request.index();
        }

        @Override
        public void setId(String id) {
            this.request.id(id);
        }

        @Override
        public String getId() {
            return this.request.id();
        }

        @Override
        public void setVersion(long version) {
            this.request.version(version);
        }

        @Override
        public long getVersion() {
            return this.request.version();
        }

        @Override
        public void setVersionType(VersionType versionType) {
            this.request.versionType(versionType);
        }

        @Override
        public void setRouting(String routing) {
            this.request.routing(routing);
        }

        @Override
        public String getRouting() {
            return this.request.routing();
        }

        @Override
        public Map<String, Object> getSource() {
            return this.request.sourceAsMap();
        }

        @Override
        public void setSource(Map<String, Object> source) {
            this.request.source(source);
        }

        @Override
        public IndexRequest self() {
            return this.request;
        }
    }

    public static class DeleteRequestWrapper
    implements RequestWrapper<DeleteRequest> {
        private final DeleteRequest request;

        DeleteRequestWrapper(DeleteRequest request) {
            this.request = Objects.requireNonNull(request, "Wrapped DeleteRequest can not be null");
        }

        @Override
        public void setIndex(String index) {
            this.request.index(index);
        }

        @Override
        public String getIndex() {
            return this.request.index();
        }

        @Override
        public void setId(String id) {
            this.request.id(id);
        }

        @Override
        public String getId() {
            return this.request.id();
        }

        @Override
        public void setVersion(long version) {
            this.request.version(version);
        }

        @Override
        public long getVersion() {
            return this.request.version();
        }

        @Override
        public void setVersionType(VersionType versionType) {
            this.request.versionType(versionType);
        }

        @Override
        public void setRouting(String routing) {
            this.request.routing(routing);
        }

        @Override
        public String getRouting() {
            return this.request.routing();
        }

        @Override
        public Map<String, Object> getSource() {
            throw new UnsupportedOperationException("unable to get source from action request [" + String.valueOf(this.request.getClass()) + "]");
        }

        @Override
        public void setSource(Map<String, Object> source) {
            throw new UnsupportedOperationException("unable to set [source] on action request [" + String.valueOf(this.request.getClass()) + "]");
        }

        @Override
        public DeleteRequest self() {
            return this.request;
        }
    }

    public static enum OpType {
        NOOP("noop"),
        INDEX("index"),
        DELETE("delete");

        private final String id;

        private OpType(String id) {
            this.id = id;
        }

        public static OpType fromString(String opType) {
            String lowerOpType;
            switch (lowerOpType = opType.toLowerCase(Locale.ROOT)) {
                case "noop": {
                    return NOOP;
                }
                case "index": {
                    return INDEX;
                }
                case "delete": {
                    return DELETE;
                }
            }
            throw new IllegalArgumentException("Operation type [" + lowerOpType + "] not allowed, only " + Arrays.toString((Object[])OpType.values()) + " are allowed");
        }

        public String toString() {
            return this.id.toLowerCase(Locale.ROOT);
        }
    }

    public static abstract class ScriptApplier
    implements BiFunction<RequestWrapper<?>, ScrollableHitSource.Hit, RequestWrapper<?>> {
        private final WorkerBulkByScrollTaskState taskWorker;
        private final ScriptService scriptService;
        private final Script script;
        private final Map<String, Object> params;

        public ScriptApplier(WorkerBulkByScrollTaskState taskWorker, ScriptService scriptService, Script script, Map<String, Object> params) {
            this.taskWorker = taskWorker;
            this.scriptService = scriptService;
            this.script = script;
            this.params = params;
        }

        @Override
        public RequestWrapper<?> apply(RequestWrapper<?> request, ScrollableHitSource.Hit doc) {
            OpType newOpType;
            if (this.script == null) {
                return request;
            }
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("_index", doc.getIndex());
            context.put(ParseField.CommonMetaFields.ID_FIELD.getPreferredName(), doc.getId());
            Long oldVersion = doc.getVersion();
            context.put(ParseField.CommonMetaFields.VERSION_FIELD.getPreferredName(), oldVersion);
            String oldRouting = doc.getRouting();
            context.put(ParseField.CommonMetaFields.ROUTING_FIELD.getPreferredName(), oldRouting);
            context.put(ParseField.CommonMetaFields.SOURCE_FIELD.getPreferredName(), request.getSource());
            OpType oldOpType = OpType.INDEX;
            context.put("op", oldOpType.toString());
            UpdateScript.Factory factory = (UpdateScript.Factory)this.scriptService.compile(this.script, UpdateScript.CONTEXT);
            UpdateScript updateScript = factory.newInstance(this.params, context);
            updateScript.execute();
            String newOp = (String)context.remove("op");
            if (newOp == null) {
                throw new IllegalArgumentException("Script cleared operation type");
            }
            request.setSource((Map)context.remove(ParseField.CommonMetaFields.SOURCE_FIELD.getPreferredName()));
            Object newValue = context.remove("_index");
            if (!doc.getIndex().equals(newValue)) {
                this.scriptChangedIndex(request, newValue);
            }
            newValue = context.remove(ParseField.CommonMetaFields.ID_FIELD.getPreferredName());
            if (!doc.getId().equals(newValue)) {
                this.scriptChangedId(request, newValue);
            }
            if (!Objects.equals(oldVersion, newValue = context.remove(ParseField.CommonMetaFields.VERSION_FIELD.getPreferredName()))) {
                this.scriptChangedVersion(request, newValue);
            }
            if (!Objects.equals(oldRouting, newValue = context.remove(ParseField.CommonMetaFields.ROUTING_FIELD.getPreferredName()))) {
                this.scriptChangedRouting(request, newValue);
            }
            if ((newOpType = OpType.fromString(newOp)) != oldOpType) {
                return this.scriptChangedOpType(request, oldOpType, newOpType);
            }
            if (!context.isEmpty()) {
                throw new IllegalArgumentException("Invalid fields added to context [" + String.join((CharSequence)",", context.keySet()) + "]");
            }
            return request;
        }

        protected RequestWrapper<?> scriptChangedOpType(RequestWrapper<?> request, OpType oldOpType, OpType newOpType) {
            switch (newOpType.ordinal()) {
                case 0: {
                    this.taskWorker.countNoop();
                    return null;
                }
                case 2: {
                    RequestWrapper<DeleteRequest> delete = AbstractAsyncBulkByScrollAction.wrap(new DeleteRequest(request.getIndex(), request.getId()));
                    delete.setVersion(request.getVersion());
                    delete.setVersionType(VersionType.INTERNAL);
                    delete.setRouting(request.getRouting());
                    return delete;
                }
            }
            throw new IllegalArgumentException("Unsupported operation type change from [" + String.valueOf((Object)oldOpType) + "] to [" + String.valueOf((Object)newOpType) + "]");
        }

        protected abstract void scriptChangedIndex(RequestWrapper<?> var1, Object var2);

        protected abstract void scriptChangedId(RequestWrapper<?> var1, Object var2);

        protected abstract void scriptChangedVersion(RequestWrapper<?> var1, Object var2);

        protected abstract void scriptChangedRouting(RequestWrapper<?> var1, Object var2);
    }
}

