/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.index.reindex;

import io.lucenia.index.reindex.ReindexSslConfig;
import io.lucenia.index.reindex.RestDeleteByQueryAction;
import io.lucenia.index.reindex.RestReindexAction;
import io.lucenia.index.reindex.RestRethrottleAction;
import io.lucenia.index.reindex.RestUpdateByQueryAction;
import io.lucenia.index.reindex.RethrottleAction;
import io.lucenia.index.reindex.TransportDeleteByQueryAction;
import io.lucenia.index.reindex.TransportReindexAction;
import io.lucenia.index.reindex.TransportRethrottleAction;
import io.lucenia.index.reindex.TransportUpdateByQueryAction;
import io.lucenia.index.reindex.spi.RemoteReindexExtension;
import io.lucenia.plugins.ActionPlugin;
import io.lucenia.plugins.ExtensiblePlugin;
import io.lucenia.plugins.Plugin;
import io.skylite.core.action.ActionType;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.node.DiscoveryNodes;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.io.stream.NamedWriteableRegistry;
import io.skylite.core.env.Environment;
import io.skylite.core.env.NodeEnvironment;
import io.skylite.core.repositories.RepositoriesService;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.script.ScriptService;
import io.skylite.core.settings.ClusterSettings;
import io.skylite.core.settings.IndexScopedSettings;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.Settings;
import io.skylite.core.settings.SettingsFilter;
import io.skylite.core.tasks.Task;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.xcontent.NamedXContentRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.index.reindex.BulkByScrollTask;
import org.opensearch.index.reindex.DeleteByQueryAction;
import org.opensearch.index.reindex.ReindexAction;
import org.opensearch.index.reindex.UpdateByQueryAction;
import org.opensearch.rest.RestController;
import org.opensearch.watcher.ResourceWatcherService;

public class ReindexModulePlugin
extends Plugin
implements ActionPlugin,
ExtensiblePlugin {
    public static final String NAME = "reindex";
    private static final Logger logger = LogManager.getLogger(ReindexModulePlugin.class);

    public List<ActionPlugin.ActionHandler> getActions() {
        return Arrays.asList(new ActionPlugin.ActionHandler((ActionType)ReindexAction.INSTANCE, TransportReindexAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)UpdateByQueryAction.INSTANCE, TransportUpdateByQueryAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)DeleteByQueryAction.INSTANCE, TransportDeleteByQueryAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)RethrottleAction.INSTANCE, TransportRethrottleAction.class, new Class[0]));
    }

    public List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        return Collections.singletonList(new NamedWriteableRegistry.Entry(Task.Status.class, "bulk-by-scroll", BulkByScrollTask.Status::new));
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        return Arrays.asList(new RestHandler[]{new RestReindexAction(), new RestUpdateByQueryAction(), new RestDeleteByQueryAction(), new RestRethrottleAction(nodesInCluster)});
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry, IndexNameExpressionResolver expressionResolver, Supplier<RepositoriesService> repositoriesServiceSupplier) {
        return Collections.singletonList(new ReindexSslConfig(environment.settings(), environment, resourceWatcherService));
    }

    public List<Setting<?>> getSettings() {
        ArrayList settings = new ArrayList();
        settings.add(TransportReindexAction.REMOTE_CLUSTER_WHITELIST);
        settings.add(TransportReindexAction.REMOTE_CLUSTER_ALLOWLIST);
        settings.addAll(ReindexSslConfig.getSettings());
        return settings;
    }

    public void loadExtensions(ExtensiblePlugin.ExtensionLoader loader) {
        logger.info("ReindexPlugin reloadSPI called");
        List iterable = loader.loadExtensions(RemoteReindexExtension.class);
        ArrayList remoteReindexExtensionList = new ArrayList();
        iterable.forEach(remoteReindexExtensionList::add);
        if (remoteReindexExtensionList.isEmpty()) {
            logger.info("Unable to find any implementation for RemoteReindexExtension");
        } else {
            if (remoteReindexExtensionList.size() > 1) {
                logger.warn("More than one implementation found: " + String.valueOf(remoteReindexExtensionList));
            }
            TransportReindexAction.remoteExtension = Optional.ofNullable((RemoteReindexExtension)remoteReindexExtensionList.get(0));
            logger.info("Loaded extension " + String.valueOf(TransportReindexAction.remoteExtension));
        }
    }
}

