/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.index.reindex;

import io.lucenia.index.reindex.AbstractBaseReindexRestHandler;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.common.io.stream.NamedWriteableRegistry;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.opensearch.index.reindex.ReindexAction;
import org.opensearch.index.reindex.ReindexRequest;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestRequestFilter;

public class RestReindexAction
extends AbstractBaseReindexRestHandler<ReindexRequest, ReindexAction>
implements RestRequestFilter {
    private static final Set<String> FILTERED_FIELDS = Collections.singleton("source.remote.host.password");

    public RestReindexAction() {
        super(ReindexAction.INSTANCE);
    }

    public List<RestHandler.Route> routes() {
        return Collections.singletonList(new RestHandler.Route(RestRequest.Method.POST, "/_reindex"));
    }

    public String getName() {
        return "reindex_action";
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        return this.doPrepareRequest(request, client, true, true);
    }

    @Override
    protected ReindexRequest buildRequest(RestRequest request, NamedWriteableRegistry namedWriteableRegistry) throws IOException {
        ReindexRequest internal;
        if (request.hasParam("pipeline")) {
            throw new IllegalArgumentException("_reindex doesn't support [pipeline] as a query parameter. Specify it in the [dest] object instead.");
        }
        try (XContentParser parser = request.contentParser();){
            internal = ReindexRequest.fromXContent((XContentParser)parser);
        }
        if (request.hasParam("scroll")) {
            internal.setScroll(TimeValue.parseTimeValue((String)request.param("scroll"), (String)"scroll"));
        }
        if (request.hasParam("require_alias")) {
            internal.setRequireAlias(request.paramAsBoolean("require_alias", false));
        }
        return internal;
    }

    public Set<String> getFilteredFields() {
        return FILTERED_FIELDS;
    }
}

