/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.index.reindex;

import io.lucenia.action.support.AutoCreateIndex;
import io.lucenia.index.reindex.ReindexSslConfig;
import io.lucenia.index.reindex.ReindexValidator;
import io.lucenia.index.reindex.Reindexer;
import io.lucenia.index.reindex.spi.RemoteReindexExtension;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.script.ScriptService;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.Settings;
import io.skylite.core.tasks.Task;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.opensearch.index.reindex.BulkByScrollResponse;
import org.opensearch.index.reindex.BulkByScrollTask;
import org.opensearch.index.reindex.ReindexRequest;

public class TransportReindexAction
extends HandledTransportAction<ReindexRequest, BulkByScrollResponse> {
    static final Setting<List<String>> REMOTE_CLUSTER_WHITELIST = Setting.listSetting((String)"reindex.remote.whitelist", Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Deprecated});
    public static final Setting<List<String>> REMOTE_CLUSTER_ALLOWLIST = Setting.listSetting((String)"reindex.remote.allowlist", REMOTE_CLUSTER_WHITELIST, Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static Optional<RemoteReindexExtension> remoteExtension = Optional.empty();
    private final ReindexValidator reindexValidator;
    private final Reindexer reindexer;

    @Inject
    public TransportReindexAction(Settings settings, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, ClusterService clusterService, ScriptService scriptService, AutoCreateIndex autoCreateIndex, Client client, TransportService transportService, ReindexSslConfig sslConfig) {
        super("indices:data/write/reindex", transportService, actionFilters, ReindexRequest::new);
        this.reindexValidator = new ReindexValidator(settings, clusterService, indexNameExpressionResolver, autoCreateIndex);
        this.reindexer = new Reindexer(clusterService, client, threadPool, scriptService, sslConfig, remoteExtension);
    }

    protected void doExecute(Task task, final ReindexRequest request, final ActionListener<BulkByScrollResponse> listener) {
        this.reindexValidator.initialValidation(request);
        final BulkByScrollTask bulkByScrollTask = (BulkByScrollTask)task;
        this.reindexer.initTask(bulkByScrollTask, request, new ActionListener<Void>(){

            public void onResponse(Void v) {
                TransportReindexAction.this.reindexer.execute(bulkByScrollTask, request, (ActionListener<BulkByScrollResponse>)listener);
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        });
    }
}

