/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.index.reindex;

import io.lucenia.action.support.tasks.TransportTasksAction;
import io.lucenia.index.reindex.RethrottleAction;
import io.lucenia.index.reindex.RethrottleRequest;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.FailedNodeException;
import io.skylite.core.action.TaskOperationFailure;
import io.skylite.core.action.admin.cluster.node.tasks.list.ListTasksResponse;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.tasks.TaskId;
import io.skylite.core.tasks.TaskInfo;
import io.skylite.core.transport.TransportService;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.opensearch.index.reindex.BulkByScrollTask;
import org.opensearch.index.reindex.LeaderBulkByScrollTaskState;

public class TransportRethrottleAction
extends TransportTasksAction<BulkByScrollTask, RethrottleRequest, ListTasksResponse, TaskInfo> {
    private final Client client;

    @Inject
    public TransportRethrottleAction(ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, Client client) {
        super("cluster:admin/reindex/rethrottle", clusterService, transportService, actionFilters, RethrottleRequest::new, ListTasksResponse::new, TaskInfo::new, "management");
        this.client = client;
    }

    protected void taskOperation(RethrottleRequest request, BulkByScrollTask task, ActionListener<TaskInfo> listener) {
        TransportRethrottleAction.rethrottle(this.logger, this.clusterService.localNode().getId(), this.client, task, request.getRequestsPerSecond(), listener);
    }

    static void rethrottle(Logger logger, String localNodeId, Client client, BulkByScrollTask task, float newRequestsPerSecond, ActionListener<TaskInfo> listener) {
        if (task.isWorker()) {
            TransportRethrottleAction.rethrottleChildTask(logger, localNodeId, task, newRequestsPerSecond, listener);
            return;
        }
        if (task.isLeader()) {
            TransportRethrottleAction.rethrottleParentTask(logger, localNodeId, client, task, newRequestsPerSecond, listener);
            return;
        }
        throw new IllegalArgumentException("task [" + task.getId() + "] has not yet been initialized to the point where it knows how to rethrottle itself");
    }

    private static void rethrottleParentTask(Logger logger, String localNodeId, Client client, BulkByScrollTask task, float newRequestsPerSecond, ActionListener<TaskInfo> listener) {
        LeaderBulkByScrollTaskState leaderState = task.getLeaderState();
        int runningSubtasks = leaderState.runningSliceSubTasks();
        if (runningSubtasks > 0) {
            RethrottleRequest subRequest = new RethrottleRequest();
            subRequest.setRequestsPerSecond(newRequestsPerSecond / (float)runningSubtasks);
            subRequest.setParentTaskId(new TaskId(localNodeId, task.getId()));
            logger.debug("rethrottling children of task [{}] to [{}] requests per second", (Object)task.getId(), (Object)Float.valueOf(subRequest.getRequestsPerSecond()));
            client.execute((ActionType)RethrottleAction.INSTANCE, (ActionRequest)subRequest, ActionListenerHelper.wrap(r -> {
                r.rethrowFailures("Rethrottle");
                listener.onResponse((Object)task.taskInfoGivenSubtaskInfo(localNodeId, r.getTasks()));
            }, arg_0 -> listener.onFailure(arg_0)));
        } else {
            logger.debug("children of task [{}] are already finished, nothing to rethrottle", (Object)task.getId());
            listener.onResponse((Object)task.taskInfo(localNodeId, true));
        }
    }

    private static void rethrottleChildTask(Logger logger, String localNodeId, BulkByScrollTask task, float newRequestsPerSecond, ActionListener<TaskInfo> listener) {
        logger.debug("rethrottling local task [{}] to [{}] requests per second", (Object)task.getId(), (Object)Float.valueOf(newRequestsPerSecond));
        task.getWorkerState().rethrottle(newRequestsPerSecond);
        listener.onResponse((Object)task.taskInfo(localNodeId, true));
    }

    protected ListTasksResponse newResponse(RethrottleRequest request, List<TaskInfo> tasks, List<TaskOperationFailure> taskOperationFailures, List<FailedNodeException> failedNodeExceptions) {
        return new ListTasksResponse(tasks, taskOperationFailures, failedNodeExceptions);
    }
}

