/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.search.aggregations.support;

import io.lucenia.search.aggregations.support.ArrayValuesSourceAggregationBuilder;
import io.skylite.core.ParseField;
import io.skylite.core.aggregations.AggregationBuilder;
import io.skylite.core.aggregations.Aggregator;
import io.skylite.core.aggregations.values.BytesValuesSource;
import io.skylite.core.aggregations.values.CoreValuesSourceType;
import io.skylite.core.aggregations.values.GeoPointValuesSource;
import io.skylite.core.aggregations.values.GeoValuesSourceType;
import io.skylite.core.aggregations.values.NumericValuesSource;
import io.skylite.core.aggregations.values.ValueType;
import io.skylite.core.aggregations.values.ValueTypes;
import io.skylite.core.aggregations.values.ValuesSource;
import io.skylite.core.aggregations.values.ValuesSourceType;
import io.skylite.core.common.ParsingException;
import io.skylite.core.script.Script;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opensearch.search.aggregations.support.GeoValueTypes;

public abstract class ArrayValuesSourceParser<VS extends ValuesSource>
implements Aggregator.Parser {
    private boolean formattable = false;
    private ValuesSourceType valuesSourceType = null;
    private ValueType targetValueType = null;

    private ArrayValuesSourceParser(boolean formattable, ValuesSourceType valuesSourceType, ValueType targetValueType) {
        this.valuesSourceType = valuesSourceType;
        this.targetValueType = targetValueType;
        this.formattable = formattable;
    }

    public final ArrayValuesSourceAggregationBuilder<?> parse(String aggregationName, XContentParser parser) throws IOException {
        XContentParser.Token token;
        List<String> fields = null;
        String format = null;
        HashMap<String, Object> missingMap = null;
        HashMap<ParseField, Object> otherOptions = new HashMap<ParseField, Object>();
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.VALUE_STRING) {
                if (AggregationBuilder.CommonFields.FIELDS.match(currentFieldName, parser.getDeprecationHandler())) {
                    fields = Collections.singletonList(parser.text());
                    continue;
                }
                if (this.formattable && AggregationBuilder.CommonFields.FORMAT.match(currentFieldName, parser.getDeprecationHandler())) {
                    format = parser.text();
                    continue;
                }
                if (AggregationBuilder.CommonFields.VALUE_TYPE.match(currentFieldName, parser.getDeprecationHandler())) {
                    throw new ParsingException(parser.getTokenLocation(), "Unexpected token " + String.valueOf(token) + " [" + currentFieldName + "] in [" + aggregationName + "]. Multi-field aggregations do not support scripts.", new Object[0]);
                }
                if (this.token(aggregationName, currentFieldName, token, parser, otherOptions)) continue;
                throw new ParsingException(parser.getTokenLocation(), "Unexpected token " + String.valueOf(token) + " [" + currentFieldName + "] in [" + aggregationName + "].", new Object[0]);
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (AggregationBuilder.CommonFields.MISSING.match(currentFieldName, parser.getDeprecationHandler())) {
                    missingMap = new HashMap<String, Object>();
                    while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                        this.parseMissingAndAdd(aggregationName, currentFieldName, parser, missingMap);
                    }
                    continue;
                }
                if (Script.SCRIPT_PARSE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    throw new ParsingException(parser.getTokenLocation(), "Unexpected token " + String.valueOf(token) + " [" + currentFieldName + "] in [" + aggregationName + "]. Multi-field aggregations do not support scripts.", new Object[0]);
                }
                if (this.token(aggregationName, currentFieldName, token, parser, otherOptions)) continue;
                throw new ParsingException(parser.getTokenLocation(), "Unexpected token " + String.valueOf(token) + " [" + currentFieldName + "] in [" + aggregationName + "].", new Object[0]);
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if (Script.SCRIPT_PARSE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    throw new ParsingException(parser.getTokenLocation(), "Unexpected token " + String.valueOf(token) + " [" + currentFieldName + "] in [" + aggregationName + "]. Multi-field aggregations do not support scripts.", new Object[0]);
                }
                if (AggregationBuilder.CommonFields.FIELDS.match(currentFieldName, parser.getDeprecationHandler())) {
                    fields = new ArrayList<String>();
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        if (token == XContentParser.Token.VALUE_STRING) {
                            fields.add(parser.text());
                            continue;
                        }
                        throw new ParsingException(parser.getTokenLocation(), "Unexpected token " + String.valueOf(token) + " [" + currentFieldName + "] in [" + aggregationName + "].", new Object[0]);
                    }
                    continue;
                }
                if (this.token(aggregationName, currentFieldName, token, parser, otherOptions)) continue;
                throw new ParsingException(parser.getTokenLocation(), "Unexpected token " + String.valueOf(token) + " [" + currentFieldName + "] in [" + aggregationName + "].", new Object[0]);
            }
            if (this.token(aggregationName, currentFieldName, token, parser, otherOptions)) continue;
            throw new ParsingException(parser.getTokenLocation(), "Unexpected token " + String.valueOf(token) + " [" + currentFieldName + "] in [" + aggregationName + "].", new Object[0]);
        }
        ArrayValuesSourceAggregationBuilder<?> factory = this.createFactory(aggregationName, this.valuesSourceType, this.targetValueType, otherOptions);
        if (fields != null) {
            factory.fields(fields);
        }
        if (format != null) {
            factory.format(format);
        }
        if (missingMap != null) {
            factory.missingMap(missingMap);
        }
        return factory;
    }

    private void parseMissingAndAdd(String aggregationName, String currentFieldName, XContentParser parser, Map<String, Object> missing) throws IOException {
        String fieldName;
        XContentParser.Token token = parser.currentToken();
        if (token == null) {
            token = parser.nextToken();
        }
        if (token == XContentParser.Token.FIELD_NAME) {
            fieldName = parser.currentName();
            if (missing.containsKey(fieldName)) {
                throw new ParsingException(parser.getTokenLocation(), "Missing field [" + fieldName + "] already defined as [" + String.valueOf(missing.get(fieldName)) + "] in [" + aggregationName + "].", new Object[0]);
            }
        } else {
            throw new ParsingException(parser.getTokenLocation(), "Unexpected token " + String.valueOf(token) + " [" + currentFieldName + "] in [" + aggregationName + "]", new Object[0]);
        }
        parser.nextToken();
        missing.put(fieldName, parser.objectText());
    }

    protected abstract ArrayValuesSourceAggregationBuilder<?> createFactory(String var1, ValuesSourceType var2, ValueType var3, Map<ParseField, Object> var4);

    protected abstract boolean token(String var1, String var2, XContentParser.Token var3, XContentParser var4, Map<ParseField, Object> var5) throws IOException;

    public static abstract class GeoPointValuesSourceParser
    extends ArrayValuesSourceParser<GeoPointValuesSource> {
        protected GeoPointValuesSourceParser(boolean formattable) {
            super(formattable, (ValuesSourceType)GeoValuesSourceType.GEOPOINT, (ValueType)GeoValueTypes.GEOPOINT);
        }
    }

    public static abstract class BytesValuesSourceParser
    extends ArrayValuesSourceParser<BytesValuesSource> {
        protected BytesValuesSourceParser(boolean formattable) {
            super(formattable, (ValuesSourceType)CoreValuesSourceType.BYTES, (ValueType)ValueTypes.STRING);
        }
    }

    public static abstract class NumericValuesSourceParser
    extends ArrayValuesSourceParser<NumericValuesSource> {
        protected NumericValuesSourceParser(boolean formattable) {
            super(formattable, (ValuesSourceType)CoreValuesSourceType.NUMERIC, (ValueType)ValueTypes.NUMERIC);
        }
    }
}

