/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.notifications;

import io.lucenia.notifications.CoreProvider;
import io.lucenia.notifications.action.CreateNotificationConfigAction;
import io.lucenia.notifications.action.DeleteNotificationConfigAction;
import io.lucenia.notifications.action.GetChannelListAction;
import io.lucenia.notifications.action.GetNotificationConfigAction;
import io.lucenia.notifications.action.GetPluginFeaturesAction;
import io.lucenia.notifications.action.PublishNotificationAction;
import io.lucenia.notifications.action.SendNotificationAction;
import io.lucenia.notifications.action.SendTestNotificationAction;
import io.lucenia.notifications.action.UpdateNotificationConfigAction;
import io.lucenia.notifications.index.ConfigIndexingActions;
import io.lucenia.notifications.index.NotificationConfigIndex;
import io.lucenia.notifications.resthandler.NotificationChannelListRestHandler;
import io.lucenia.notifications.resthandler.NotificationConfigRestHandler;
import io.lucenia.notifications.resthandler.NotificationFeaturesRestHandler;
import io.lucenia.notifications.resthandler.SendTestMessageRestHandler;
import io.lucenia.notifications.security.UserAccessManager;
import io.lucenia.notifications.send.SendMessageActionHelper;
import io.lucenia.notifications.settings.PluginSettings;
import io.lucenia.notifications.util.SecureIndexClient;
import io.lucenia.plugins.ActionPlugin;
import io.lucenia.plugins.ExtensiblePlugin;
import io.lucenia.plugins.Plugin;
import io.lucenia.plugins.ReloadablePlugin;
import io.lucenia.plugins.SystemIndexPlugin;
import io.skylite.core.client.Client;
import io.skylite.core.client.ReleasableSkyliteClient;
import io.skylite.core.client.metadata.MetadataClient;
import io.skylite.core.client.metadata.MetadataClientFactory;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.node.DiscoveryNodes;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.io.stream.NamedWriteableRegistry;
import io.skylite.core.env.Environment;
import io.skylite.core.env.NodeEnvironment;
import io.skylite.core.indices.SystemIndexDescriptor;
import io.skylite.core.notifications.NotificationCore;
import io.skylite.core.notifications.NotificationCoreExtension;
import io.skylite.core.notifications.action.NotificationsActions;
import io.skylite.core.repositories.RepositoriesService;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.script.ScriptService;
import io.skylite.core.settings.ClusterSettings;
import io.skylite.core.settings.IndexScopedSettings;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.Settings;
import io.skylite.core.settings.SettingsFilter;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.notifications.NotificationCoreImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.rest.RestController;
import org.opensearch.watcher.ResourceWatcherService;

public class NotificationModulePlugin
extends Plugin
implements ActionPlugin,
ExtensiblePlugin,
ReloadablePlugin,
SystemIndexPlugin {
    private static final Logger log = LogManager.getLogger(NotificationModulePlugin.class);
    public static final String PLUGIN_NAME = "lucenia-notifications";
    public static final String LOG_PREFIX = "notifications";
    public static final String PLUGIN_BASE_URI = "/_plugins/_notifications";
    public static final String TEXT_QUERY_TAG = "text_query";
    private ClusterService clusterService;

    public List<Setting<?>> getSettings() {
        log.debug("{}:getSettings", (Object)LOG_PREFIX);
        return List.copyOf(Stream.concat(io.skylite.notifications.setting.PluginSettings.getAllSettings().stream(), PluginSettings.getAllSettings().stream()).toList());
    }

    public Collection<SystemIndexDescriptor> getSystemIndexDescriptors(Settings settings) {
        return Collections.singletonList(new SystemIndexDescriptor(".opensearch-notifications-config", "System index for storing notification channels related configurations."));
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<RepositoriesService> repositoriesServiceSupplier) {
        log.debug("{}:createComponents", (Object)LOG_PREFIX);
        this.clusterService = clusterService;
        Settings settings = environment.settings();
        HashMap<String, String> sdkSettings = new HashMap<String, String>();
        sdkSettings.put("remote_metadata_type", (String)PluginSettings.REMOTE_METADATA_STORE_TYPE.get(settings));
        sdkSettings.put("remote_metadata_endpoint", (String)PluginSettings.REMOTE_METADATA_ENDPOINT.get(settings));
        sdkSettings.put("remote_metadata_region", (String)PluginSettings.REMOTE_METADATA_REGION.get(settings));
        sdkSettings.put("remote_metadata_service_name", (String)PluginSettings.REMOTE_METADATA_SERVICE_NAME.get(settings));
        sdkSettings.put("tenant_aware", "false");
        MetadataClient sdkClient = MetadataClientFactory.createSdkClient((ReleasableSkyliteClient)new SecureIndexClient(client), (NamedXContentRegistry)xContentRegistry, sdkSettings, (Executor)client.threadPool().executor("generic"));
        io.skylite.notifications.setting.PluginSettings.addSettingsUpdateConsumer((ClusterService)clusterService);
        PluginSettings.addSettingsUpdateConsumer(clusterService);
        CoreProvider.initialize((NotificationCore)NotificationCoreImpl.INSTANCE);
        NotificationConfigIndex.initialize(sdkClient, client, clusterService);
        ConfigIndexingActions.initialize(NotificationConfigIndex.INSTANCE, UserAccessManager.INSTANCE);
        SendMessageActionHelper.initialize(NotificationConfigIndex.INSTANCE, UserAccessManager.INSTANCE);
        return Collections.emptyList();
    }

    public List<ActionPlugin.ActionHandler> getActions() {
        log.debug("{}:getActions", (Object)LOG_PREFIX);
        return Arrays.asList(new ActionPlugin.ActionHandler(SendTestNotificationAction.ACTION_TYPE, SendTestNotificationAction.class, new Class[0]), new ActionPlugin.ActionHandler(NotificationsActions.CREATE_NOTIFICATION_CONFIG_ACTION_TYPE, CreateNotificationConfigAction.class, new Class[0]), new ActionPlugin.ActionHandler(NotificationsActions.UPDATE_NOTIFICATION_CONFIG_ACTION_TYPE, UpdateNotificationConfigAction.class, new Class[0]), new ActionPlugin.ActionHandler(NotificationsActions.DELETE_NOTIFICATION_CONFIG_ACTION_TYPE, DeleteNotificationConfigAction.class, new Class[0]), new ActionPlugin.ActionHandler(NotificationsActions.GET_NOTIFICATION_CONFIG_ACTION_TYPE, GetNotificationConfigAction.class, new Class[0]), new ActionPlugin.ActionHandler(NotificationsActions.GET_CHANNEL_LIST_ACTION_TYPE, GetChannelListAction.class, new Class[0]), new ActionPlugin.ActionHandler(NotificationsActions.GET_PLUGIN_FEATURES_ACTION_TYPE, GetPluginFeaturesAction.class, new Class[0]), new ActionPlugin.ActionHandler(NotificationsActions.SEND_NOTIFICATION_ACTION_TYPE, SendNotificationAction.class, new Class[0]), new ActionPlugin.ActionHandler(NotificationsActions.LEGACY_PUBLISH_NOTIFICATION_ACTION_TYPE, PublishNotificationAction.class, new Class[0]));
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        log.debug("{}:getRestHandlers", (Object)LOG_PREFIX);
        ArrayList<RestHandler> handlers = new ArrayList<RestHandler>();
        handlers.add((RestHandler)new NotificationConfigRestHandler());
        handlers.add((RestHandler)new NotificationFeaturesRestHandler());
        handlers.add((RestHandler)new NotificationChannelListRestHandler());
        handlers.add((RestHandler)new SendTestMessageRestHandler());
        return handlers;
    }

    public void reload(Settings settings) {
        io.skylite.notifications.setting.PluginSettings.setDestinationSettings((Map)io.skylite.notifications.setting.PluginSettings.loadDestinationSettings((Settings)settings));
    }

    public void loadExtensions(ExtensiblePlugin.ExtensionLoader loader) {
        log.debug("{}:load extension", (Object)LOG_PREFIX);
        for (NotificationCoreExtension extension : loader.loadExtensions(NotificationCoreExtension.class)) {
            extension.setNotificationCore((NotificationCore)NotificationCoreImpl.INSTANCE);
        }
    }
}

